//       

/*--
usage:
row(s, r1, r2, ...)

gets row(s) from a sample, result is of type stats::sample
--*/
/*--
parameters:
s  stats::sample
r1 row index (all further indices are optional), range-indices allowed
--*/

stats::row := proc(s, r)
begin
  if testargs() then
    if args(0) < 2 then
      error("Wrong number of arguments")
    end_if;
    if domtype(s) <> stats::sample then 
      error("1st argument: expecting a stats::sample")
    end_if;
    if has(map([args(2..args(0))], proc() begin bool( // tests row index/indices 
                                  (    testtype(args(1), DOM_INT)
                                   and 0 < args(1) 
                                   and args(1) <= nops(s))
                               or // test for ranges 
                                  (    testtype(args(1), "_range")
                                   and 0 < op(args(1), 1)
                                   and op(args(1), 2) <= nops(s))
                                        ) end_proc ), FALSE)
    then
      error("Invalid row index")
    end_if
  end_if;
  new(stats::sample, [(stats::sample)::row2list(args())])
end_proc:


// end of file 
 
