//       

/*--
stats::sample, domain for statistical data

methods:
print, fastprint, expr, equal, random, prep_list, convert, 
convert_to, _concat, append, _index, set_index, row2list, col2list, 
delRow, delCol, op, subsop, nops, map, float, has
--*/

domain stats::sample
  inherits Dom::BaseDomain;

  category Cat::BaseCategory;

  axiom Ax::canonicalRep;

/*--
  size --  the sample size (the number of rows)
           It coincides with the method 'nops',
           but 'size' is the appropriate statistical
           terminology
--*/
  size := proc(sa : dom)
  begin
    if args(0) <> 1 then
       error("expecting one argument");
    end_if;
    return(nops(extop(sa, 1)));
  end_proc;

/*--
   print  --  print samples 
--*/
  print := proc(sa : dom)
     local s, i, j, k, sl, ps;
   begin
     s:=map(extop(sa, 1), map, expr2text);
     if s = [] then return() end_if;
     /*sl:=[$ 1..nops(op(s,1))];
 
     sl:=map(sl, fun(block(k, (k:=args(1);  max(op(map(s, fun(length(op(args(1), k))))))))));
     ** or:*/
     sl:=[];
     for j from 1 to nops(op(s,1)) do 
       sl:=append(sl, max(op(map(s, proc() begin length(op(args(1), j)) end_proc ))))
     end_for;
     //
     
     ps:="";
     for i from 1 to nops(s) do
       for j from 1 to nops(op(s,1)) do

         if s[i][j][1] = "\"" then
           ps:=ps.s[i][j]."  ";
           for k from 1 to sl[j] - length(s[i][j]) do
             ps:=ps." "
           end_for
         else
           for k from 1 to sl[j] - length(s[i][j]) do
             ps:=ps." "
           end_for;
           ps:=ps.s[i][j]."  ";
         end_if

       end_for;
       ps:=ps."\n"
     end_for;
     stdlib::Exposed(ps)
   end_proc;

/*--
   fastprint  --  print large samples 
--*/
  fastprint := proc(sa : dom)
     local s, i, j, ps;
   begin
     s:=map(extop(sa, 1), map, expr2text);

     ps:="";
     for i from 1 to nops(s) do
       for j from 1 to nops(op(s,1)) do
         ps:=ps.s[i][j]."\t";
       end_for;
       ps:=ps."\n"
     end_for;
     print(Unquoted, ps)
   end_proc;

/*--
   expr -- returns the sample as an element of DOM_LIST, whereby
           each entry is converted to an expression.
--*/
  expr := proc() begin 
     map(extop(args(1)), expr)
    end_proc;

/*--
   equal -- test if two samples are equal
--*/
   equal := proc(s1 : dom, s2 : dom)
   begin
     if extop(s1, 1) <> extop(s2, 1) then
       return(FALSE)
     else
       return(TRUE)
     end_if
   end_proc;

/*--
   random -- not necessary for samples
--*/
  random := proc()
  begin
    FAIL
  end_proc;

/*--
   prep_list -- test and prepare list to be converted to a sample 
--*/
  prep_list := proc(li : DOM_LIST)
     local l, c, i;
   begin
     l:=li;
     if nops(l) = 0 then error ("rows expected") end_if;  
     // convert to list of rows (lists) if one element of l is not a row         
     if has(map(l, proc() begin testtype(args(1), DOM_LIST) end_proc ), FALSE) then
       l:=map(l, proc() begin [args(1)] end_proc )
     end_if;
     // test if all rows of same length                                          
     c:=nops(l[1]); // number of columns := length of first row 
     if has(map(l, proc() begin bool(nops(args(1)) = c) end_proc ), FALSE) then
       error("Length of all rows not equal")
     end_if;
     // converts every column containing not only elements of type DOM_INT,      
     // DOM_RAT, DOM_FLOAT, DOM_EXPR or DOM_IDENT to a column of strings.        
     // this results in 2 kinds of columns: data- and string-columns!            
     for i from 1 to c do 
       if has(map(l, proc() begin 
                         (testtype(args(1)[i], DOM_INT) or
                          testtype(args(1)[i], DOM_RAT) or
                          testtype(args(1)[i], DOM_FLOAT) or
                          testtype(args(1)[i], DOM_COMPLEX) or
                          testtype(args(1)[i], DOM_EXPR) or
                          testtype(args(1)[i], DOM_IDENT)
             ) end_proc ), FALSE) then
         l:=map(l, proc() begin (if not testtype(args(1)[i], DOM_STRING) then
                          subsop(args(1), i = expr2text(args(1)[i]))
                        else
                          args(1)
                        end_if) end_proc )
       end_if
     end_for;
     return(l)
   end_proc;

/*--
   convert -- convert an expression to a sample 
--*/
  convert := proc() begin (
     if args(0) > 1 then
       FAIL
     elif args(0) < 1 then
       new(dom, []);
     else
       case domtype(args(1))
       of dom do // if already sample, then convert again to check integrity 
         dom::convert(extop(args(1), 1)); break;
       of DOM_LIST do
         new(dom, [op(dom::prep_list(args(1)))]); break;
       of DOM_ARRAY do //array to list of lists
         error("Converting of DOM_ARRAY to ".expr2text(dom)." not implemented yet");
       of DOM_TABLE do //table to list of lists
         error("Converting of DOM_TABLE to ".expr2text(dom)." not implemented yet");
       otherwise
         userinfo(1, "Unable to convert ".expr2text(domtype(args(1)))." to ".expr2text(dom));
         FAIL
       end_case
     end_if
   ) end_proc ;

/*--
   convert_to -- converts a sample to DOM_LIST, DOM_ARRAY, ...
--*/
  convert_to := proc() begin (
     if args(0) <> 2 or domtype(args(1)) <> dom then 
       FAIL
     else
       case args(2)
       of dom do // if convert sample to sample, then convert again to check integrity 
         dom::convert(extop(args(1), 1)); break;
       of DOM_LIST do
         extop(args(1), 1); break;
       of DOM_ARRAY do //array to list of lists
         error("Converting of ".expr2text(dom)." to DOM_ARRAY not implemented yet");
       of DOM_TABLE do //table to list of lists
         error("Converting of ".expr2text(dom)." to DOM_TABLE not implemented yet");
       otherwise
         userinfo(1, "Unable to convert ".expr2text(dom)." to ".expr2text(args(2)));
         FAIL
       end_case
     end_if;
   ) end_proc ;

/*--
   _concat -- builds new sample using the rows of old samples
--*/
  _concat := proc(sa1, sa2)
     local s1, s2;
   begin
     if testargs() then
       if has(map([args()], proc() begin ( 
                 if not(domtype(args(1)) = dom or domtype(args(1)) = DOM_LIST) then 
                   FALSE 
                 end_if ) end_proc ), FALSE)
       then
         error("All arguments must be of type sample or list")
       end_if
     end_if;

     if args(0) = 1 then
       return(sa1)
     elif args(0) > 2 then // iterative calling of _concat if more than 2 arguments 
       return(dom::_concat(sa1, dom::_concat(sa2, args(3..args(0)))))
     end_if;

     s1:=sa1; s2:=sa2;

     if domtype(s1) = DOM_LIST then // testtype() would be a bad idea (not only) here! 
       s1:=dom([s1]); // list to sample (list as row) 
     end_if;
     if domtype(s2) = DOM_LIST then
       s2:=dom([s2]); // list to sample (list as row) 
     end_if;

     _concat(extop(s1, 1), extop(s2, 1)); // _concat as on lists of lists 
     dom(last(1))  // list to sample and testing if all rows of same length, etc. 
   end_proc;

/*--
   append -- appends row to sample
--*/
  append := proc(s : dom, l)
   begin
     if args(0) = 1 then
       return(s)
     end_if;

     if testargs() then
       if domtype(l) <> DOM_LIST then
         error("Illegal argument")
       end_if;
       if args(0) > 2 then
         error("Wrong number of arguments")
       end_if
     end_if;

     extop(s, 1);  // sample to list 
     append(last(1), l);
     dom(last(1))  // list to sample and testing if all rows of same length, etc. 
   end_proc;

/*--
   _index -- indexing of samples (no range indices allowed)
--*/
  _index := proc() begin (
     case args(0)
     of 3 do
       _index(_index(extop(args(1), 1), args(2)), args(3)); break;
     of 2 do
       if nops(extop(args(1), 1)) = 1 then // sample = single row 
         _index(_index(extop(args(1), 1), 1), args(2)); break;
       elif nops(op(extop(args(1), 1), args(2))) = 1 then // sample = single column 
         _index(_index(extop(args(1), 1), args(2)), 1); break;
       end_if
     otherwise
       error("Wrong number of indices")
     end_case
   ) end_proc ;

/*--
   set_index  --  indexing of samples 
--*/
  set_index := proc() begin (
     case args(0)
     of 4 do
       if args(2) > nops(extop(args(1), 1)) or
          args(3) > nops(op(extop(args(1), 1), 1)) then
         error("Invalid index")
       end_if;
       extsubsop(args(1), 1 = subsop(extop(args(1), 1), args(2) =
         //substitute in row (no. args(2)) 
         subsop(op(extop(args(1), 1), args(2)), args(3) = args(4))
       )); break;

     of 3 do
       if nops(extop(args(1), 1)) = 1 then // sample = single row 
         if args(2) > nops(op(extop(args(1), 1), 1)) then
           error("Invalid index")
         end_if;
         extsubsop(args(1), 1 = subsop(extop(args(1), 1), 1 =
           //substitute in row (no. 1) 
           //extsubsop(args(1), 1 =
             subsop(op(extop(args(1), 1), 1), args(2) = args(3))//)
         )); break;

       elif nops(op(extop(args(1), 1), args(2))) = 1 then // sample = single column 
         if args(2) > nops(extop(args(1), 1)) then
           error("Invalid index")
         end_if;
         extsubsop(args(1), 1 = subsop(extop(args(1), 1), args(2) =
           //substitute in row (no. args(2)) 
           //extsubsop(args(1), 1 = 
             subsop(op(extop(args(1), 1), args(2)), 1 = args(3))//)
         )); break;
       end_if
     otherwise
       error("Wrong number of arguments")
     end_case
   ) end_proc ;

/*--
   row2list, col2list  --  get row(s)/column(s) from a sample, 
                           result is of type DOM_LIST (or sequence of DOM_LIST) 
--*/
  row2list := proc(s : dom , r)
   begin
     if testargs() then
       if args(0) < 2 then 
         error("Wrong number of arguments")
       end_if;
       if domtype(s) <> dom then 
         error("Sample expected")
       end_if;
       if has(map([args(2..args(0))], proc() begin bool( // tests row index/indices 
                                         (    testtype(args(1), DOM_INT)
                                          and 0 < args(1) 
                                          and args(1) <= nops(s))
                                      or // test for ranges 
                                         (    testtype(args(1), "_range")
                                          and 0 < op(args(1), 1)
                                          and op(args(1), 2) <= nops(s))
                                               ) end_proc ), FALSE)
       then
         error("Invalid row index")
       end_if
     end_if;
     // transform all ranges to sequences 
     if type(r) = "_range" then
       return(dom::row2list(s, $ r, args(3..args(0))))
     end_if;
     if args(0) > 2 then 
       return(op(extop(s, 1), r), dom::row2list(s, args(3..args(0))))
     end_if;
     op(extop(s, 1), r)
   end_proc;

  col2list := proc(s : dom , c)
   begin
     if testargs() then
       if args(0) < 2 then 
         error("Wrong number of arguments")
       end_if;
       if domtype(s) <> dom then 
         error("Sample expected")
       end_if;
       if has(map([args(2..args(0))], proc() begin bool( // tests column index/indices 
                                         (    testtype(args(1), DOM_INT) 
                                          and 0 < args(1) 
                                          and args(1) <= nops(op(s, 1)))
                                      or // test for ranges 
                                         (    testtype(args(1), "_range")
                                          and 0 < op(args(1), 1)
                                          and op(args(1), 2) <= nops(op(s, 1)))
                                               ) end_proc ), FALSE)
       then
         error("Invalid column index")
       end_if
     end_if;
     // transform all ranges to sequences 
     if type(c) = "_range" then
       return(dom::col2list(s, $ c, args(3..args(0))))
     end_if;
     if args(0) > 2 then 
       return(map(extop(args(1), 1), proc() begin op(args(1), c) end_proc ),
                  dom::col2list(args(1), args(3..args(0))))
     end_if;
     map(extop(args(1), 1), proc() begin op(args(1), c) end_proc )
   end_proc;

/*--
   delRow, delCol  --  delete row, delete column
--*/
  delRow := proc(sa : dom)
     local s, r;
   begin
     if testargs() then
       if args(0) < 2 then 
         error("Wrong number of arguments")
       end_if;
       if domtype(sa) <> dom then 
         error("Sample expected")
       end_if;
       if has(map([args(2..args(0))], proc() begin bool( // tests row index/indices 
                                         (    testtype(args(1), DOM_INT)
                                          and 0 < args(1) 
                                          and args(1) <= nops(sa))
                                      or // test for ranges 
                                         (    testtype(args(1), "_range")
                                          and 0 < op(args(1), 1)
                                          and op(args(1), 2) <= nops(sa))
                                               ) end_proc ), FALSE)
       then
         error("Invalid row index")
       end_if
     end_if;

     r:=[args(2..args(0))];
     // transform all ranges to sequences 
     r:=map(r, proc() begin (if type(args(1)) = "_range" then
                        $ args(1)
                      else
                        args(1)
                      end_if) end_proc );

     s:=extop(sa, 1); // sample2list 
     map(r, proc() begin (s[args(1)]:=FALSE) end_proc ); // go via FALSE to ensure future compatibility 
     s:=map(s, proc() begin (if args(1) = FALSE then null() else args(1) end_if) end_proc );
/*    map(r, fun((s[args(1)]:=null())));*/ // directly 
     s:=map(s, eval); // remove null() 
     if nops(s) = 0 then
       NIL
     else
       new(dom, s)  // list2sample 
     end_if
   end_proc;

  delCol := proc(sa : dom)
     local s, c;
   begin
     if testargs() then
       if args(0) < 2 then 
         error("Wrong number of arguments")
       end_if;
       if domtype(sa) <> dom then 
         error("Sample expected")
       end_if;
       if has(map([args(2..args(0))], proc() begin bool( // tests column index/indices 
                                         (    testtype(args(1), DOM_INT) 
                                          and 0 < args(1) 
                                          and args(1) <= nops(op(sa, 1)))
                                      or // test for ranges 
                                         (    testtype(args(1), "_range")
                                          and 0 < op(args(1), 1)
                                          and op(args(1), 2) <= nops(op(sa, 1)))
                                               ) end_proc ), FALSE)
       then
         error("Invalid column index")
       end_if
     end_if;

     c:=[args(2..args(0))];
     // transform all ranges to sequences 
     c:=map(c, proc() begin (if type(args(1)) = "_range" then
                        $ args(1)
                      else
                        args(1)
                      end_if) end_proc );

     s:=extop(sa, 1); // sample2list 
     map(c, proc() local i; begin i:=args(1);
                           map([$ 1..nops(s)], proc() begin (s[args(1)][i]:=FALSE) end_proc )
         end_proc ); // go via FALSE to ensure future compatibility 
     s:=map(s, map, proc() begin (if args(1) = FALSE then null() else args(1) end_if) end_proc );
/*    map(c, fun((block(i ,(i:=args(1);
                           map([$ 1..nops(s)], fun((s[args(1)][i]:=null())))
        )))));*/ // directly 
     s:=map(s, map, eval); // remove null() 
     if nops(op(s, 1)) = 0 then
       NIL
     else
       new(dom, s)  // list2sample 
     end_if
   end_proc;

/*--
   op, subsop, nops, ...  --  overload those functions as they operate on lists
--*/
  op := proc() begin 
     op(extop(args(1), 1), args(2..args(0)))
    end_proc ;

  subsop := proc() begin 
     extsubsop(args(1), 1 = subsop(extop(args(1), 1), args(2..args(0))))
    end_proc ;

  nops := proc() begin 
     nops(extop(args(1), 1))
    end_proc ;

  map := proc() begin 
     // this(map(extop(args(1), 1), args(2..args(0)))) see "float" 
     new(dom, map(extop(args(1), 1), args(2..args(0))))
    end_proc ;

  float := proc() begin 
     // this(float(extop(args()))) bad choice if data-column contains FAIL 
     new(dom, float(extop(args())))
    end_proc ;

  has := proc() begin 
     has(extop(args(1), 1), args(2))
    end_proc ;


/*
  expand := proc() begin
     extsubsop(args(1), 1 = map(extop(args(1), 1), expand, args(2..args(0))))
  end_proc;
*/

end_domain:


// end of file 
 
