//       

/*--
usage:
selectRow(s, c, m, cal)

selects rows with element(s) m in column(s) c.
with the optional parameter cal= Not those rows are selected that don't
have the specified elements.
--*/
/*--
parameters:
s   stats::sample
c   column index ((list of) integer(s)), range-indices allowed
m   (list of) element(s)
cal optional, only 'Not' allowed
--*/

stats::selectRow := proc(sa, co, mu, cal) 
  local s, c, m;
begin
  if testargs() then
    if args(0)<3 then
      error("Wrong number of arguments")
    end_if
  end_if;
  s:=sa; 
  c:=co; 
  m:=mu;
  // transform ranges to sequence 
  if not testtype(c, DOM_LIST) then c:=[c] end_if;
  c:=map(c, proc() begin (if type(args(1)) = "_range" then
                    $ args(1);
                  else
                    args(1)
                  end_if) end_proc );
  if not testtype(m, DOM_LIST) then m:=[m] end_if;
  if testargs() then
    if domtype(s) <> stats::sample then
      error("stats::sample expected")
    end_if;
    if args(0) < 3 or 4 < args(0) then
      error("Wrong number of arguments")
    end_if;
    if not testtype(c, DOM_LIST) then c:=[c] end_if;
    if has(map(c, proc() begin bool(testtype(args(1), DOM_INT) 
                         and 0 < args(1) and args(1) <= nops(op(s, 1))
                         ) end_proc ), FALSE)
                   // if at least one element of c is not of type DOM_INT  
                   // or < 1 or > number of columns                        
    then   
      error("Invalid column index") 
    end_if;
    if nops(m) <> nops(c) then
      error("Wrong number of columns")
    end_if
  end_if;

  // actual procedure 
  s:=(stats::sample)::convert_to(s, DOM_LIST); // sample to list 
  if args(0) = 4 then
    if cal = Not then
      select(s, proc() local n; begin [];        // list of specified row elements 
                              for n in c do 
                                append(last(1), op(args(1), n))
                              end_for;
                              _not(bool(last(1) = m)) end_proc );
                                             // compare list and m, negate 
      if last(1) = [] then
        new(stats::sample, [last(1)]) // sample has to have at least one row 
      else
        new(stats::sample, last(1))
      end_if
    else
      error("Invalid fourth parameter (option 'Not' expected)")
    end_if
  else
    select(s, proc() local n; begin [];          // list of specified row elements 
                            for n in c do 
                              append(last(1), op(args(1), n))
                            end_for;
                            bool(last(1) = m) end_proc ); // compare list and m   
    if last(1) = [] then
      new(stats::sample, [last(1)]) // sample has to have at least one row 
    else
      new(stats::sample, last(1))
    end_if
  end_if
end_proc:


// end of file 
 
