//       

/*--
usage:
sortSample(s, c1, c2, ...) / sortSample(s, c)

sorts sample-rows with respect to specified column(s)
(order of specification is significant!)
--*/
/*--
parameters:
s      stats::sample
c1, c2 column indices (all optional), range-indices allowed
c      list of column indices (optional), range-indices allowed
--*/

stats::sortSample := proc(sa, co) 
  local s, c, i;
begin
  if testargs() then
    if args(0) < 1 then
      error("Wrong number of arguments")
    end_if;
    if domtype(sa) <> stats::sample then 
      error("stats::sample expected")
    end_if;
    if args(0) > 1 
       and has(map(co, proc() begin bool( // tests column index/indices 
                                  (    testtype(args(1), DOM_INT) 
                                   and 0 < args(1) 
                                   and args(1) <= nops(op(sa, 1)))
                               or // test for ranges 
                                  (    testtype(args(1), "_range")
                                   and 0 < op(args(1), 1)
                                   and op(args(1), 2) <= nops(op(sa, 1)))
                                        ) end_proc ), FALSE)
    then
      error("Invalid column index")
    end_if
  end_if;

  s:=sa; 
  if args(0)>1 then c:=co; end_if;
  if not(args(0) = 2 and domtype(c) = DOM_LIST) and args(0) > 1 then
    c:=[args(2..args(0))]
  end_if;

  if args(0) = 1 then
    c:=[$ 1..nops(op(s, 1))]
  else
    // transform ranges to sequence 
    c:=map(c, proc() begin (if type(args(1)) = "_range" then
                                      $ args(1);
                                    else
                                      args(1)
                                    end_if) end_proc );
  end_if;

  // actual procedure 
  s:=[stats::sample2list(s)]; // list containing one list of rows 
  for i in c do
  //for i from 1 to nops(op(s, [1,1])) do
    s:=map(s, proc() local k, x, y; begin (
      if nops(args(1)) = 1 then
        // if only one row in list -> nothing to sort here 
        args(1)
      else 
        // sort rows in list with respect to i-th column 
        ((
          y:=[];

          // actual sorting 
          x:=sort(args(1), proc() begin sort([op(args(1), i), op(args(2), i)]) 
                                = [op(args(1), i), op(args(2), i)]
                             /* use sort to decide order of 2 arguments */ end_proc );

          // gathering of rows with identical i-th elements 
          for k from 1 to nops(x) do
            if op(x, [k, i]) = op(x, [k-1, i]) then
              y:=subsop(y, nops(y) = append(op(y, nops(y)), op(x, k))) 
            else
              y:=append(y, [op(x, k)])
            end_if
          end_for;

          op(y) // sequence of lists of rows 
        ))
      end_if
    ) end_proc ) // s = list of list of rows 
  end_for; // s = list of list of identical rows 
  stats::sample(map(s, op)) // stats::sample(list of rows) 
end_proc:

// end of file 
 
