//       

/*--
usage:
testdata(opt, l) / testdata(opt, s, c)

internal procedure, required by procedures like getdata to
test arguments / elements of arguments.
if a data-column of a sample is specified, the column index is verified
option "anything":
                allows arbitrary MuPAD objects
option "all_data":
                allows DOM_INT, DOM_FLOAT, DOM_COMPLEX, DOM_RAT, DOM_EXPR, DOM_IDENT
option "numeric_only":
                allows DOM_INT, DOM_FLOAT, DOM_COMPLEX, DOM_RAT
if called by a procedure or function, all errors are returned as
strings. if no errors are found, TRUE is returned.
--*/
/*--
parameters:
opt option, "anything" or "all_data" or "numeric_only"
l   list or sequence
s   stats::sample
c   data-column index (optional if sample contains only one row)
--*/

stats::testdata := proc(opt, l, co)
  local c, err;
begin
  if testargs() then // return errors as errors 
    err:=error;
    if args(0) < 2 then
       error("wrong number of arguments");
    end_if;
    if opt <> "all_data" and 
       opt <> "numeric_only" and
       opt <> "anything" then 
      error("unknown option, expecting 'all_data' or 'numeric_only'.")
    end_if
  else // return errors as strings (if testdata is called by procedure) 
    err:= return
  end_if;

/*
  floatconvert:= proc(x)
  begin
      if domtype(x) = DOM_EXPR or contains(Type::ConstantIdents, x)
      then float(x)
      else x;
      end_if;
  end_proc;
*/

  if domtype(l) = stats::sample then
    case args(0)
    of 2 do // 1 + opt : no column specified 
      if nops(op(l, 1)) <> 1 then
        err("wrong number of arguments")
      end_if; 
      c:=1;
      break;
    of 3 do // 2 + opt : column specified 
      c:=co;
      if (not testtype(c, DOM_INT)) or 
         (c < 1) or 
         (nops(op(l, 1)) < c) then
        err("invalid data-column index")
      end_if; 
      if opt <> "anything" then
        if (domtype(op(l, [1, c])) = DOM_STRING) then
          err("column ".expr2text(c). 
              " does not seem to be a data column"):
        end_if;
      end_if;
      break;
    otherwise
      err("wrong number of arguments")
    end_case;
    if opt = "numeric_only" then
      // convert expressions to floats
/*
      l:= map(l, map, floatconvert);
      // double check that all entries are numerical
      if has(map(stats::sample2list(l), proc() begin 
                        testtype(op(args(1), c), DOM_INT) 
                     or testtype(op(args(1), c), DOM_FLOAT) 
                     or testtype(op(args(1), c), DOM_COMPLEX) 
                     or testtype(op(args(1), c), DOM_RAT) 
                                        end_proc ), FALSE) then 
        err("invalid operand: integers, rationals or floats expected")
      end_if;
*/
      // Pick out column c of the data sample l, convert to floats
      // and check that everything was floatable:
      // Do not use
      // l:= {op( map(l::dom::col2list(l, c), domtype@float))}:
      // because stats::sample2list is much faster than
      // stats::sample::col2list !!!
      l:= {op(map(stats::sample2list(l), domtype@float@op, c))};
      if l minus {DOM_FLOAT, DOM_COMPLEX} <> {} then
        err("invalid operand: integers, rationals or floats expected")
      end_if;
    end_if
  else // "all_data" or "anything"
    if domtype(l) = DOM_LIST then
      if args(0) <> 2 then // 1 + opt 
        err("wrong number of arguments")
      end_if;
    else // sequence to list 
      l:=[args(2..args(0))]; // exclude opt from sequence 
    end_if;
    case opt
    of "all_data" do
      if has(map(l, proc() begin
                     _lazy_or(
                              testtype(args(1), DOM_FLOAT),
                              testtype(args(1), DOM_COMPLEX), 
                              testtype(args(1), DOM_INT), 
                              testtype(args(1), DOM_RAT), 
                              testtype(args(1), DOM_EXPR),
                              testtype(args(1), DOM_IDENT),
                              testtype(args(1), "_index")
                             )
                    end_proc), FALSE) then 
        err("invalid operand: integers, rationals, floats, " .
            "or symbolic expressions expected");
      end_if; break;
    of "numeric_only" do
      // convert expressions to floats

      if domtype(l[1]) = DOM_LIST then // l is a list of lists
           // l:= map(l, map, floatconvert);
           l:= map(l, x -> {op(map(x, domtype@float))}):
           l:= _union(op(l));
      else // l:= map(l, floatconvert);
           l:= map({op(l)}, domtype@float):
      end_if:
/*
      if has(map(l, proc() begin
                        testtype(args(1), DOM_INT) 
                     or testtype(args(1), DOM_FLOAT) 
                     or testtype(args(1), DOM_COMPLEX) 
                     or testtype(args(1), DOM_RAT) end_proc ), FALSE) then 
*/
      if l minus {DOM_FLOAT, DOM_COMPLEX} <> {} then
        err("invalid operand: integers, rationals or floats expected")
      end_if;
    end_case
  end_if; 
  return(TRUE)
end_proc:

// end of file 
