//       

/*--
usage:
unzipCol(l)

the sub-lists' elements are gathered in lists according to their
element index. these lists form the resulting sequence.
--*/
/*--
parameters:
l  list of lists
--*/

stats::unzipCol:=proc(l)
  local i;
begin
  if testargs() then
    if args(0) <> 1 then
      error("Wrong number of arguments")
    end_if;
    if domtype(l) <> DOM_LIST
       or op(l) = null()
       or has(map([op(l)], proc() begin bool(domtype(args(1)) = DOM_LIST
                                           ) end_proc ), FALSE)
    then
      error("Argument must be list of lists")
    end_if
  end_if;
  [];
  for i from 1 to max(0, op(map(l, proc() begin nops(args(1)) end_proc ))) do
    append(last(1), map(l, proc() begin op(args(1), i) end_proc ))
  end_for;
  op(last(1))
end_proc:


// end of file 
 
 
