
/* exp(a)*exp(b) ==> exp(a+b) (universally valid)
   exp(a)^b      ==> exp(a*b) (if b in Z or -PI < Im(a) <= PI)
     reason: exp(a)^b = exp(b*ln(exp(a)))
*/
combine::exp:=
proc(e, options)
local x;
begin
  case type(e)
    of "_plus" do
    of "_mult" do
    of "_power" do
      e:= map(e, combine::exp, options)
  end_case;

   case type(e)
     of "_mult" do
       x:=split(e,testtype,"exp");
       if type(x[1]) = "_mult" then
         return(x[2]*exp(_plus(map(op(x[1]),op))))
       end_if;
       break;
   of "_power" do 
       if type((x:=op(e,1)))="exp" then
         if options[IgnoreAnalyticConstraints] or
           is(op(e, 2) in Z_, Goal = TRUE) or
           is(-PI < Im(op(x)) <= PI, Goal = TRUE) then
           return(exp(op(x)*op(e,2)))
         end_if;
       end_if;
   end_case;
   e
 end_proc:
 
 // end of file
 