
/*
_mult::combine(a1, ..., an)

combines a1*...*an
using the rules
x^a * x^b = x^(a+b)
and
a^x * b^x = (a*b)^x (where appropriate, by calling combine::_power)


*/


_mult::combine:=
proc(e: "_mult", options = combine::defaultOptions: DOM_TABLE)
begin
  if type(op(e, 1)) = "_seqgen" then
     return(e)
  end_if;

  e:= map(e, combine, options);
  if type(e) <> "_mult" then
    return(e)
  end_if;

  if type(e) = piecewise then
    return(piecewise::extmap(e, x -> if type(x) = "_mult" then
                                       _mult::combine(x, options)
                                     else
                                       x
                                     end_if
                             )
           )
  end_if;

  if type(e) <> "_mult" then
    return(e)
  end_if;

  e:= combine::combineExponents(e, options);
  
  
  if type(e) <> "_mult" then
    return(e)
  end_if;
  

  if hastype(e, "_power") then
    return(combine::_power(e, options))              
  else
    return(e)
  end_if;

  
end_proc:

// end of file 


