
// _power::combine(a)


_power::combine:=
proc(a: "_power", options = combine::defaultOptions: DOM_TABLE)
  local p, k, flag, l, f;
begin
  [l, f]:= [op(a)];
  l:= combine(l, options);
  f:= combine(f, options);

  
  // powers of zero
  if l=0 then
    return(piecewise([f = 0, 1], [f>0, 0]))
  end_if;
  
  
  // rewrite (a^b)^c --> a^(b*c) if
  // * c in Z or
  // * a >= 0 and b in R or
  // * Re(a) > 0 and -2 <= b <= 2 or
  // * -1 < b <= 1 or (b = -1 and not a < 0)
  if type(l) = "_power" then
    flag:= _lazy_or(options[IgnoreAnalyticConstraints],
                    is(f in Z_, Goal  = TRUE)
                    );
    if not flag and is(op(l, 2) in R_, Goal = TRUE) then
      if is(op(l, 1) >= 0) = TRUE then
        flag := TRUE;
      elif is(-2 <= op(l, 2) <= 2) = TRUE then
        if is(Re(op(l, 1)) > 0) = TRUE then
          flag := TRUE;
        elif is (-1 <= op(l, 2) <= 1) = TRUE then
          flag := is(op(l, 2) = -1) = FALSE
                  or is(op(l, 1) < 0) = FALSE;
        end_if;
      end_if;
    end_if;
    if flag then
      return(op(l, 1)^combine(op(l, 2)*f, options));
    end_if
  end_if;

  if domtype(l) = DOM_INT and (k:= numlib::ispower(l)) <> FALSE then
    return(op(k, 1)^(op(k, 2) *f) )
  end_if;

  if (p:= slot(combine,type(l))) <> FAIL then
    return( p(l^f, options) )
  end_if;

  return(l^f)
  
end_proc: