// conjugate(ln(x)) = ln(x) unless x is on the branch cut  

ln::conjugate:=
proc(x)
  local y;
begin
  case is(x<=0)
    of TRUE do
      return(ln(-x) - PI*I)
    of FALSE do  
      y:= conjugate(x);
      if type(y) = "conjugate" then
        return(hold(ln)(y))
      else
        return(ln(y))
      end_if
    of UNKNOWN do
      // should we return a piecewise here ??!
      return(hold(conjugate)(hold(ln)(x)))
    otherwise
      error("Unexpected result from is")
  end_case;
end_proc:
