//      
// kg, 10/08/93 

/*++
D -- differential operator

D(f)
D([i1,...,in], f)
D([],f)

f - expression
[i1,...,in] - list of positive integers

D(f) computes the derivative of the function f.
D([i],f) computes the partial derivative of f with respect to its i-th argument.
D([i,j],f) is equivalent to D([i],D([j],f)).
++*/

D:=
proc()
  local D;
begin

  D:=
  proc()
    name D;
    option remember;
    local idx, f, x, mapD, i, n, nidx;
  begin
  
  if args(0) = 1 then
    idx:= null();
    nidx:= 1;
    f:= args(1);
    mapD:= D;
  elif args(0) = 2 then
    idx:= args(1);
    if domtype(idx) <> DOM_LIST then
      error("invalid indices")
    end_if;
    nidx:= nops(idx);
    f:= args(2);
    mapD:= proc(f, i)
           begin
             D(i, f)
           end_proc;
  else
    error("wrong number of args")
  end_if;

  if nidx = 0 then
    return(f)
  end_if;
  
  if domtype(idx) = DOM_LIST then
    case map({op(idx)}, type)
    of {"_seqgen", DOM_INT} do
    of {"_seqgen"} do 
      return(procname(idx, f))
    of {DOM_INT} do 
      // ok
      break    
    otherwise  
      error("Indices must be positive integers")
    end_case 
  end_if;
  

    // partial derivatives are to commute. Give them
    // a canonical ordering:
  if domtype(idx) = DOM_LIST then
    idx:= sort(idx);
  end_if;

  case domtype(f)
    of DOM_LIST do
    of DOM_SET do
    of DOM_TABLE do
    of DOM_ARRAY do
      return(map(f, mapD, idx))

    of DOM_HFARRAY do
      // return a zero hfarray of the same format
      return(hfarray(op(f, [0, i]) $ i = 2 .. op(f, [0, 1]) + 1));

    of DOM_EXPR do
      break;
      
    of DOM_POLY do
      return(polylib::Dpoly(idx, f));
      
    of DOM_PROC do
      x:= [op(f,1)]; // the list of argumentes
      if domtype(idx) = DOM_LIST then
        if max(op(idx)) > nops(x) then
          error("function does not have that many arguments")
        end_if;
        return(stdlib::makeDop(f, x, idx))
      end_if;
      if nops(x) <> 1 then
        error("function has more than one argument")
      end_if;
      if type(op(f,4)) <> "_if" and
        traperror((n:=stdlib::makeDop(f, x)))=0 then return(n)
        /* else: try piecewise and 'diff'! */
      end_if;

      return(procname(idx, f));

    of DOM_EXEC do
      if domtype(idx) <> DOM_LIST then
        return(stdlib::makeDop(f, [genident()]))
      end_if;
      return(procname(idx, f));

    of DOM_FUNC_ENV do
      if slot(f, "D") <> FAIL then
        return(slot(f, "D")(idx, f))
      end_if;
      if contains({DOM_PROC, DOM_EXEC}, domtype(op(f,1))) then
        return(D(idx, op(f,1)))
      end_if;
      if domtype(idx) <> DOM_LIST then
        return(stdlib::makeDop(f, [genident()]))
      end_if;
      return(procname(idx, f));
      
    of DOM_IDENT do
      if testtype(f, Type::Constant) then
        return(0)
      end_if;
      return(procname(idx, f));

    otherwise
      return((if f::dom::D <> FAIL then
                f::dom::D
              else
                procname
              end_if)(idx, f));
  end_case;

  if nidx = 1 then
    case type(f)
      of "_negate" do
        return(-D(idx, op(f,1)));
        
      of "_plus" do
        return(map(f, mapD, idx));
        
      of "_subtract" do
        return(D(idx, op(f,1) - op(f,2)));
        
      of "_mult" do
        return(_plus(eval(subsop(f, i=D(idx,op(f,i))) $ i=1..nops(f))));
        
      of "_divide" do
        return(D(idx, op(f,1) / op(f,2)));
        
      of "_invert" do
        return(- op(f,1)^(-2) * D(idx, op(f,1)));
        
      of "_power" do
        if testtype(op(f,2), Type::Numeric) then
          return(op(f,2)*D(idx, op(f,1))*op(f,1)^(op(f,2)-1));
        end_if;
        return(procname(idx, f));
        
        //  return(D(idx, exp@(op(f, 1)*ln@op(f, 2)) ));

      of "_fconcat" do
        n:= nops(f);
        if domtype(idx) = DOM_LIST then
          return(_mult(D(idx, op(f,n)),
                       (_fconcat(D([1], op(f,i)), op(f, i+1..n))
                        $ i=1..n-1)));
        else
          return(_mult(D(idx, op(f,n)),
                       (_fconcat(D(op(f,i)), op(f, i+1..n))
                        $ i=1..n-1)));
        end_if;

      of "_index" do
        return(procname(idx, f));
    end_case;
  else
    case type(f)
      of "_negate" do
        return(-D(idx, op(f,1)));

      of "_plus" do
        return(map(f, mapD, idx));
        
      of "_subtract" do
        return(D(idx, op(f,1) - op(f,2)));

      of "_mult" do
        x:= idx[1];
        delete idx[1];
        return(D([x], _plus(eval(subsop(f, i=D(idx,op(f,i))) $ i=1..nops(f)))));

      of "_divide" do
        return(D(idx, op(f,1) / op(f,2)));

      of "_invert" do
        x:= idx[1];
        delete idx[1];
        return(D([x], - op(f,1)^(-2) * D(idx, op(f,1))));

      of "_power" do
        if testtype(op(f,2), Type::Numeric) then
          x:= idx[1];
          delete idx[1];
          return(D([x], op(f,2)*D(idx, op(f,1))*op(f,1)^(op(f,2)-1)));
        end_if;
        return(procname(idx, f));

        //  return(D(idx, exp@(op(f, 1)*ln@op(f, 2)) ));

      of "_fconcat" do
        n:= nops(f);
        x:= idx[1];
        delete idx[1];
        return(D([x], _mult(D(idx, op(f,n)),
                            (_fconcat(D([1], op(f,i)), op(f, i+1..n))
                             $ i=1..n-1))));

      of "_index" do
        return(procname(idx, f));
    end_case;
  end_if;

   /*--------------------------------------------------------------
   a) D([n1, n2, ..], D([m1, m2, ..], f)) --> D(sort([n1,..,m1,..], f)
   b) D([1, 1, ..], D(f)) --> D([1, 1, .., 1](f))
   c) D([n1, n2, ..], D(f))  yiels an error if not [n1, n2, ..] = [1, 1, ..]
   d) D(D(..(D(f))) --> unchanged
   e) D(D([1, 1, ..], f)) --> (D@@(n+1))(f)
   f) D(D([n1,n2,..], f)) yields an error if not [n1, n2, ..] = [1, 1, ..]
   --------------------------------------------------------------*/
    if type(f) = "D" then
      if domtype(idx) = DOM_LIST then // D([n1,..], D(..))
        if nops(f) = 2 then
          if domtype(op(f,1)) = DOM_LIST then
            /*a)*/
             return(procname(sort(idx.op(f,1)), op(f,2)))
          end_if;
        else // D([n1, n2, ..],  D(f))
          if {op(idx)} = {1} then
            /*b)*/
             return(procname(idx.[1], op(f, 1)))
/*c */    else error("univariate function ".expr2text(f).
                     " in multivariate D call");
          end_if;
        end_if
      else // domtype(idx) = DOM_NULL, i.e., D(D(..))
        if nops(f) = 2 and domtype(op(f, 1))= DOM_LIST then
           if {op(op(f, 1))} = {1} then
/*e)*/        return((D@@(nops(op(f,1))+1))(op(f,2)))
/*f)*/        else error("multivariate function ".expr2text(f).
                   " in univariate D call");
           end_if;
        end_if;
      end_if
    end_if;

    if testtype(f, Type::Constant) and f = eval(f) then return(0) end_if;
    userinfo(5, "No suitable differentiation method found ".
	         "for this type of argument");
    procname(idx, f)

    end_proc;
    D(args())
end_proc:

D:= funcenv(D):
D:= slot(D, "type", "D"):
D:= slot(D, "print", "D"):
D::interval := proc(x)
        begin
          if args(0) = 1 then
             D(interval(x));
          else
             D(args(1..args(0)-1), interval(args(args(0))));
          end_if;
        end_proc:
D::Content := (Out, data) -> 
                 if nops(data) = 1 then
                   Out::Capply(Out::Cdiff, Out(op(data))):
                 elif nops(data) = 2 then
                   
                   Out::Capply(Out::Cpartialdiff,
                               Out(op(data,1)),
                               Out(op(data, 2))):
                 else
                   return(Out::stdFunc(data));
                 end_if:

/*--
stdlib::makeDop -- reconstruct differential operator with diff

stdlib::makeDop(f, x <, idx>)

f   - function for which to create D operator
x   - list of unknowns of f
idx - list of partial derivatives, [1] is default

Reconstructs D(idx,f) by creating a function from diff(f(op(x)), x[idx[1]]...)
--*/

stdlib::makeDop:=
proc(f, x, idx)
  local v, dv, i;
begin
  userinfo(3, "Reconstructing D-operator for ".expr2text(f));
  v:= f(op(x));
  if args(0) = 3 then
    dv:= diff(v, x[idx[i]] $ i=1..nops(idx))
  else
    dv:= diff(v, x[1])
  end_if;
  if type(dv) = "diff" then
    if op(op(dv, 1)) = op(x) then
      hold(D)((if args(0) = 3 then idx else null() end_if), op(v,0))
    else  
      dv:= rewrite(dv, D);
      fp::unapply(dv, op(x))
    end_if
  else
    v := FAIL;
    if testtype(dv, Type::Constant) then
      v := dv;
    elif not ((testtype(f, DOM_PROC)
             and hold(arrow) in {op(f, 3)}) or 
            testtype(f, DOM_FUNC_ENV) or
            testtype(f, DOM_EXEC)) then
      v:= fp::expr_unapply(dv, op(x));
    end_if;
    if v = FAIL then
      if has(dv, hold(diff)) then
        dv:= rewrite(dv, D)
      end_if;
      fp::unapply(dv, op(x))
    else
      v
    end_if
  end_if
end_proc:

// end of file 
