//
//
//  hypergeom -- Derivative of Generalized Hypergeometric Function 
//
//

alias(Hypergeom=specfunc::Hypergeom):
alias(contain=Hypergeom::contain):

hypergeom::diff:=
proc(e,x) //e=hypergeom(as,bs,z)
  local as,bs,asl,bsl,z,dz,num,nu,den,as1,bs1,d,i,j,jp,k,l,p,q,r,answer;
begin
  if args(0)>2 then
    return(diff(diff(e,x),args(3..args(0))))
  end_if;
 
  as:=op(e,1): bs:=op(e,2): z:=op(e,3):
  if not(type(as)=DOM_LIST and type(bs)=DOM_LIST) then
    // Taking derivative of incompletely instantiated
    // expressions is prohibitted.
    error("Illegal arguments"):
  end_if:
  // Step 2: remove common terms
  for i from nops(as) downto 1 step 1 do
    j:=contains(bs, as[i]);
    if j <> 0 then
      as := subsop(as,i=null());
      bs := subsop(bs,j=null());
    end_if:
  end_for:
  if has(as,x) or has(bs,x) then
    i:=contain(as,x):
    p:=nops(as):
    j:=contain(bs,x):
    q:=nops(bs):
    if j > 0 then
      jp:=contain([op(bs[j])],x):
      if jp<>0 then
        bsl:=subsop([op(bs[j])],jp=null()):
      else
        bsl:=bs:
      end_if;
      nu:=_plus(op(bsl)):
      r:=bs[j]-nu:
    else
      nu:=0:
      r:=0:
    end_if:
    // 7.2.3.61 Prudnokiv et al. vol. 3
    if p=1 and q=1 and as[1]=1 and not(has(nu,x)) then
      answer:=-diff(r,x)*(z*exp(z)/bs[j]^2)*
               hypergeom([bs[j],bs[j]],[bs[j]+1,bs[j]+1],-z):
      return(answer):
      // 7.2.3.62 Prudnikov et al. vol. 3
    elif p=2 and q=1 and (as=[1,r] or as=[r,1]) and not(has(nu,x)) then
      answer:=diff(r,x)*((nu*z*((1-z)^(nu-1)))/bs[j]^2)*
               hypergeom([bs[j],bs[j],nu+1],[bs[j]+1,bs[j]+1],z):
      return(answer):
    else
      if i <> 0 then asl:=subsop(as,i=null()): else asl:=[]: end_if;
      if j <> 0 then bsl:=subsop(bs,j=null()): else bsl:=[]: end_if;
      if i <> 0 and j <> 0 then
        d:=expand(bs[j]-as[i]):
      else
        d:=0:
      end_if:
      if i<>0 and j<>0 and not(has(z,x)) and
        not(has(asl,x)) and not(has(bsl,x)) and not(has(nu,x)) then
        if d=1 then
          //7.2.3.59 Prudnikov et al vol .3
          answer:=diff(r,x)*(z/bs[j]^2)*
                   (_mult(asl[l]$l=1..p-1)/(_mult(bsl[k]$k=1..q-1)))*
                   hypergeom([bs[j],bs[j],op(map(asl,_plus,1))],
                             [bs[j]+1,bs[j]+1,op(map(bsl,_plus,1))],z):
          return(answer):
        elif d=-1 then
          //Note: 7.2.3.60 Prudnikov et al vol .3 was wrong
          // but I fixed it -Voldemort
          answer:=-diff(r,x)*(z/bs[j]^2)*
                   (_mult(asl[l]$l=1..p-1)/(_mult(bsl[k]$k=1..q-1)))*
                   hypergeom([op(map(asl,_plus,1))],
                             [op(map(bsl,_plus,1))],z):
          return(answer):
        else
          return(hold(diff)(args())):
        end_if:
      else
        return(hold(diff)(args())):
      end_if:
    end_if:
  else
    // first two arguments are indepndent of x
    dz:=diff(z,x):
    if not iszero(dz) then
      num:=_mult(as[i]$i=1..nops(as)):
      den:=_mult(bs[i]$i=1..nops(bs)):
      as1:=[(as[i]+1)$i=1..nops(as)]:
      bs1:=[(bs[i]+1)$i=1..nops(bs)]:
      d:=num/den*hypergeom(as1,bs1,z):
      answer:= d*dz
    else
      // third argument is constant, too 
      answer:= 0
    end_if:
  end_if:
  answer
end_proc:

unalias(contain):
unalias(Hypergeom):
