//    

/*--
	igamma/diff -- the function attribut "diff" for igamma

   since igamma(a, x) = x^a * Ei(1-a, x)
   we may reduce this to Ei::diff


--*/

igamma::diff :=
proc(e,y)
  local a,x;
begin
  case args(0)
    of 1 do
      return(e)
    of 2 do
      if not has(e, y) then
        return(0)
      end_if;
      a:=op(e,1);
      x:=op(e,2);
      if not has(a, y) then
        // do not reduce to Ei, prefer output with exp
        return(-x^(a-1)*exp(-x)*diff(x, y))
      else
        // reduce to two-argument Ei function
        return(diff(x^a*Ei(1-a, x), y))
      end_if
    otherwise
      diff(diff(e,y), args(3..args(0)))
  end_case
end_proc:
