meijerG::diff := proc(e,t) //e=meijerG(as,bs,cs,cd,z)
  local as,bs,cs,ds,z,dz,g,as1,bs1,cs1,ds1,answer,sc;
begin
 //if has(op(e,1),[args(2..args(0))]) then hold(diff)(args())
 // now we only have to diff. with respect to second argument
 if nops(e) = 5 then
    [as, bs, z]:= meijerG::checkParameters(op(e));
    if as = FAIL then
       // bs = [m, n, [a.1, .., a.p], [b.1,...,b.q], z]
       return(hold(diff)(hold(meijerG)(op(bs)), args(2..args(0))));
    end_if:
    e:= meijerG(as, bs, z):
 elif nops(e) <> 3 then
    error("expecting 3 or 5 arguments in meijerG");
 end_if;

 if args(0)>2 then 
  return(diff(diff(e,t),args(3..args(0)))):
 else
  [as,bs]:=op(e,1):
  [cs,ds]:=op(e,2):
  z:=op(e,3):
  if not (type(as)=DOM_LIST and type(bs)=DOM_LIST and type(cs)=DOM_LIST
       and type(ds)=DOM_LIST) then
    // Taking derivative of incompletely instantiated
    // expressions is prohibitted.
    error("Illegal arguments"):
  elif has(as,t) or has(bs,t) or has(cs,t) or has(ds,t) then
    // Not Implemented Yet.
    return(hold(diff)(args())):
  else
    as1:=as:
    bs1:=bs:
    cs1:=cs:
    ds1:=ds:
    dz:=diff(z,t):
    sc:=dz/z:
    if dz=0 then
      answer:=0:
    // Apply formula of PBM 8.2.2. no. 31, p.620:
    //
    //         mn / | a  \       mn /  a - 1,a  .. a \            mn /  | a  \
    // z*d/dz G  |z |  p  |  =  G  |z | 1     2     p | + (a -1)*G  | z |  p  |
    //         pq \ | b  /       pq \      b         /      1     pq \  | b  /
    //                 q                    q                              q
    // for n>= 1.  In case n=0, i.e. as=[],
    // there is also a counterpart formula for n <= p-1:
    //
    //         mn / | a  \       mn /  a    , a - 1 \            mn /  | a  \
    // z*d/dz G  |z |  p  |  = -G  |z | p-1    p     | + (a -1)*G  | z |  p  |
    //         pq \ | b  /       pq \      b        /      p     pq \  | b  /
    //                 q                    q                             q
    //
    // Note 1:This is not written explicitely in PBM but can be derived from
    // PBM 8.2.3. no. 37 and no. 38.
    // Note 2: other fomulae like e.g no. 32 is simpler but increases
    // the order of the Meijer G function (which one would rather avoid).
    //
    // Take into account that the various lists my be empty, here we go:
    elif as1<>[] then
      g:=as1[1]:
      as1:=subsop(as1,1=null()):
      answer:=sc*meijerG([[g-1,op(as1)],bs1],[cs1,ds1],z):
      if g<>1 then
       answer:=answer+(g-1)*sc*meijerG([[g,op(as1)],bs1],[cs1,ds1],z):
      end_if:
    elif bs1<>[] then
      g:=bs1[1]:
      bs1:=subsop(bs1,1=null()):
      answer:=-sc*meijerG([as1,[g-1,op(bs1)]],[cs1,ds1],z):
      if g<>1 then
       answer:=answer+(g-1)*sc*meijerG([as1,[g,op(bs1)]],[cs1,ds1],z):
      end_if:
    elif cs1<>[] then
      g:=cs1[1]:
      cs1:=subsop(cs1,1=null()):
      answer:=-sc*meijerG([as1,bs1],[[g+1,op(cs1)],ds1],z):
      if g<>0 then
       answer:=answer+g*sc*meijerG([as1,bs1],[[g,op(cs1)],ds1],z):
      end_if:
    elif ds1<>[] then
      //sc:=sc/z:
      g:=ds1[1]:
      ds1:=subsop(ds1,1=null()):
      answer:=sc*meijerG([as1,bs1],[cs1,[g+1,op(ds1)]],z):
      if g<>0 then
       answer:=answer+g*sc*meijerG([as1,bs1],[cs1,[g,op(ds1)]],z):
      end_if:
    else
      answer:=0:
    end_if:
  end_if:
  return(answer):
 end_if:
end_proc:
