/*--
cos/expand -- the function attribut "expand" for cos

 cos(-x)     = cos(x)                                      
 cos(x +- y) = cos(x) * cos(y) -+ sin(x) * sin(y)           
              n/2                                           
              ---                                           
              \   (  n )                                    
 cos(n * x) = /   ( 2*i) cos(x)^(n-2*i)*sin(x)^(2*i)*(-1)^i 
              ---                                           
              i=0                                           
--*/

cos::expand:= prog::remember(
proc(a)
  local n, t, y, i;
  name cos::expand;
begin
   if type(a) <> "cos" then
      return(expand(a));
   end_if;
   // a = cos(y)
   y:= op(a, 1);
   if not has([args()], "NoRecursiveExpand") then
     y := expand(y, args(2..args(0)));
   end_if;
   case type(y)
     of "_plus" do
       n := _plus(op(y, i) $ i = 1 .. nops(y) div 2);
       y := _plus(op(y, i) $ i = (nops(y) div 2) + 1 .. nops(y));
       return(expand(cos::expand(cos(n), "NoRecursiveExpand")*cos::expand(cos(y), "NoRecursiveExpand")
                    -sin::expand(sin(n), "NoRecursiveExpand")*sin::expand(sin(y), "NoRecursiveExpand"), 
                    ArithmeticOnly, args(2..args(0))))
     of "_mult" do
       n := op(y, nops(y));
       t := type(n);

       // apply the rule
       // cos(I*x) = cosh(x)
       if t = DOM_COMPLEX and iszero(op(n, 1)) then
         return(expand(cosh(y/I), args(2..args(0))))
       end_if;
       
       // cos(n*x) = sin(x)^(..)*cos(x)^(..) + ...
       // Do this, if n is integer and x contains at least on symbol,
       // because we do not want to expand cos(5*sqrt(2)) etc.
       if indets(y) minus Type::ConstantIdents = {} then
          break;
       end_if:
       n := op(y, nops(y));
       t := type(n);
       if t = DOM_INT or t = DOM_RAT then
          if n < 0 then
             return(expand(cos(-y), args(2..args(0))));
          else // n > 0
               // the following is due to Francois Maltey
             if n=1 then
               return(cos(y))
             end_if; // avoids loop in expand(cos(1)) 
             if t = DOM_INT then
               y := y / n;
               return(
                  subs(expand(((#C+I*#S)^n+(#C-I*#S)^n)/2, args(2..args(0))),
                       [#C=cos(y),#S=sin(y)])
                      )
             end_if;
          end_if;
       end_if;

  end_case;
  cos(y)
end_proc, () -> [property::depends(args()), DIGITS]):

// end of file
