// cot::expand - the expand slot for cot

// applies
//
//  cot(x + y) -> (cot(x)*cot(y) - 1)/(cot(x) + cot(y))
//  cot(I*x) -> -I*coth(x)

// does *not* apply cot(x) -> cos(x)/sin(x)

cot::expand:= prog::remember(
proc(a: "cot")
  local n, t, y, S, even, odd, dummy, summands, u, i;
  name cot::expand;
begin
  y:= expand(op(a, 1), args(2..args(0)));
  
  case type(y)
    of "_plus" do
      // we have to expand cot(x1 + ... + xn)
      // we do the  same technique as in tan::expand
      // we start by computing the powerset
      summands:= [op(y)];
      // we have to exclude poles of the cot: this is just done
      // "syntactically" at the moment
      // use "even" as a dummy, split into poles and non-poles
      [t, summands, even]:= split(summands, x-> type(x/PI) =DOM_INT);
      
      S:= combinat::powerset({op(map(summands, u->expand(cot(u), args(2..args(0)))))});
      [even, odd, dummy] := split(S, set -> nops(set) mod 2 = 0);
      even:= map(even, set ->
                 if nops(set) mod 4 = 0 then
                   _mult(op(set))
                 else  
                   -_mult(op(set))
                 end_if
                   );
      odd:= map(odd, set->
                if nops(set) mod 4 = 1 then
                  _mult(op(set))
                else
                  -_mult(op(set))
                end_if
                );
      
      if nops(summands) mod 2 = 0 then          
        return(-_plus(op(even))/ _plus(op(odd)))
      else
        return(_plus(op(odd))/ _plus(op(even)))
      end_if   
     
     of "_mult" do 
      n := op(y, nops(y));
      t := domtype(n);
      // first apply cot(I*x) = -I*coth(x)
      if t = DOM_COMPLEX and iszero(op(n, 1)) then
        return(-I* expand(coth(y/I), args(2..args(0))))
      end_if;

       // because we do not want to expand cot(5*sqrt(2)) etc.
      if indets(y, All) minus Type::ConstantIdents minus
        {hold(_plus), hold(_power), hold(_mult)}= {} then
        break;
      end_if;
      
      if t = DOM_INT then
        if n < 0 then
          return(expand(-cot(-y), args(2..args(0))))
        else // n > 0
          u:= cot(y/n);
          S:= u;
          for i from 2 to n do
            // we have S = cot((i-1)*y/n) and u = cot(y/n)
            // compute S:= cot(i*y/n) by using the addition formula
            // We must *not* use normal directly because this would
            // produce too many hastype - calls 
            S:= _divide(op(stdlib::normal((u*S-1)/(u+S))))
          end_for;
          return(S)         
        end_if;
      end_if;
  end_case;
  cot(y)  
end_proc, () -> [property::depends(args()), DIGITS]):
