/*--
	gamma/expand -- the function attribut "expand" for gamma

        implements the following rules for
        a of Type::Real and b of Type::PosInt:

0) gamma(b) = 1 * ... * (b - 1)

1) gamma(x + a) = gamma(x + frac(a))*(x + frac(a))*...*(x + a - 1) if a > 0,
   gamma(x + a) = gamma(x + frac(a))/(x + frac(a) - 1)/.../(x + a) if a < 0,
   (also for x = 0 or x of Type::Imaginary)
   
2) gamma(b*x) = (2*PI)^(1-b)/2 * b^(b*x-1/2) * gamma(x)*...*gamma(x+(b - 1)/b)
   (also for x = I)

3) gamma(-x) = -PI /(sin(PI*x)*x*gamma(x))
--*/

gamma::expand := prog::remember(
proc(g: "gamma")
   local a, fa, b, r, j, e;
   name gamma::expand;
begin
  // recursively expand the argument
  e := expand(op(g, 1));

  if domtype(e) = DOM_INT then // rule 0
    if e > 0 then
      return(_mult(j $ j = 1 .. (e - 1)))
    else // should not happen, since already done in SPECFUNC/gamma.mu
      error("singularity")
    end_if
  end_if;

  r := 1;
  if type(e) = "_plus" or testtype(e, Type::Numeric) then // rule 1
    if type(e) = "_plus" then
      a := select(e, testtype, Type::Numeric);
    else
      a := e;
    end_if;
    fa := floor(Re(a));
    e := e - fa;
    if fa >= 0 then
      r := _mult(e + j $ j = 0 .. (fa - 1))
    else // fa < 0
      r := 1 / _mult(e + j $ j = fa .. -1)
    end_if;
  end_if;

  if type(e) = "_mult" or domtype(e/I) = DOM_INT then // rule 2
    if type(e) = "_mult" then
      b := select(e, testtype, Type::Numeric);
    else
      b := e;
    end_if;
    if domtype(b/I) = DOM_INT then
      b := b/I;
    elif domtype(b) <> DOM_INT then
      b := 1;
    end_if;
    e := e/b;
    if b > 0 then
      r * PI^((1-b)/2)*2^((1-b)/2)*b^(b*e)*b^(-1/2)
      * _mult(gamma(e + j/b) $ j = 0 .. (b - 1))
    else // b < 0, rule 3
      r * PI / (expand(sin(-PI*b*e), args(2..args(0)))*b*e) /
      /* gamma(-b*e) = */
      (PI^((1+b)/2)*2^((1+b)/2)*(-b)^(-b*e)*(-b)^(-1/2)
       * _mult(gamma(e - j/b) $ j = 0 .. (-b - 1)))
    end_if;
  else
    r * gamma(e)
  end_if
end_proc, () -> [property::depends(args()), DIGITS]):

