/*--
	ln/expand -- the function attribut "expand" for ln

	ln(x ^ n)     = n * ln(x) 
	ln(x * y)     = ln(x) + ln(y)  if x or y are real positive
	ln(-c * x)    = ln(c) + ln(-x)
	ln(exp(x))    = x              if x is real
--*/

ln::expand:=prog::remember(
proc(a: "ln")
  local n, t, y, opt;
  name ln::expand;
begin
  opt:= args(2..args(0));
  y := op(a, 1);
  traperror((y:= normal(expand(op(a, 1), opt), Expand = TRUE)), MaxSteps =1);
  case type(y)
    of DOM_RAT do
      return(ln(op(y,1))-ln(op(y,2)))
    of DOM_COMPLEX do
      // ln(r*I) = ln(r) + ln(I)
      // ln(-r*I) = ln(r) + ln(-I)
      if iszero(op(y, 1)) then
        if op(y, 2) > 0 then
          return(ln(op(y, 2)) + ln(I))
        else
          return(ln(-op(y, 2)) + ln(-I))
        end_if
      end_if;
      break
    of "_mult" do 
      // ln(x*y)=ln(x)+ln(y) is only true when x or y is real positive
      n:=0; t:=1;
      for y in y do
        if contains({opt}, IgnoreAnalyticConstraints) or is(y>=0, Goal =TRUE) then
          n:=n+expand(ln(y), opt)
        else
          t:=t*y
        end_if
      end_for;
      return(n + ln(t))
    of "_power" do
      if contains({opt}, IgnoreAnalyticConstraints) 
        or is(op(y,1)>=0, Goal = TRUE) and is(op(y,2) in R_, Goal = TRUE)
        then
        return(expand(op(y, 2) * ln(op(y, 1)), opt))
      end_if;
      break
    of "exp" do
      /* ln(exp(x))=x is true only for x real,
         for example ln(exp(2*I*PI))=ln(1)=0 <> 2*I*PI
      */
      if contains({opt}, IgnoreAnalyticConstraints) or
        is(op(y) in R_, Goal =TRUE) then
        return(op(y,1))
      end_if;
      break
  end_case;
  ln(y)
end_proc, () -> [property::depends(args()), DIGITS]):
