/*--
	sinh/expand -- the function attribut "expand" for sinh

 sinh(-x)     = -sin(x)                                                  
 sinh(x +- y) = sinh(x) * cosh(y) +- sinh(y) * cosh(x)                   
                n                                                        
               ---                                                       
               \   (   n  )                                              
 sinh(n * x) = /   ( 2*i+1) cosh(x)^(n-2*i-1)*sinh(x)^(2*i+1)*(-1)^(i+1) 
               ---                                                       
               i=0     
--*/


sinh::expand:= prog::remember(
proc(a)
  local n, t, y, i, iminus1, iminus2, sinhi;
  name sinh::expand;
begin
  y := expand(op(a, 1), args(2..args(0)));

  case type(y)
    of "_plus" do
      n := op(y, 1);
      y := subsop(y, 1=null());
      return(expand(sinh(n)*cosh(y)+cosh(n)*sinh(y), args(2..args(0))));
    of "_mult" do
      n := op(y, nops(y));
      t := type(n);

      if t = DOM_COMPLEX and iszero(op(n, 1)) then
        return(I*expand(sin(y/I), args(2..args(0))))
      end_if;
       
      if t = DOM_INT or t = DOM_RAT then
        if n < 0 then
          return(expand(-sinh(-y), args(2..args(0))));
        elif t = DOM_INT and n > 0 then
          y := y / n;
          iminus2:= 0; // = sinh(0*y)
          iminus1:= sinh(y); // = sinh(1*y)
          // we start with i=2. Loop invariant: iminus2 = sinh((i-2)*y)
          // and iminus1 = sinh((i-1)*y)
          for i from 2 to n do
            sinhi:= expand(2*iminus1 * cosh(y) - iminus2,
                           hold(sinh)(y), hold(cosh)(y), args(2..args(0)));
            iminus2:= iminus1;
            iminus1:= sinhi
          end_for;
          return(sinhi)
          // return(expand(2*sinh((n-1)*y)*cosh(y)-sinh((n-2)*y)));
        end_if
      end_if
  end_case;
  sinh(y)
end_proc, () -> [property::depends(args()), DIGITS]):
