alias(BesselK=besselK::float):
alias(realYK=specfunc::Bessel::realYK):
alias(complexJI=specfunc::Bessel::complexJI):
alias(complexYK=specfunc::Bessel::complexYK):
alias(signc=specfunc::Bessel::signc):
alias(ssqrt=specfunc::sqrt):
alias(sexp=specfunc::exp):
alias(strunc=specfunc::trunc):
alias(sround=specfunc::round):
alias(sfrac=specfunc::frac):
alias(sabs=specfunc::abs):

BesselK := proc(vv,xx)
    local v, x;
    save z;
    begin
    v := float(vv):
    x := float(xx):

    if not((type(v)=DOM_FLOAT or type(v)=DOM_COMPLEX) and
           (type(x)=DOM_FLOAT or type(x)=DOM_COMPLEX)) then

	return(besselK(v,x)):

      elif iszero(x) then
	error("singularity"):
    end_if:

    if type(v)=DOM_FLOAT and iszero(sfrac(v)) then

	v := strunc(v):
    end_if:

    if signc(float(v)) = -1 then
	float(BesselK(-v,x)):

      elif iszero(v-1/2) or iszero(v+1/2) then
        float(ssqrt(PI/float(2))/ssqrt(x)*sexp(-x)):

      elif type(x)=DOM_FLOAT and (type(v)=DOM_FLOAT or type(v)=DOM_INT) then
	float(realYK(v,x,-1)):
      else
	float(complexYK(v,x,-1,FALSE)):
    end_if:
end_proc:

BesselK:= prog::remember(BesselK, () -> [property::depends(args()), DIGITS]):

unalias(ssqrt):
unalias(sexp):
unalias(strunc):
unalias(sfrac):

