
specfunc::floatpsi := proc(x, n)
   /* 
    * x - integer, rational, floating-point or complex number
    * n - integer, n > 0
    */
    local fx, d, k, n1, old_d, s, shift;
    save DIGITS;
begin
    x := float(x);
    if {domtype(x)} minus {DOM_FLOAT, DOM_COMPLEX} <> {} then
       return(hold(psi)(args()))
    end_if;
    n1 := n + 1;
    if Re(x) < 1/2 then
        fx:= frac(x):
        if domtype(x)=DOM_FLOAT and iszero(fx-1/2 )
        then // extreme danger of cancellation, so use an
             // exact result:
             if n mod 2 = 0 
             then s:= 0;
             else // the following is the exact symbolic result for
                  // float(PI^(n+1)*D([1 $ n], cot)(PI/2)) with odd n>0:
                  s:= float(PI^(n1))*I^n1*2^n1*(2^n1-1)/n1*bernoulli(n1):
             end_if;
        else // Use plain numerics.
             s := float(PI^(n1)*D([1 $ n], cot)(PI*x));
        end_if;
        // if iszero(Im(s)) then s := Re(s) end_if;
        s := (-1)^n*specfunc::floatpsi(1 - x, n) - s; 
    else
        shift := DIGITS;
        DIGITS := DIGITS + length(shift) + length(n1) + 1;
        d := 1/x^n1; old_d := float(0); 
        for k from 1 to shift - 1 do
            if d = old_d then break end_if;
            old_d := d; d := d + 1/(x + k)^n1
        end_for;
        x := x + shift;
        s := specfunc::asymptpsi(x, n);
        s := s + (-1)^n1*n!*d
    end_if
end_proc:

specfunc::floatpsi:= prog::remember(specfunc::floatpsi, () -> [property::depends(args()), DIGITS]):

specfunc::asymptpsi := proc(x, n)
   /* 
    * x - integer, rational, floating-point or complex number
    * n - integer, n >= 0
    */
    local f, g, k, k1, min_k, n1, old_s, s, t, x2;
    save DIGITS;
begin
    DIGITS := DIGITS + length(DIGITS) + length(n) + 1;
    n1 := n - 1;
    x2 := 1/x^2;
    f := n!;
    t := 1/x^(n + 1);
    if n = 0 then s := 1/2*t - ln(x) else s := f*(x/n + 1/2)*t end_if; 
    old_s := s;
    f := f*(n + 1);
    g := 2;
    t := t/x;
    s := s + 1/6*f*t/g;
    min_k := trunc(6.28*abs(x) + 1 - n);
    for k from 4 to min_k step 2 do
        if s = old_s then break end_if;
        old_s := s;
        k1 := k - 1;
        f := f*(n1 + k)*(k1 + n1);
        g := g*k*k1;
        t := t*x2;
        s := s + bernoulli(k)*f*t/g
    end_for;
    // No convergence, if s <> old_s
    (-1)^n1*s
end_proc:

specfunc::asymptpsi:= prog::remember(specfunc::asymptpsi, () -> [property::depends(args()), DIGITS]):
