//    

/*--
  arccos/rectform -- the function attribut "rectform" for arccos
--*/

arccos:= slot( arccos, "rectform", proc(xx)
  local a, b, d, s, t, e, x;
begin
  x:= rectform::new(xx);

  if extop(x,3) <> 0 then
    new(rectform,0,0,hold(arccos)(rectform::expr(x)))
  else
    a:= extop(x,1);
    b:= extop(x,2);
    if domtype(a+I*b) = DOM_COMPLEX
       and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
    then
       rectform::new(arccos(a+I*b))
    else
       s:= 1/2*rectform::expr( slot(abs,"rectform")(a+1+I*b) );
       t:= 1/2*rectform::expr( slot(abs,"rectform")(a-1+I*b) );
       d:= s+t; 
       e:= I*a-b;
       if iszero(e) then 
          new(rectform, PI/2, 0, 0);
       else
          new(rectform,arccos(s-t),sqrt(e^2)/e*ln(d+sqrt(d^2-1)),0);
       end_if
    end_if
  end_if
end_proc):
