//    

/*--
	arccot/rectform -- the function attribut "rectform" for arccot
--*/

arccot::rectform:=
proc(xx)
  local a, b, s, x;
begin
  if iszero(xx) then
     return(new(rectform, PI/2, 0, 0))
  end_if:
  x:= rectform::new( xx );
	    
  if extop(x,3) <> 0 then
    new( rectform,0,0,hold(arccot)(rectform::expr(x)) )
  else
    a:= extop(x,1);
    b:= extop(x,2);
    if domtype(a+I*b) = DOM_COMPLEX
      and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
      then
      return(rectform::new(arccot(a+I*b)));
    elif iszero(b) then
      return(new( rectform,arccot(a),0,0 ));
    end_if;

    if iszero(a) and iszero(abs(b)-a^2 - b^2) then
      error("singularity")
    else
      s:= (a^2+(1-b)^2) / (a^2+(1+b)^2);
      new(rectform, 1/2*arg((a^2 + b*(b+1))/(a^2 + b^2),   a/(a^2+b^2))
                   -1/2*arg((a^2 + b*(b-1))/(a^2 + b^2) , -a/(a^2+b^2)), 
                   1/4*ln(s), 
                   0)
    end_if
  end_if
end_proc:
 
// end of file 
