/*--
  arcsinh/rectform -- the function attribut "rectform" for arcsinh
--*/

arcsinh::rectform := proc(xx)
   local a, b, x;
begin
 x:= rectform::new(xx);

 if extop(x,3) <> 0 then
     new(rectform,0,0,hold(arcsinh)(rectform::expr(x)))
 else
     a:= extop(x,1);
     b:= extop(x,2);
     if domtype(a+I*b) = DOM_COMPLEX
        and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
     then
         rectform::new(arcsinh(a+I*b))
     else
         if iszero(b) then
            new(rectform, arcsinh(a), 0, 0);
         else
            x:= a + I*b;
            new(rectform, ln(abs(x + sqrt(x^2 + 1))), arg(x + sqrt(x^2 + 1)), 0);
         end_if;
     end_if;
 end_if;
end_proc:
