
/*
   arctanh::rectform(x)

   computes the real and imaginary part of arctanh(x) 

*/

arctanh::rectform:=
proc(x)
begin
  /* arctanh(x) = 1/2 * (ln(1+x) - ln(1-x))
       we might simply call rectform for that expression, which would give
       (with u = Re(x), v = Im(x))
       1/4*ln((u + 1)^2 + v^2) - 1/4*ln((u - 1)^2 + v^2) +
       arg(u + 1+ v*I)*1/2*I - arg(1 - u - v*I)*1/2*I

       However, it may be simpler to write the arguments of the ln's
       as abs(x+1)^2 and abs(x-1)^2, respectively, which gives as real part
         1/2 * (ln(abs(x+1)) - ln(abs(x-1)))
       = 1/2 * ln(abs((x+1)/(x-1)))

       We do not need to compute u, v and do not write x= u+I*v
    */
  new(rectform, ln(abs((x+1)/(x-1)))/2, (arg(1+x)-arg(1-x))/2, 0)
end_proc: