erf::rectform:=
proc(xx)
  local a, x;
begin
  x := rectform::new(xx);
  // Special case: along the imaginary axis, 
  // erf(x) is purely imaginary:
  if iszero(extop(x, 1)) and iszero(extop(x, 3)) then
    return(new(rectform, 0, -I*hold(erf)(xx), 0))
  end_if:

  if extop(x, 3) <> 0 or not iszero(extop(x, 2)) then
    // the argument x is not known to be real
    new(rectform, 0, 0, hold(erf)(xx))
  else
    a := extop(x, 1);
    if domtype(a) = DOM_FLOAT then
      rectform::new(erf(a))
    else
      new(rectform, erf(a), 0, 0)
    end_if
  end_if
end_proc:
