erfi::rectform:=
proc(xx)
  local a, x;
begin
  x := rectform::new(xx);

  // x = extop(x, 1) + extop(x, 2)*I + extop(x, 3),
  // where extop(x, 1) and extop(x, 2) are real and no
  // rectangular decomposition is known for extop(x, 3)

  // Special case: along the imaginary axis,
  // erfi(x) is purely imaginary:
  if iszero(extop(x, 1)) and iszero(extop(x, 3)) then
    return(new(rectform, 0, -I*hold(erfi)(xx), 0))
  end_if:

  if (not iszero(extop(x,3))) // the rectform of some 
     or                       // part of x is not known
     (not iszero(extop(x, 2))) then
       // signal that it is not known
       // how to decompose erfi(x) 
      new(rectform,0,0,hold(erfi)(xx));
  else
      a:= extop(x,1);
      if domtype(a) = DOM_FLOAT then
        rectform::new(erfi(a))
      else
        new(rectform, hold(erfi)(a), 0, 0)
      end_if
  end_if:
end_proc:
