inverf::rectform:=
proc(xx)
  local a, x;
begin
  x := rectform::new(xx);
  // Special case: along the imaginary axis, 
  // inverf(x) is purely imaginary:
  if iszero(extop(x, 1)) and iszero(extop(x, 3)) then
    return(new(rectform, 0, -I*hold(inverf)(xx), 0))
  end_if:
  if extop(x, 3) <> 0 or not iszero(extop(x, 2)) then
    // the argument x is not known to be real
    return(new(rectform, 0, 0, hold(inverf)(xx)));
  end_if;
  a := extop(x, 1);
  if is(a >= -1) = TRUE and
     is(a <= 1) = TRUE then
     if domtype(a) = DOM_FLOAT then
       return(rectform::new(inverf(a)));
     else
       return(new(rectform, inverf(a), 0, 0));
     end_if
  end_if;
  return(new(rectform, 0, 0, hold(inverf)(xx)));
end_proc:
