inverfc::rectform:=
proc(xx)
  local a, x;
begin
  x := rectform::new(xx);
  // Special case: along the axis Re(xx) = 1 
  // inverfc(x) is purely imaginary:
  if iszero(extop(x, 1) - 1) and iszero(extop(x, 3)) then
    return(new(rectform, 0, -I*hold(inverfc)(xx), 0))
  end_if:
  if extop(x, 3) <> 0 or not iszero(extop(x, 2)) then
    // the argument x is not known to be real
    return(new(rectform, 0, 0, hold(inverfc)(xx)));
  end_if;
  a := extop(x, 1);
  if is(a >= 0) = TRUE and
     is(a <= 2) = TRUE then
     if domtype(a) = DOM_FLOAT then
       return(rectform::new(inverfc(a)));
     else
       return(new(rectform, inverfc(a), 0, 0));
     end_if
  end_if;
  return(new(rectform, 0, 0, hold(inverfc)(xx)));
end_proc:
