/*--
  lngamma/rectform -- the function attribut "rectform" for lngamma
--*/

lngamma:= slot(lngamma, "rectform", proc(xx)
        local a, x;
    begin
        x:= rectform::new(xx);

        // x = extop(x, 1) + extop(x, 2)*I + extop(x, 3),
        // where extop(x, 1) and extop(x, 2) are real and no
        // rectangular decomposition is known for extop(x, 3)

        if extop(x,3) <> 0 // the rectform of some 
                           // part of x is not known
           or 
              not iszero(extop(x,2)) // extop(x, 2)=Im(x) <> 0
           then
             // signal that it is not known
             // how to decompose lngamma(x) 
             new(rectform,0,0,hold(lngamma)(rectform::expr(x)))
        else //extop(x, 3), i.e., a complete decomposition is known
            a:= extop(x,1);
            if domtype(a) = DOM_FLOAT then
              rectform::new(lngamma(a))
            elif is(a >= 0) = TRUE then
              new(rectform,lngamma(a),0,0)
            else
              new(rectform,0,0,hold(lngamma)(rectform::expr(x)))
            end_if
        end_if
    end_proc
):

// end of file 
