//    

/*--
	ln/rectform -- the function attribut "rectform" for ln
--*/

log:= slot( log, "rectform", proc(bb, xx)
        local a, b, t, x;
    begin
        x:= rectform::new(xx);

        if extop(x,3) <> 0 then
            return( new(rectform,0,0,hold(log)(bb, rectform::expr(x))) )
        elif type(xx) = "abs" then
            return( new(rectform,log(bb, x),0,0) )
        else
            a:= extop(x,1);
            b:= extop(x,2);
            if domtype(a+I*b) = DOM_COMPLEX
            and (domtype(a) = DOM_FLOAT or domtype(b) = DOM_FLOAT)
            then
                return( rectform::new(log(bb, a+I*b)) )
            elif iszero(a+I*b) then
                error("singularity")
            elif iszero(b) then 
                return( new(rectform,log(bb, abs(a)),(1/2-1/2*sign(a))*PI/ln(bb),0) )
            else
                t:= a^2+b^2;
                if iszero(a) then
                    if testtype( sqrt(t),Type::Numeric ) then
                        return( new(rectform,log(bb, sqrt(t)),1/2*sign(b)*PI/ln(bb),0) )
                    else
                        return( new(rectform,1/2*log(bb, t),1/2*sign(b)*PI/ln(bb),0) )
                    end_if
                elif testtype( sqrt(t),Type::Numeric ) then
                    return( new(rectform,log(bb, sqrt(t)),arg(a,b)/ln(bb),0) )
                else
                    return( new(rectform,1/2*log(bb, t),arg(a,b)/ln(bb),0) )
                end_if
            end_if
        end_if
    end_proc
):

// end of file 
