RootOf := newDomain(hold(RootOf)):
RootOf::create_dom:=hold(RootOf):

RootOf::new :=
  proc(eqq, zz)
    local eq,z;
  begin
    case args(0)
      of 0 do
        error("RootOf called without arguments")
      of 1 do
        if type(eqq) = DOM_POLY then
          z:= op(eqq, 2)
        else      
          z:=indets(eqq)
        end_if;
        if nops(z)<>1 then
          error("You must specify the RootOf variable")
        end_if;
        z:=op(z);
        break
      otherwise
        z:=zz
    end_case;
    
    if indets(z, PolyExpr)<>{z} then
      error("Illegal variable")
    end_if;
    case type(eqq)
      of "_equal" do
        eq:= op(eqq, 1)- op(eqq,2);
        break
      otherwise
        // this works both for polynomials as well as
        // for arithmetical expressions
        eq:= expr(eqq)
    end_case;

    if testargs() then
      if not testtype(eq, Type::Arithmetical) then
        error("Input must be arithmetical expression")
      end_if
    end_if;
    
    if iszero(eq) then
      return(getprop(z));
    end_if;
    
    if testtype(eq, Type::PolyExpr(z)) and
//      hastype(map(eq, Re), DOM_FLOAT) and
      testtype(lcoeff(eq, [z]), Type::Numeric) then
      eq := eq / lcoeff(eq, [z])
    else
      /* --------------------------------------------
         Do not just take numer, because numer does
         not normalize. E.g., numer( expand((x+1)^2)/(x+1) )
         yield (x+1)^2, not (x+1) !
         Do call normal explicitly:
      ---------------------------------------------*/
      // eq:= numer(eq);
      eq:= normal(eq, List)[1];
      if testtype(eq,Type::PolyExpr(z,Type::Rational)) then
        eq:=polylib::primpart(eq,[z])
      end_if
    end_if;
    
    new(dom, eq,z)
  end_proc:

  RootOf::convert_to:=
  proc(r, dm)
    local i: DOM_INT;
  begin
    case dm
      of RootOf do
        return(r)
      of DOM_SET do
        {r[i] $i=1..degree(op(r, 1), op(r, 2))};
        break
      otherwise
        FAIL
    end_case;
  end_proc:


  RootOf::setvar:=
  proc(r: RootOf, x: DOM_IDENT)
  begin
    new(RootOf, evalAt(extop(r, 1), extop(r, 2) = x), x)
  end_proc:

  RootOf::evaluate:= r -> new(dom, eval(extop(r, 1)), eval(extop(r, 2))):

  // against the convention, but there is no equivalent expression:
  RootOf::expr:= id:

RootOf::print :=
proc(r: RootOf)
  local eq, z;
begin
  if Pref::mackichan() = TRUE then
    hold(RootOf2)(subs(op(r,1),op(r,2)=hold(_Z)));
  else
    eq:= extop(r, 1);
    z:= extop(r, 2);
    
    if op(eq, 0) = hold(_plus) and testtype(eq, Type::PolyExpr(z)) then
      eq := hold(_plus)(op(sort([op(eq)],
                                (a,b) -> degree(a, [z]) > degree(b, [z])
                                         or (degree(a, [z])=degree(b, [z]) and not sysorder(a, b)))));
      if stdlib::hasmsign(op(eq, 1)) then
        eq := hold(_plus)(op(map([op(eq)], _negate)));
      end_if;
    end_if;
    hold(RootOf)(eq, z)
  end_if
end_proc:

  RootOf::Re := () -> hold(Re)(hold(RootOf)(args())):
  RootOf::Im := () -> hold(Re)(hold(RootOf)(args())):

  RootOf::testtype :=
  proc(x, t)
  begin
    if type(x) = RootOf and t = Type::Set then
      return(TRUE)
    end_if;
    FAIL;
  end_proc:
  
  RootOf::diff :=
  proc(f,x)
    local P,y,yp;
  begin
    if args(0)=1 then
      f
    elif args(0)=2 then
      y:=op(f,2);
      if x=y then
        error("cannot differentiate with respect to RootOf variable")
      end_if;
      P:=op(f,1);
      if testtype(P,Type::PolyExpr(y)) then
        yp:=(if type(y)=DOM_IDENT then
               genident(expr2text(y))
             elif type(y)="function" then
               genident(expr2text(op(y,0)))(op(y))
             else
               genident()
             end_if);
        // P:=subs(P,y=yy); # to avoid problems if y is not a name #
        RootOf(subs(polylib::resultant(P,diff(P,x)+yp*diff(P,y),y), yp=y),
               y)
      else
        error("can differentiate only algebraic equations")
      end_if
    else
      slot(RootOf,"diff")(slot(RootOf, "diff")(f,x),args(3..args(0)))
    end_if
  end_proc:

// RootOf::has - noetig,
//  damit has(RootOf(y^2+x*y+3, y), x) nicht FALSE ergibt!!
  
  RootOf::has:=
  proc(x,s)
  begin
    has(extop(x,1),s)
  end_proc:

// RootOf::int:=proc() begin hold(int)(args()) end_proc:

/* 
>> float(RootOf(x^4+x+1));

0.7271360845 + 0.9340992894 I, 0.7271360845 - 0.9340992894 I,

- 0.7271360845 - 0.4300142883 I, - 0.7271360845 + 0.4300142883 I

>> float(RootOf(-y^2+RootOf(y^2+1,y),y));

{- 0.7071067812 - 0.7071067812 I, - 0.7071067812 + 0.7071067812 I,

   0.7071067812 - 0.7071067812 I, 0.7071067812 + 0.7071067812 I}
*/

  RootOf::float :=
  proc(r)
    local f,var,l,x,v,i, roots, zerocount;
  begin
    f := extop(r, 1);
    var := extop(r, 2);
    userinfo(3, "RootOf's float-attribute called with ".expr2text(args()));
    l:=misc::subExpressions(f, RootOf);
    if nops(l)=0 then
      userinfo(10, "No nested RootOf");
      if numeric::indets(f) minus {var} = {} then
        userinfo(10, "Calling numeric method");
        if testtype(f, Type::PolyExpr(var)) then
           //------------------------------------------------
           // Walter 2.3.07: The semantics of RootOf was
           // changed to be a MultiSet (i.e., multiple roots
           // are now counted with their multiplicities).
           // However, we still return the float result as a
           // DOM_SET, so we need to perturb the roots by a
           // tiny amount such that multiple roots turn up 
           // as separate distinct roots.
           //------------------------------------------------
           roots:= numeric::polyroots(f);
           if nops(roots) <> nops({op(roots)}) then
             // Make exactly one of the zero roots an
             // exact 0.0, so we need to count via zerocount:
             zerocount:= float(0):
             for i from 1 to nops(roots) do
                if iszero(roots[i]) then
                   roots[i]:= zerocount/10.0^(DIGITS + 1000);
                   zerocount:= zerocount + 1;
                else
                   roots[i]:= (1 + (i-1)/(i+1)/10.0^(1+DIGITS))*roots[i];
                end_if:
             end_for:
           end_if:
           {op(roots)};
        else
           solve::float(f, var)
        end_if:
      else
        userinfo(10, "Equation contains parameters");
        r
      end_if
    else
      x:=op(l,1);
      for i from 2 to nops(l) do
        if length(op(l,i))<length(x) then x:=op(l,i) end_if
      end_for;
      v:=[op(float(x))];
      {op(dom::float(RootOf(subs(f,x=v[i]), extop(r, 2..extnops(r)))))
       $ i=1..nops(v)}
    end_if
  end_proc:

  RootOf::_index:=
  proc()
  begin
    hold(_index)(args())
  end_proc:


  RootOf::exact:= 
  proc(a)
  begin
    misc::maprec(a,
                 {RootOf} =
                 proc(r: RootOf)
                 begin
                   solve(extop(r, 1), extop(r, 2), MaxDegree = 4)
                 end_proc,
                 {Dom::ImageSet, solvelib::VectorImageSet} =
                 proc(S)
                   local sets;
                 begin
                   sets:= map(S::dom::sets(S), RootOf::exact);
                   if sets = S::dom::sets(S) then
                     S
                   else
                     S::dom::new(op(S, 1), op(S, 2), sets)
                   end_if
                 end_proc
                 )
  end_proc:

  RootOf::expand:= r -> RootOf(expand(extop(r, 1)), extop(r, 2..extnops(r))):

  RootOf::normal:= 
  proc(x: RootOf, options)
  begin
  if args(0) >=2 and (type(options) = DOM_TABLE and options[List] = TRUE) or contains({args()}, List) then 
    [x, 1]
  else  
     x 
  end_if
  end_proc:

  RootOf::_plus:=
  proc()
    local sets, numbers, dummy, idents, i;
  begin
    if args(0) = 1 then
      args(1)
    else
      numbers:= map([args()], x -> if domtype(x) = DOM_POLY then expr(x) else x end_if);
      [numbers, sets, dummy]:= split(numbers, x -> type(x) <> RootOf and testtype(x, Type::Arithmetical));
      idents:= [genident("Rof") $i=1..nops(sets)];
      Dom::ImageSet(_plus(op(numbers), op(idents)), idents, sets)
    end_if
  end_proc:


  RootOf::_mult:=
  proc()
    local sets, numbers, dummy, idents, i;
  begin
    if args(0) = 1 then
       args(1)
    else
       numbers:= map([args()], x -> if domtype(x) = DOM_POLY then expr(x) else x end_if);
       [numbers, sets, dummy]:= split(numbers, x -> type(x) <> RootOf and testtype(x, Type::Arithmetical));
       idents:= [genident("Rof") $i=1..nops(sets)];
       Dom::ImageSet(_mult(op(numbers), op(idents)), idents, sets)
    end_if
  end_proc:

  // find the minimal polynomial of 1/alpha, given the minimal
  // polynomial of alpha:
  // alpha^n + a_{n-1} alpha^(n-1) + ... + a_0 = 0 iff
  // 1 + 1/alpha a_{n-1} + ... + a_0 / alpha^n = 0
  RootOf::_invert:=
  proc(R: RootOf)
    local f;
  begin
    f:= revert(poly(op(R, 1), [op(R, 2)]));
    subsop(R, 1=expr(multcoeffs(f, 1/lcoeff(f))))
  end_proc:

  RootOf::_minus:=
  proc(S, T)
  begin
    // handle only two simple cases
    if type(S) = dom and type(T)= DOM_SET then
      // delete those elements of T that cannot be in S anyway
      T:= select(T, x -> is(subs(op(S, 1), op(S, 2) = x) = 0 ) <> FALSE );
      if T = {} then
        return(S)
      else
        return(hold(_minus)(S, T))
      end_if
    elif type(S)= DOM_SET then
      // since overloading took place, T must be a RootOf
      assert(domtype(T) = dom);
      S:= split(S, x -> is(subs(op(T, 1), op(T, 2) = x) = 0 ));
      // now S[1] = set of roots, S[2] = set of non-roots,
      // S[3]= elements of S that may be roots or non-roots
      if S[3] = {} then
        return(S[2])
      else
        return(S[2] union (hold(_minus)(S[3], T)))
      end_if
    end_if;

    hold(_minus)(S, T)
  end_proc:
  
  RootOf::_union :=
  proc()
    local these, others, dummy, i, j;
  begin
    if args(0) = 1 then 
      return(args(1)) 
    end_if;
    [these, others, dummy] := split([args()], x->domtype(x) = RootOf);
    assert(dummy = []);

    // remove duplicates;
    these:= [op({op(these)})];
    // remove duplicates in disguise (obtained by change of variables)
    i:=1;
    while i < nops(these) do
      j:= i+1;
      while j <= nops(these) do
        // try to rename the variable
        if subs(op(these[i], 1), op(these[i], 2) = op(these[j], 2)) = op(these[j], 1) then
          delete these[j]
        else
          j:= j+1
        end_if
      end_while;
      i:= i+1
    end_while;  
    
    if ((i:= contains
         (map(others,
              x-> _lazy_and(contains(x::dom, "hasProp"),
                            x::dom::hasProp(Cat::Set) =TRUE)
              or type(x) = piecewise),
          TRUE))) > 0
      then
      return((op(others, i))::dom::_union(args()))
    end_if;
    
    others := _union(op(others));
    if type(others) = "_union" then
      others := op(others);
    end_if;
    if others = {} then
      if nops(these) = 1 then
        op(these);
      else
        hold(_union)(op(sort(these)));
      end_if;
    else
      hold(_union)(others, op(sort(these)));
    end_if
  end_proc:

  RootOf::_intersect :=
  proc()
    local these, others, dummy, i, j, l;
  begin
    if args(0) = 1 then
      return(args(1))
    end_if;
    
    [these, others, dummy] := split([args()], x->domtype(x) = RootOf);
    assert(dummy = []);

    if ((i:= contains
         (map(others,
              x-> _lazy_and(contains(x::dom, "hasProp"),
                            x::dom::hasProp(Cat::Set) =TRUE)
              or type(x) = piecewise),
          TRUE))) > 0
      then
      return((op(others, i))::dom::_intersect(args()))
    end_if;
    
    
    these:= RootOf::homog_intersect(op(these));
    case type(these)
      of "_intersect" do
        these:= [op(these)];
        break
      of RootOf do
        these:= [these];
        break
      otherwise
        return(_intersect(these, op(others)))
    end_case;
    
    if nops(others) > 0 then
      others := _intersect(op(others));
      if type(others) = "_intersect" then
        others := [op(others)]
      else
        others:= [others]
      end_if;

      for i from 1 to nops(others) do
        if type(others[i]) = DOM_SET then
          for j from 1 to nops(these) do
            l:= split(others[i], a-> is(a in these[j]));
            if l[3] = {} then
              others[i]:= l[1];
              these[j]:= FAIL;
              break
            else
              others[i]:= l[1] union l[3]
            end_if;
          end_for;
          if others[i] = {} then
            return({})
          end_if
        end_if;
        if type(others[i]) = "_minus" and type((l:= op(others, [i, 1]))) = RootOf then
          // we handle only one special case
          j:= contains(these, l);
          if j>0 then
            // apply the law (A minus B) intersect A = (A minus B)
            these[j]:= FAIL
          end_if          
        end_if;
      end_for;

      these:= select(these, _unequal, FAIL);
      
      if nops(these) = 0 then
        if nops(others) = 1 then
          return(others[1])
        else
          return(hold(_intersect)(op(others)))
        end_if
      end_if;
      
      if nops(others) = 1 and testtype(others[1], "_minus" ) and
        nops(these)=1 then
        if ( op(others[1], 1)=C_ ) then
          return( op(these) minus op(others[1], 2) )
        end_if;
      end_if;
      if nops(others) = 0 then
        if nops(these) = 1 then
          op(these)
        else
          hold(_intersect)(op(sort(these)));
        end_if;
      else
        hold(_intersect)(op(others), op(sort(these)));
      end_if
    elif nops(these) = 1 then
      return(op(these))
    else
      hold(_intersect)(op(sort(these)))
    end_if
  end_proc:

// intersection with all operands being RootOf
  RootOf::homog_intersect:=
  proc()
    local argv: DOM_SET, idents, forbidden, z, g;
  begin
    argv:= {args()};
    if nops(argv) = 1 then
      return(op(argv, 1))
    end_if;
    
    assert(map(argv, domtype) = {RootOf});
    // get common ident
    idents:= map(argv, extop, 2);
    if nops(idents) = 1 then
      // use that identifier
      z:= op(idents, 1)
    else
      // generate a common RootOf variable that is not a freeIdent
      forbidden:= _union(op(map(argv, freeIndets)));
      z:= solvelib::getIdent(C_, forbidden);
      argv:= map(argv, RootOf::setvar, z)
    end_if;

    // a common root is a common root of the gcd
    argv:= map(argv, op, 1);
    argv:= map(argv, poly, [z]);
    if MAXEFFORT <> RD_INF then
       if traperror((g:= gcdlib::gcdNumeric(op(argv))), MaxSteps = ceil(MAXEFFORT/1000)) <> 0 then
         return(hold(_intersect)(args()))
       end_if  
    else 
   		 g:= gcdlib::gcdNumeric(op(argv))
    end_if;    
    piecewise::extmap(g, u -> if degree(u) = 0 then
                                {}
                              elif degree(u) = 1 then
                                {-coeff(u, 0)/coeff(u, 1)}
                              else
                                RootOf::new(u, z)
                              end_if
                      )
  end_proc:


  RootOf::max:= () -> hold(max)(args());
  RootOf::min:= () -> hold(min)(args());

  RootOf::freeIndets:=
  proc(r: RootOf)
  begin
    freeIndets(op(r, 1), args(2..args(0))) minus {op(r, 2)}
  end_proc:

  // overload solvelib::avoidAliasProblem
  RootOf::avoidAliasProblem:=
  proc(S, vars: DOM_SET)
    local newvar;
  begin
    if contains(vars, extop(S, 2)) then
      newvar:= solvelib::getIdent(C_, vars);
      new(dom, subs(extop(S, 1), extop(S, 2) = newvar), newvar)
    else
      S
    end_if
  end_proc:


  RootOf::map :=
  proc(r : RootOf, f)
  begin
    RootOf(map(extop(r, 1), f, args(3..args(0))), extop(r, 2..extnops(r)));
  end_proc:


  // solve(RootOf(eq(x, y), y), x) returns the set of all x
  // such that eq(x, y) = 0 iff x=0
  RootOf::solve:=
  proc(r: RootOf, x)
    local eq, y, d, coefflist, i;
  begin
    if args(0) < 2 then
      error("No variable to solve for")
    end_if;
    [eq, y]:= [op(r)];
    d:= degree(eq, y);
    coefflist:= [coeff(eq, y, i) $i=0..d];
    // 0 is the only root if eq = c*y^d with nonzero c
    // if c=0, the problem reduces to degree d-1
    if is(coefflist[d+1] <> 0) = TRUE then
      solve(_and(coefflist[i] = 0 $i=1..d), x, args(3..args(0)))
    else
      solve(coefflist[d+1] <> 0 and _and(coefflist[i] = 0 $i=1..d), x,
            args(3..args(0))) union
      RootOf::solve(RootOf(_plus(coefflist[i]*y^(i-1) $i=1..d), y), x,
                    args(3..args(0)))
    end_if           
  end_proc:

  // a is a solution to RootOf(eq, y) iff subs(eq, y=a) is zero
  RootOf::solveIn:=
  proc(a, x, r: RootOf)
  begin
    solve(subs(op(r, 1), op(r, 2) = a), x, args(4..args(0)))
  end_proc:



RootOf::numeric_rationalize:= r -> RootOf(numeric::rationalize(extop(r, 1)),
                                          extop(r, 2..extnops(r))):

  
  
// expand a^i where a is a RootOf 
stdlib::RootOf_expand_power:=proc(a,i) local y;
begin
   if type(i)=DOM_INT then
      y:=op(a,2); 
      return(subs(divide(y^i,op(a,1),Rem),y=a))
   end_if;
   a^i
end_proc: 

// normalizes the fraction f in x, where x=RootOf(p)
stdlib::RootOf_evala := 
proc(f,p,_x)
  local l, fnormal;
begin
  userinfo(1,"f=",f,"p=",p,"x=",_x);
  fnormal:= normal(f, List);
  // now fnormal[1] is the numerator, and fnormal[2] is the denominator of f
  l:= gcdex(fnormal[2],p,_x); 
  // l[1]=denom(f)*l[2]+p*l[3] thus 1/denom(f) = l[2]/l[1] mod p 
  if has(l[1],_x) then 
    error("singular denominator") 
  end_if;
  fnormal[1]*l[2]/l[1]
end_proc:

// computes the sum of the terms in f, where x goes through the roots of p 
stdlib::RootOf_polysum :=
proc(f,p,x)
  local d,y,f1;
begin
  p:= normal(p);
  f1:=divide(f,p,[x],Rem);
  d:=degree(p,[x]);
  if not has(f1,x) then
    d*f1
  else
    y:= genident("y");
    f1:=polylib::resultant(p,numer(y-f1),x);
    normal(-coeff(f1,[y],d-1)/coeff(f1,[y],d))
  end_if
end_proc:

RootOf::TeX :=
(arg1, arg2, arg3) -> generate::TeXseq("\\mathrm{RootOf}(", ")",
				       op(RootOf::print(arg1))):

RootOf::evalAt :=
proc(ro, subst)
  local var, dontsubst, dummy, freevars, X;
begin
  var := extop(ro, 2);
  [subst, dontsubst, dummy]:= split(subst, _not@has, var);
  assert(nops(dummy) = 0);
  // don't keep the ones trying to substitute the bound variable
  dontsubst := select(dontsubst, (eq -> op(eq, 1) <> var));
  // don't keep the ones substituting vars that are absent, either
  freevars := freeIndets(extop(ro, 1)) minus {var};
  dontsubst := select(dontsubst, (eq -> contains(freevars, op(eq, 1))));
  
  if nops(subst) > 0 then
    ro := RootOf(evalAt(extop(ro, 1), subst), extop(ro, 2));
  end_if;
  if nops(dontsubst) > 0 then
    X:= solvelib::getIdent(C_, indets(ro));
    RootOf(evalAt(subs(op(ro, 1), op(ro, 2) = X), dontsubst), X)
  else
    ro;
  end_if;
end_proc:
  
null():

// end of file 