simplify::simplifyCondition::simplifySyntactically::reduceModRPlus := proc ( xpr : Type::Arithmetical, options : DOM_TABLE, respectZero = TRUE  )
  local ready, signs, v,
    s, i, b, ex, res, set, zero, fact, xp,
    results, X, Y,
    decide, isReal, typereal; /*proc */
begin
  if contains( options, "decide" ) then
    decide := options[ "decide" ];
  else
    decide := property::_decide;
  end_if;
  if contains( options, "typereal" ) then
    typereal := options[ "typereal" ];
  else
    typereal := property::_typereal;
  end_if;
  if contains( options, "isReal" ) then
    isReal := options[ "isReal" ];
  else
    isReal := X->bool(typereal(X)=TRUE);
  end_if;
  signs := FAIL;
  if MAXEFFORT>5000.0*length(xpr) and not has(xpr, _power) then
    s := expand(xpr, ArithmeticOnly);
    if length(s) < length(xpr) then
      xpr:= s
    end_if   
  end_if;
  repeat
    ready := TRUE;
    case expr2text(type(xpr))
      of "unit" do
        signs := {1};
        xpr := 1;
        break;
    end_case;
    case type(xpr)
      of DOM_INT do
      of DOM_RAT do
      of DOM_FLOAT do
        if xpr=0 then
          signs := {0};
        elif xpr<0 then
          xpr := -1;
          signs := {-1};
        elif xpr>0 then
          xpr := 1;
          signs := {1};
        end_if;
        break;
      of DOM_IDENT do
        if isReal(xpr) then
          signs := {-1,0,1};
          case decide(xpr<0)
            of TRUE do
              signs := {-1};
              xpr := -1;
              break;
            of FALSE do
              if decide(xpr>0)=TRUE then
                signs := {1};
                xpr := 1;
              else
                signs := {1,0};
              end_if;
              break;
            of UNKNOWN do
              if decide(xpr<=0)=TRUE then
                signs := {-1,0};
              end_if;
              break;
          end_case;
        end_if;
        break;
      of "Im" do
        if isReal(op(xpr)) then
          signs := {0};
          xpr := 0;
          break;
        end;
        signs := {-1,0,1};
        break;
      of "abs" do
        res := simplify::simplifyCondition::simplifySyntactically::reduceModRPlus( op(xpr), options );
        if contains( op(res,2), -1 ) and contains( op(res,2), 1 ) or contains( op(res,2), I ) then
          /* ist nicht reell oder nicht klar ob positiv/negativ */
          xpr := abs( op(res,1) );
          signs := op(res,2) intersect {0} union {1};
        else
          if not contains( op(res,2), 0 ) then
            xpr := 1;
            signs := {1};
          elif contains( op(res,2), 1 ) then
            xpr := op(res,1);
            signs := {0,1};
          elif contains( op(res,2), -1 ) then
            xpr := -op(res,1);
            signs := {0,1};
          end_if;
        end_if;
        break;
      of "exp" do
        /* Ausdruck ist exp(X) bzw. exp(X)
        * Von X alle reellen Summanden entfernen und Vorzeichen normalisieren.
        */
        xpr := op(xpr);
        if type(xpr)="_plus" then
          s := split( xpr, isReal );
          xpr := s[2] + s[3];
        else
          if isReal(xpr) then xpr := 0; end_if;
        end_if;
        if stdlib::hasmsign( xpr )=TRUE then
          xpr := exp( -xpr );
        else
          xpr := exp( xpr );
        end_if;
        if xpr=1 then
          signs := {1};
        end_if;
        break;
      of "_mult" do
        /* Select all factors that are not positive for sure */
        s := split([op(xpr)], X->bool(decide( X>0 )<>TRUE));
        /* Split all negative factors */
        s := split(s[1], X->bool(decide( X<0 )<>TRUE));
        res := (-1)^nops(s[2]); set := {res};
        /* Test all unknown factors */
        for i in s[1] do
          v := simplify::simplifyCondition::simplifySyntactically::reduceModRPlus(i, options, respectZero);
          if contains(v[2], I) then res := FAIL; break; end_if;
          set := set*v[2];
          res := res*v[1];
        end_for;
        if res<>FAIL then
          xpr := res;
          signs := set;
        else
          xpr := _mult(op(s[1]))*(-1)^nops(s[2]);
        end_if;
        break;
      of "_plus" do
        signs := {};
        s := [];
        zero := TRUE;
        results := table();
        for i in [op(xpr)] do
          res := simplify::simplifyCondition::simplifySyntactically::reduceModRPlus(i,options);
          results[i] := res;
          signs := signs union op(res,2);
          if contains( signs, 1 ) and contains( signs, -1 ) or contains( signs, I ) then break; end_if;
          if not contains( op(res,2), 0 ) then zero := FALSE; end_if;
          s := s.[op(res,1)];
        end_for;
        if contains( signs, I ) then signs := FAIL; break; end_if;
        if not contains( signs, 1 ) or not contains( signs, -1 ) then
          if not zero then
            signs := signs minus {0};
            xpr := op(signs);
          else
            xpr := _plus( op(s) );
          end_if;
        else
          v := property::splitRoots(xpr);
          /* X+Y^(1/a) vereinfachen */
          if v<>FAIL then
            [fact, Y, xp, X] := v;
            /* We want to decide X+Y<0 */
            if xp mod 2=0 then
              // X+Y^(a/b) < 0 => X < -Y^(a/b) => X^b < -Y^a => X^b + Y^a < 0
              if decide(X<=0)=TRUE and decide(fact*Y>=0)=TRUE then
                /* X+Y^(a/b) < 0 && X<=0<=Y
                * <=> X < -Y^(a/b)
                * <=> X^b > Y^a
                * <=> - X^b + Y^a < 0
                */
                xpr := -X^xp + fact^xp*Y^xp;
              elif decide(X>=0)=TRUE and decide(fact*Y<=0)=TRUE then
                /* X+Y^(a/b) < 0 && Y<=0<=X
                * <=> X < -Y^(a/b)
                * <=> X^b < Y^a
                * <=> X^b - Y^a < 0
                */
                xpr := X^xp - fact^xp*Y^xp;
              end_if;
            else
              // X+Y^(a/b) < 0 => X < -Y^(a/b) => X^b < -Y^a => X^b + Y^a < 0
              xpr := X^xp + Y^xp;
            end_if;
          end_if;
        end_if;
        break;
      of "_power" do
        [ b, ex ] := [ op(xpr) ];
        if not isReal(b) then break; end_if;
        if type(ex)=DOM_INT then
          res := simplify::simplifyCondition::simplifySyntactically::reduceModRPlus( b, options );
          if ex mod 2=0 then
            if not contains(op(res,2),-1) then
              xpr := op(res,1);
              signs := op(res,2);
            elif not contains(op(res,2),1) then
              xpr := -op(res,1);
              signs := map( op(res,2), _mult, -1 );
            else
              if contains( op(res,2), 0 ) then
              xpr := op(res,1)^2;
                signs := {0,1};
              else
                xpr := 1;
                signs := {1};
              end_if;
            end_if;
          else
            xpr := op(res,1);
            signs := op(res,2);
          end_if;
        elif property::_decide(ex>=0)=TRUE then
          if decide(b>=0)=TRUE then
            if decide(b>0)=TRUE then
              xpr := 1;
              signs := {1};
            else
              xpr := b;
              signs := {0,1};
            end_if;
          end_if;
        end_if;
        break;
      of "Re" do
        /* Re(a*R)>0 <=> R*Re(a)>0 wenn R reell */
        if type(op(xpr,1))="_mult" then
          s := split( op(xpr), isReal );
          if s[1]<>1 then
            xpr := s[1] * hold(Re)( s[2]*s[3] );
            ready := FALSE;
          end_if;
        end_if;
        /* Re(1/a)>0 <=> Re(a)>0 */
        if type(op(xpr,1))="_power" and op(xpr,[1,2])=-1 then
          xpr := hold(Re)(op(xpr,[1,1]));
          ready := FALSE;
        end_if;
        signs := {-1,0,1};
        break;
    end_case;
  until ready end_repeat;

  if signs=FAIL then signs := {-1,0,1, I}; end_if;
  [ xpr,signs ];
end_proc: