/*  */

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::simplifySyntactically::slot_equal := proc( cond : "_equal", options )
  local  decide,
  b, ex, j, r, k,
    i, ready, res, s, v,
    isReal, typereal, /*proc */
    lhs, rhs,
    props, basis, inds,
    reduce: DOM_PROC
    ;
begin
  decide := options[ "decide" ];
  typereal := options[ "typereal" ];
  isReal := options[ "isReal" ];

  if op(cond, 1) = op(cond, 2) then
    return( TRUE );
  end_if;

  /* Do this test again with reversed order */
  /* TODO: tcov=0 */
  if contains( options["props"], op(cond,2)=op(cond,1) )>0 then return( TRUE ); end_if;
  /* TODO: tcov=3 */
  if contains( options["props"], not op(cond,2)=op(cond,1) )>0 then return( FALSE ); end_if;

  if type(op(cond,1))=DOM_LIST and type(op(cond,2))=DOM_LIST and nops(op(cond,1))=nops(op(cond,2)) then
    return( simplifySyntactically( _and( op( zip( op(cond), _equal ) ) ), options ) );
  end_if;

  lhs := rhs := 0;
  if has(cond, infinity) then
    /* replace by : map({op(cond)}, X->type(X)=stdlib::Infinity) = {FALSE, TRUE} */
    if type(op(cond,1)-op(cond,2))=stdlib::Infinity then
      /* <anyterm> * infinity can not be 0 */
      return(FALSE);
    end_if;
    return(cond);
  end_if;
  s := op(cond,1)-op(cond,2);

  if MAXEFFORT> 50.0 then
    b := property::normalGroebner( s );
    if length(b) <= length(s) then
      s:= b
    end_if;
  end_if;

  /* test for constant equations */
  if indets( cond ) minus Type::ConstantIdents={} then
    res := property::constRel( cond );
    if res<>UNKNOWN then return( res ); end_if;
  end_if;

  props := property::showprops( cond );
  basis := op(cond,1)-op(cond,2);
  /* evaluating conditions with piecewises can be very expensive and cause endless recursion, since
   * piecewise itself uses simplifyCondition */
  if not hastype(props, piecewise) and nops(props)>0 and ( inds := [op(indets(basis))] )<> [] and testtype( basis, Type::PolyExpr( inds, Type::Rational) ) then
    basis := groebner::gbasis( [ poly(basis, inds) ], DegInvLexOrder );
    reduce:=
    proc(a)
    begin
      misc::maprec(a, 
      {"int", "sum", "limit", "solve"} = 
      proc(t)
        local tt;
      begin
        tt:= reduce(op(t, 1));
        if tt = op(t, 1) then 
          t
        else
          subsop(t, 1 = tt)
        end_if   
      end_proc,    
      {Type::PolyExpr(inds, Type::Rational)} =
                        proc(t)
                          begin
                            expr(groebner::normalf(poly(t, inds),
                                                   basis, DegInvLexOrder))
                        end_proc
                        ,
                        NoOperators,
                        PostMap
                   )
    end_proc;
    
    props:= solvelib::avoidAliasProblem(props, freeIndets(props));

    if traperror( ( props := _and( op(eval(reduce(props)))) ) )=0 then
      if property::_decide(props)=FALSE then 
        return(FALSE) 
      end_if;
    else
      return(FALSE);
    end_if;
  end_if;
  repeat
    ready := TRUE;
    case type(s) /* some special cases for expr=0 */
      of "cos" do
        return(simplifySyntactically(op(s)/PI-1/2 in Z_, options));
      of "sin" do
        return(simplifySyntactically(op(s)/PI in Z_, options));
      of "abs" do /* abs(x)=0 means x=0 */
         return(simplifySyntactically(op(s)=0, options));
      of "arg" do /* arg(x)=0 means x>=0 */
          return( simplifySyntactically( op(s)>=0, options ) );
      of "ln" do /* ln(x)=0 means x=1 */
          s := op(s)-1;
          ready := FALSE;
          break;
      of "Im" do /* Im(x)=0 is equivalent to x in R_ */
        return( simplifySyntactically( op(s) in  R_, options ) );
      of "Re" do
        /* Re( 1/a )=0 <=> Re( a )=0 */
        if type(op(s,1))="_power" and op(s,[1,2])=-1 then
          s := hold(Re)( op(s,[1,1]) );
          ready := FALSE;
          break;
        end_if;
        /* Re( a*R )=0 <=> Re(a)=0 or R=0 fr R reell */
        if type(op(s,1))="_mult" then
          s := split( op(s), isReal );
          if s[1]<>1 then
            return( simplifySyntactically( s[1]=0 or hold(Re)(s[2]*s[3])=0, options ) );
          else
            s := hold(Re)( s[2] * s[3] );
          end_if;
        end_if;
        break;
      of "exp" do /* exp(x)=0 is false for any x */
      of stdlib::Undefined do /* stdlib::Undefined=0 is FALSE */
        return( FALSE );
      of DOM_INT do /* s = 0 implies TRUE */
      of DOM_RAT do
      of DOM_COMPLEX do
        return( bool(s=0) );
      of DOM_IDENT do /* X = 0 */
        v := decide( s=0 );
        if v<>UNKNOWN then return(v); end_if;
        return( s=0 );
      of "_mult" do /* a*b*c... = 0 */
        return(simplifySyntactically( _or( map(op(s), proc(X)
          begin
            case type(X)
              of DOM_RAT do
              of DOM_INT do
              of DOM_COMPLEX do
              of DOM_FLOAT do
                return(FALSE);
              of "_power" do
                if type(op(X,2))=DOM_INT then
                  if op(X,2)>0 then
                    return(op(X,1)=0);
                  elif op(X,2)<0 then
                    return(FALSE);
                  end_if;
                end_if;
            end_case;
            X=0;
          end_proc ) ), options ));
      of "_power" do
        /* b^ex = 0 <=> b=0 and ex>0 */
        case type(op(s,2))
          of DOM_INT do
          of DOM_RAT do
            if op(s,2)<0 then return( FALSE ); end_if;
            if op(s,2)>0 then s := op(s,1); end_if;
            ready := FALSE;
            break;
          otherwise
            return( simplifySyntactically( op(s,1)=0 and op(s,2)>0, options ) );
        end_case;
        break;
      of "_plus" do
        /* Hauptnenner */
        v := 1/ilcm( map( op(s), X->case type(X)
            of "_mult" do _if( type(op(X,nops(X)))=DOM_RAT, denom(op(X,nops(X))), 1 ); break;
            of DOM_RAT do denom(X); break;
            otherwise 1; break;
          end_case ) );

        /* build some kind of gcd */
        v := v*igcd( map( op(s), X->case type(X)
            of "_mult" do _if( type(op(X,nops(X)))=DOM_INT, op(X,nops(X)), 1 ); break;
            of DOM_INT do X; break;
            otherwise 1; break;
          end_case ) );
        if v<>1 then
          s := map( s, X->X/v );
        end_if;

        /* Factor trivial factors */
        /* Build a set of all summands containing sets of all products
         * i.e. a+b*c+d^2 => { {a}, {b, c}, {d^2} } */
        v := map( op(s), X->_if(type(X)="_mult",{op(X)},{X}) );
        res := FAIL;
        /* Loop over all "summands" and check for common factors */
        for i in v do
          /* Build a table assigning factors to their frequency (i.e. their exponent)
           * i.e. {a, b^2} => table(a=1, b=2) */
          k := table(op(map(i, proc(X)
              begin
                if type(X)="_power" and type(op(X,2))=DOM_INT and op(X,2)>=1 then
                  return(op(X,1)=op(X,2));
                else
                  return(X=1);
                end_if;
              end_proc)));
          /* First iteration => Copy table an go on */
          if res=FAIL then
            res := k;
          else
            /* Second or later iterations check if the common factors appear in the summand with
             * necessary frequency and adept the dataset. */
            r := res;
            for j in r do
              if contains(k, op(j,1)) then
                res[op(j,1)] := min(res[op(j,1)], k[op(j,1)]);
              else
                delete(res[op(j,1)]);
              end_if;
            end_for;
          end_if;
          /* Break if there are no more common factors */
          if nops(res)=0 then break; end_if;
        end_for;
        /* If we have found common factors, divide by them and build disjunctive form
         * i.e. a*m+b*m=0 => a+b=0 or m=0 */
        if nops(res)>0 then
          v := map([op(res)], X->op(X,1)^op(X,2));
          /* don't seperate floats */
          v := select(v, X->not (type(X)=DOM_COMPLEX or type(X)=DOM_FLOAT));
          if nops(v)>0 then
            s := map( s, X->X/_mult(op(v)) );
            return( simplifySyntactically( _or( s=0, op(map( v,X->X=0)) ), options ) );
          end_if;
        end_if;
        break;
    end_case;
  until ready end_repeat;

  if stdlib::hasmsign(s) then s := -s; end_if;
  if type(s)="_plus" then
    s := [op(s)];
  else
    s := [s];
  end_if;

  /* 1. distribute the terms containing indets */
  if indets( s ) minus Type::ConstantIdents<>{} then
    /* special case: s is a sum of products, i.e. s=a+b=0. redistribute all fractions
      * this solve 1/x+1/y = 0 to x=-y */
    if nops(s)=2 and {type(op(s,1)),type(op(s,2))} intersect {"_mult", "_power"}<>{} then
      v := [];
      for i from 1 to 2 do
        r := s[i];
        case type(r)
          of "_power" do
            if testtype( op(r,2), Type::NegInt ) then
              s := subsop( s, i=1, 3-i=( op(s,3-i)*_power(op(r,1),-op(r,2)) ) );
              if not simplify::ignoreSingularities then v:=v.[op(r,1)<>0]; end_if;
            end_if;
            break;
          of "_mult" do
            r := split( [op(r)], X->_lazy_and( type(X)="_power", testtype(op(X,2),Type::Rational), bool(op(X,2)<0) ) );
            if not simplify::ignoreSingularities then v:=v.map(r[1], X->op(X,1)<>0); end_if;
            s := subsop( s, i=_mult(op(r[2])), 3-i=( op(s,3-i)*op(map( r[1], X->subsop(X,2=-op(X,2)) )) ) );
            break;
        end_case;
      end_for;
      if not simplify::ignoreSingularities and nops(v)<>0 then return( simplifySyntactically( _and( _plus(op(s))=0, op(v) ), options ) ); end_if;
      /* recalculate sum */
      s := _plus( op(s) );
      if stdlib::hasmsign(s) then s := -s; end_if;
      if type(s)="_plus" then s := [op(s)]; else s := [s]; end_if;
    end_if;
    s := split( s, X->bool(indets(X) minus Type::ConstantIdents<>{}) );
    /* now s is a list of lists: [ [summands containing indets,...], [summands containing indets,..], [] ] */

    i := s[1]; s := s[2];
    i := split( i, stdlib::hasmsign );
    /* if we have no positive indets, negate anything and put the indets to the left side */
    if i[2]=[] then
      lhs := -_plus( op(i[1]) );
      s := map( s, _negate );
    else
      lhs := _plus( op(i[2]) );
      rhs := -_plus( op(i[1]) );
    end_if;
  end_if;
  /* if we have only indets at one side of the equation this should be on the left side at this point, i.r. indets(lhs)={} => indets(rhs)={} */

  /* 2. distribute all other terms */
  if nops(s)<>0 then
    j := _if( indets( lhs ) minus Type::ConstantIdents={}, 1, 0 ) + _if( indets( rhs ) minus Type::ConstantIdents={}, 2, 0 );
    /* if we have idents on one side, then put the constants on the other one */
    if j=2 then
      rhs := rhs - _plus(op(s));
      /* if we have c*X = a change this to X=a/c */
      if type(lhs)="_mult" then
        s := split( lhs, X->_lazy_and( indets(X) minus Type::ConstantIdents={}, property::constRel(X<>0)=TRUE ) );
        lhs := s[2];
        rhs := rhs/s[1];
      end_if;
    else
      s := split( s, stdlib::hasmsign );
      lhs := lhs+_plus(op(s[2]));
      rhs := rhs-_plus(op(s[1]));
    end_if;
  elif rhs=0 then
    /* now: cond := ( lhs = 0 ) */
    case type(lhs)
      of "_mult" do /* a*b*c... = 0 */
        /* remove all constant multiplicands */
        s := split( lhs, X->_lazy_and( indets(X) minus Type::ConstantIdents={}, property::constRel(X<>0)=TRUE ) );
        if type(s[2])<>"_mult" then return( simplifySyntactically( op(cond,0)( s[2], 0 ), options ) ); end_if;
        /* reduce all _power */
        s := split( [op(s[2])], X->type(X)="_power" );
        s[1] := map( s[1], proc(X)
          begin
            case type(op(X,2))
              of DOM_INT do
              of DOM_RAT do
                if op(X,2)<0 then return(1); end_if;
                if op(X,2)>0 then return( op(X,1) ); end_if;
                break;
            end_case;
            X;
          end_proc );
        lhs := _mult( op(s[1]), op(s[2]) );
        break;
      of "_power" do  /* a^b = 0 */
        if contains( {DOM_INT,DOM_RAT}, type(op(lhs,2)) ) then
          if op(lhs,2)<0 then /* 1/a^n = 0 is false */
            return( FALSE );
          elif op(lhs,2)>0 then /* a^n = 0 <=> a=0 */
            return( simplifySyntactically( op(lhs,1)=0, options ) );
          end_if
        end_if;
    end_case;
  end_if;

  /* some special cases */
  if indets( rhs ) minus Type::ConstantIdents = {} then
    case type(lhs)
      of "sign" do
        if rhs=1 then return( simplifySyntactically( op(lhs)>0, options ) ); end_if;
        if rhs=0 then return( simplifySyntactically( op(lhs)=0, options ) ); end_if;
        if rhs=-1 then return( simplifySyntactically( op(lhs)<0, options ) ); end_if;
        break;
      of "exp" do
        if rhs<>0 and contains( {DOM_FLOAT,DOM_INT,DOM_RAT}, type(rhs) ) and stdlib::hasmsign(op(lhs,1)) then
          lhs := exp( -op(lhs,1) );
          rhs := 1/rhs;
          if type(lhs)<>"exp" then break; end_if;
        end_if;
        if (rhs=1 or rhs=-1) and type(op(lhs))="_mult" and has( lhs, I ) then
          /* Wir machen dies _vorerst_ nur, wenn die Rechte Seite 1/-1 ist und das Argument von exp
           * Den Faktor I enthlt. */
          return( simplifySyntactically( ( op(lhs)-ln(rhs) ) / (2*PI*I) in Z_, options ) );
        end_if;
        break;
      of "_power" do
        [ b, ex ] := [ op(lhs) ];
        /* n-te Wurzel(x) = const */
        if type(op(lhs,2))=DOM_RAT and numer(op(lhs,2))=1 then
          /* Spezialflle sqrt(X)=I und sqrt(X)=-I */
          if type(rhs)=DOM_COMPLEX and Re(rhs)=0 then
            if op(lhs,2)=1/2 and Im(rhs)>0 then
              return(simplifySyntactically(op(lhs,1)=rhs^2, options));
            else
              return(FALSE);
            end_if;
          end_if;
          if ( v := property::constRel( rhs<0 ) )=TRUE then return(FALSE); end_if;
          if v=UNKNOWN then break; end_if;
          if ( v := property::constRel( rhs>=0 ) )=TRUE then
            rhs := _power( rhs, denom(op(lhs,2)) );
            lhs := op(lhs,1);
          elif v=FALSE then
            /* rhs is imaginary */
            /* TODO: Tritt nur auf bei sc(sqrt(x)=I+1) assuming x>0 , was spter noch entschieden wird */
            if isReal( lhs ) then return( FALSE ); end_if;
          end_if;
        elif indets( b ) minus Type::ConstantIdents = {} and indets( ex ) minus Type::ConstantIdents <> {} and isReal(ex) then
          if property::constRel( b>0 )=TRUE and property::constRel( b<>1 )=TRUE then
            if property::constRel(rhs>0)=TRUE then
              return( simplifySyntactically( ex=ln(rhs)/ln(b), options ) );
            elif property::constRel(rhs<=0)=TRUE then
              return( FALSE );
            end_if;
          end_if;
        end_if;
    end_case;
  end_if;

  cond := lhs=rhs;

  i := decide(cond);
  if i<>UNKNOWN then return(i); end_if;
  cond;
end_proc:
