/*  */

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::simplifySyntactically::slot_in := 
proc( cond : "_in", options )
  local  decide,
    i, ready, res, s, set, v,
    isReal, typereal, /*proc */
    indsl, indss, reduceLeftSide, reduceRightSide,
    lhs, rf;
begin
  /* reduceLeftSide(lhs, set)
   * Takes a relation lhs in set where set contains no indets.
   * Tries to rewrite to an equivalent form lhs' in set' where lhs is
   * as simple as possible */
  reduceLeftSide := proc(lhs, set : DOM_SET)
    local s;
  begin
    while TRUE do
      case type(lhs)
        of "_power" do
          /* Check for [f(x)]^-1 and invert if possible. All values beeing 0
           * are removed since by agreement 1/X cannot be 0. */
          if type(op(lhs, 2))=DOM_INT and op(lhs, 2)<0 then
            s := split(set, X->decide(X<>0));
            if nops(s[1])=0 and nops(s[3])=0 then
              lhs := op(lhs, 1)^(-op(lhs, 2));
              set := {};
              break;
            elif nops(s[3])=0 then
              lhs := op(lhs, 1)^(-op(lhs, 2));
              set := map(s[1], X->1/X);
              break;
            end_if;
          end_if;
          return(lhs in set);
        of "_mult" do
          /* Remove constant multiplicative factors and map to the set */
          s := split(lhs, X->testtype(X, Type::Constant) and decide(X<>0)=TRUE);
          lhs := s[2];
          set := map(set, X->X/s[1]);
          if type(lhs)="_mult" then return(lhs in set); end_if;
          break;
        of "_plus" do
          /* Remove constant additive summands and map to the set */
          s := split(lhs, X->testtype(X, Type::Constant));
          lhs := s[2];
          set := map(set, X->X-s[1]);
          if type(lhs)="_plus" then return(lhs in set); end_if;
          break;
        otherwise
          /* Nothing more to do... */
          return(lhs in set);
      end_case;
    end_while;
  end_proc;

  /* reduceRightSide(lhs, set)
   * Takes a relation lhs in set where all elements in set base on one identifier.
   * tries to rewrite to an equivalent form lhs' in set' where lhs' depends on the
   * identifier but not set' and lhs' is as simple as possible. */
  reduceRightSide := proc(lhs, set : DOM_SET)
    local newlhs, newset, i, v;
  begin
    newlhs := FAIL;
    newset := {};
    /* Loop for all entries and reduce each seperatively. If all reduce to the same
     * term this is taken as new lef hand side. */
    for i in set do
      v := reduceLeftSide(i, {lhs});
      if newlhs=FAIL then
        newlhs := op(v,1);
        newset := op(v,2);
      elif newlhs=op(v,1) then
        newset := newset union op(v,2);
      else
        return(lhs in set);
      end_if;
    end_for;
    return(newlhs in newset);
  end_proc;

  decide := options[ "decide" ];
  typereal := options[ "typereal" ];
  isReal := options[ "isReal" ];

  if expr2text(type(op(cond,1)))="piecewise" then return( simplifySyntactically(expand(cond),options) ); end_if;
  if contains({"solve", piecewise, RootOf}, type(op(cond,2))) then
    cond := expand(cond);
    if type(cond)<>"_in" then return(simplifySyntactically(cond,options)); end_if;
  end_if;

  lhs := op(cond,1);
  set := op(cond,2);
  if MAXEFFORT>1000.0 then
    lhs := property::normalGroebner(lhs);
    cond := lhs in set;
  end_if;

  /* call decide. since decide does nothing than mapping for DOM_SET we do this
   * case here and remove FALSE elements. */
  if type(set)=DOM_SET then
    set := split(set, X->decide(X=lhs));
    /* anyone is true => return true */
    if nops(set[1])>0 then return(TRUE); end_if;
    /* no unknown? only false left */
    if nops(set[3])=0 then return(FALSE); end_if;
    /* select the unknown */
    set := set[3];
    cond := lhs in set;
  else
    if (v := decide(cond))<>UNKNOWN then return(v); end_if;
  end_if;

  case type(set)
    of solvelib::BasicSet do
      case set
        of Z_ do
          if type(lhs)<>DOM_IDENT and map(freeIndets(lhs), property::_typeinteger)={TRUE} then
            res := property::checkPolyInteger(lhs, TRUE);
            if res=TRUE or res=FALSE then return(res); end_if;
            if res<>UNKNOWN then return(res in Z_); end_if;
          end_if;
          if type(lhs)="_plus" then
            lhs := select(lhs, X->property::_typeinteger(X)<>TRUE);
          end_if;
          if stdlib::hasmsign(lhs) then
            lhs := -lhs;
          end_if;
          cond := lhs in set;
          break;
        of Q_ do
          if type(lhs)="_plus" then
            lhs := select(lhs, X->decide(X in Q_)<>TRUE);
          end_if;
          if type(lhs)="_mult" then
            lhs := select(lhs, X->decide(X in Q_)<>TRUE or decide(X<>0)<>TRUE);
          end_if;
          if contains(Type::ConstantIdents, lhs) then
            return(FALSE);
          end_if;
          if contains({DOM_INT, DOM_RAT}, type(lhs)) then
            return(TRUE);
          end_if;
          if stdlib::hasmsign(lhs) then
            lhs := -lhs;
          end_if;
          cond := lhs in set;
          break;
      end_case;
      break;
    of "_union" do
      res := [];
      for i in [op(set)] do
        v := decide( lhs in i );
        if v=UNKNOWN then
          res := res.[i];
        elif v=TRUE then
          return(TRUE);
        end_if;
      end_for;
      case nops(res)
        of 0 do return(FALSE);
        of 1 do return( simplifySyntactically( lhs in op(res), options ) );
        otherwise return( lhs in _union(op(res)) );
      end_case;
      break;
    of "_minus" do
      if decide( lhs in op(set,1) )=TRUE then //op(set,1)=R_ and typereal( lhs )=TRUE then
        return(simplifySyntactically( not lhs in op(set,2), options ) );
      end_if;
      break;
    of DOM_SET do
      indsl := freeIndets(lhs);
      indss := freeIndets(set);
      if nops(indsl)=1 and nops(indss)=0 then
        v := reduceLeftSide(lhs, set);
        cond := v;
        [lhs, set] := [op(v)];
      elif nops(indsl)=0 and nops(indss)=1 then
        if map(set, has, op(indss))={TRUE} then
          v := reduceRightSide(lhs, set);
          cond := v;
          [lhs, set] := [op(v)];
        end_if;
      end_if;
      break;
    of Dom::Interval do
      if Dom::Interval::right(set)<>infinity and Dom::Interval::left(set)=-infinity then
        if Dom::Interval::isrightopen(set) or decide(lhs=Dom::Interval::right(set))=FALSE then
          return(simplifySyntactically(lhs < Dom::Interval::right(set), options));
        else
          return(simplifySyntactically(lhs <= Dom::Interval::right(set), options));
        end_if;
      end_if;
      if Dom::Interval::right(set)=infinity and Dom::Interval::left(set)<>-infinity then
        if Dom::Interval::isleftopen(set) or decide(lhs=Dom::Interval::left(set))=FALSE then
          return(simplifySyntactically(lhs > Dom::Interval::left(set), options));
        else
          return(simplifySyntactically(lhs >= Dom::Interval::left(set), options));
        end_if;
      end_if;
      if freeIndets(lhs)={} or freeIndets(set) intersect freeIndets(lhs)<>{} then
        return(simplifySyntactically(expand(lhs in set), options));
      end_if;
      if stdlib::hasmsign(lhs) then
        lhs := -lhs; set := -set;
      end_if;

      rf:= property::_rectform(lhs);
      if rf <> FAIL and rf[2] <> 0 then
        return(simplifySyntactically(rf[1] in set and rf[2] = 0, options));
      end_if;

      cond := lhs in set;
      break;
  end_case;

  if type(set)=DOM_SET and nops(set)=1 then
    return( simplifySyntactically( op(cond,1)=op(set), options ) );
  end_if;

  repeat
    ready := TRUE;
    /* copy&pasted from piecewise::simplifyCondition */
    if op(cond, 2) = R_ then
      case type(op(cond, 1))
        of "_mult" do
          s := split( op(cond,1), a -> decide( a in R_ )=TRUE );
          if s[1]<>1 then
            return( simplifySyntactically(s[2] in R_ or s[1]=0, options ) );
          end_if;
          break;
        of "_plus" do
          s := split(op(cond,1), isReal);
          if s[1]<>0 then
            cond := subsop(cond, 1=s[2]+s[3]);
            ready := FALSE;
          end_if;
          break;
        of "_power" do
          // some very important special cases
          case op(cond, [1, 2])
            of -1 do
              return(simplifySyntactically(op(cond, [1, 1]) in R_, options))
            of 1/2 do
              return(simplifySyntactically(op(cond, [1, 1]) >= 0, options))
            of -1/2 do
              return(simplifySyntactically(op(cond, [1, 1]) > 0, options))
          end_case;
          break
        of "exp" do
          cond:= Im(op(cond, [1, 1]))/PI in Z_;
          return(simplifySyntactically(cond, options))
        of "ln" do
          return(simplifySyntactically(op(cond, [1, 1]) > 0, options))
        of "sign" do
          return(simplifySyntactically(op(cond, [1, 1]) in R_, options))
        of "arcsin" do
        of "arccos" do
          return( simplifySyntactically( op(cond, [1, 1]) in Dom::Interval([-1, 1]), options ) );
      end_case;
    elif type(op(cond,2))=DOM_SET then
      if type(op(cond,1))="_power" and op(cond,[1,2])=1/2 then
        set := op(cond,2) minus {-I};
        if nops(set)=1 then
          return( simplifySyntactically( op(cond,1)=op(set), options ) );
        end_if;
        cond := subsop(cond, 2=set);
      end_if;
    end_if;
  until ready end_repeat;
  cond;
end_proc:
