/*  */

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::simplifySyntactically::slot_less := proc( cond : Type::Union("_less","_leequal"), options )
  local  decide,
  b, ex, inds, j, r,
    i, ready, res, s, v,
    isReal, typereal, /*proc */
    lhs, rhs, fastFactor, lhsr, rhsr;
begin
  decide := options[ "decide" ];
  typereal := options[ "typereal" ];
  isReal := options[ "isReal" ];

  fastFactor := proc(xpr, full=FALSE)
    local v, res, i, k, r, j, common_denom, orig;
  begin
    case type(xpr)
      of "_mult" do
        return(map(xpr, fastFactor, full));
      of "_plus" do
        break;
      of "_power" do
        return(fastFactor(op(xpr,1), full)^op(xpr,2));
      otherwise
        return(xpr);
    end_case;
    if full then
      /* Hauptnenner */
      v := 1/ilcm( map( op(xpr), X->case type(X)
          of "_mult" do _if( type(op(X,nops(X)))=DOM_RAT, denom(op(X,nops(X))), 1 ); break;
          of DOM_RAT do denom(X); break;
          otherwise 1; break;
        end_case ) );

      /* build some kind of gcd */
      v := v*igcd( map( op(xpr), X->case type(X)
          of "_mult" do _if( type(op(X,nops(X)))=DOM_INT, op(X,nops(X)), 1 ); break;
          of DOM_INT do X; break;
          otherwise 1; break;
        end_case ) );
      if v<>1 then
        if v<0 then v:=-v; end_if;
        xpr := map( xpr, X->X/v );
      end_if;
    end_if;

    orig := xpr;
    common_denom := select([op(xpr)], X->type(X)="_mult");
    common_denom := map(common_denom, Y->select([op(Y)], X->(bool(type(X)="_power") and bool(type(op(X,2))=DOM_INT) and op(X,2)<0)));
    common_denom := {op(map(common_denom, op))} union select({op(xpr)}, X->(bool(type(X)="_power") and bool(type(op(X,2))=DOM_INT) and op(X,2)<0));
    common_denom := _mult(op(map(common_denom, X->1/X)));
    //common_denom := 1;
    if common_denom<>1 then
      xpr := map(xpr, X->X*common_denom);
      if type(xpr)<>"_plus" then
        return(xpr/common_denom);
      end_if;
    end_if;

     // is_quadratic := proc(subxpr)
      // local v, i, res;
    // begin
      // case type(subxpr)
        // of "_power" do
          // if type(op(subxpr, 2))=DOM_INT and op(subxpr, 2) mod 2=0 then
            // return(op(subxpr, 1)^(op(subxpr, 2)/2));
          // else
            // return(FALSE);
          // end_if;
        // of DOM_INT do
          // v := sqrt(subxpr);
          // if type(v)=DOM_INT then
            // return(v);
          // else
            // return(FALSE);
          // end_if;
        // of "_mult" do
          // res := [];
          // for i in [op(subxpr)] do
            // if (v := is_quadratic(i))=FALSE then
              // return(FALSE);
            // end_if;
            // res := res.[v];
          // end_for;
          // return(_mult(op(res)));
        // otherwise
          // return(FALSE);
      // end_case;
    // end_proc:

    // if type(xpr)="_plus" and nops(xpr)=2 then
      // if stdlib::hasmsign(op(xpr,1)) and not stdlib::hasmsign(op(xpr,2)) then
        // if (i:=is_quadratic(-op(xpr,1)))<>FALSE and (j:=is_quadratic(op(xpr,2)))<>FALSE then
          // return((j-i)*(i+j));
        // end_if;
      // elif not stdlib::hasmsign(op(xpr,1)) and stdlib::hasmsign(op(xpr,2)) then
        // if (i:=is_quadratic(op(xpr,1)))<>FALSE and (j:=is_quadratic(-op(xpr,2)))<>FALSE then
          // return((i-j)*(i+j));
        // end_if;
      // end_if;
    // end_if;

    /* Factor trivial factors */
    /* Build a set of all summands containing sets of all products
      * i.e. a+b*c+d^2 => { {a}, {b, c}, {d^2} } */
    v := map( op(xpr), X->_if(type(X)="_mult",{op(X)},{X}) );
    res := FAIL;
    /* Loop over all "summands" and check for common factors */
    for i in v do
      /* Build a table assigning factors to their frequency (i.e. their exponent)
        * i.e. {a, b^2} => table(a=1, b=2) */
      k := table(op(map(i, proc(X)
          begin
            if type(X)="_power" and type(op(X,2))=DOM_INT and op(X,2)>=1 then
              return(op(X,1)=op(X,2));
            else
              return(X=1);
            end_if;
          end_proc)));
      /* First iteration => Copy table an go on */
      if res=FAIL then
        res := k;
      else
        /* Second or later iterations check if the common factors appear in the summand with
          * necessary frequency and adept the dataset. */
        r := res;
        for j in r do
          if contains(k, op(j,1)) then
            res[op(j,1)] := min(res[op(j,1)], k[op(j,1)]);
          else
            delete(res[op(j,1)]);
          end_if;
        end_for;
      end_if;
      /* Break if there are no more common factors */
      if nops(res)=0 then break; end_if;
    end_for;
    /* If we have found common factors, divide by them */
    if nops(res)>0 /*and FALSE */then
      v := map([op(res)], X->op(X,1)^op(X,2));
      xpr := map( xpr, X->X/_mult(op(v)) );
      xpr := xpr*_mult(op(v));
    else
//      return(orig);
    end_if;
    xpr/common_denom;
  end_proc:

  /* Unter annahme der Groebnerbasis reduzieren */
  if MAXEFFORT>1000.0 then
    cond := property::normalGroebner(cond);
  end_if;

  lhs := op(cond,1);
  rhs := op(cond,2);

  /* x < infinity or -infinity < x => x in R_ */
  if type(cond)="_less" then
    if lhs=-infinity or lhs=RD_NINF then
      if rhs=infinity or rhs=RD_INF then return(TRUE); end_if;
      return( simplifySyntactically( rhs in R_, options ) );
    end_if;
    if rhs=infinity or rhs=RD_INF then return( simplifySyntactically( lhs in R_, options ) ); end_if;
    if lhs=infinity or lhs=RD_INF then return( FALSE ); end_if;
    if rhs=-infinity or rhs=RD_NINF then return( FALSE ); end_if;
  end_if;
  if type(cond)="_leequal" then
    if lhs=-infinity or lhs=RD_NINF then
      if rhs=infinity or rhs=RD_INF then return(TRUE); end_if;
      return( simplifySyntactically( rhs in R_, options ) );
    end_if;
    if rhs=infinity or rhs=RD_INF then return( simplifySyntactically( lhs in R_, options ) ); end_if;
    if lhs=infinity or lhs=RD_INF then return( FALSE ); end_if;
    if rhs=-infinity or rhs=RD_NINF then return( FALSE ); end_if;
  end_if;

  /* flatten x < y < z to  (x < y) and (y < z) */
  if contains( {"_less", "_leequal"}, type(lhs) ) then
    return( simplifySyntactically( lhs and subsop(cond,1=op(lhs,2)), options ) );
  end_if;
  if contains( {"_less", "_leequal"}, type(rhs) ) then
    return( simplifySyntactically( subsop(cond,2=op(rhs,1)) and rhs, options ) );
  end_if;

  inds := freeIndets( cond );

  /* test for constant relations */
  if inds={} then
    res := property::constRel( cond );
    if res<>UNKNOWN then return( res ); end_if;
  end_if;

  /* special case: X <=,<,<>,= X */
  if lhs=rhs then
    if type(cond)="_less" then return(FALSE); end_if;
    v := typereal( lhs );
    if v<>UNKNOWN then return(v); end_if;
    /* TODO: remove simplify::ignoreImplicitR_Property */
    if simplify::ignoreImplicitR_Property then
      return( TRUE );
    else
      return( simplifySyntactically( lhs in R_, options ) );
    end_if;
  end_if;

  /* lhs<=rhs implies lhs-rhs<=0 so if this is FALSE lhs<=rhs is FALSE too */
  if type(cond)="_less" then
    v := decide( lhs-rhs<0 );
  else
    v := decide( lhs-rhs<=0 );
  end_if;
  if v=FALSE then return(FALSE); end_if;

  lhsr := typereal(lhs);
  rhsr := typereal(rhs);
  if v=TRUE and (lhsr or rhsr)=TRUE then return(TRUE); end_if;

  /* test if lhs/rhs are real */
  if (lhsr=FALSE or rhsr=FALSE) and (not has( [lhs, rhs], {infinity,RD_INF,RD_NINF} ) or has([lhs, rhs], I*infinity)) then
    return(FALSE);
  end_if;

  /* test if lhs, rhs are linear with real constants */
  if nops(inds)=1 then
    if ( r := Type::Linear( rhs, [op(inds)] ) )<>FALSE and ( s := Type::Linear( lhs, [op(inds)] ) )<>FALSE then
      if isReal( r ) and isReal( s ) then
        if r[1]=s[1] then
          v := decide( r[2]-s[2]>0 ):
          if v=TRUE then
            if simplify::ignoreImplicitR_Property then
              return(TRUE);
            else
              return( simplifySyntactically( op(inds) in R_, options ) );
            end_if;
          end_if;
        end_if;
        s[1] := s[1]-r[1];
        s[2] := s[2]-r[2];
        if numeric::isnonzero( s[1] )=TRUE then
          lhs := lhs-rhs; rhs := 0;
        end_if;
      end_if;
    end_if;
  end_if;

  if type(lhs)="_plus" then
    [s,lhs,r] := split( lhs, X->isReal(X) );
  elif isReal(lhs) then
    s := lhs; lhs := 0;
  else
    s := 0;
  end_if;
  if type(rhs)="_plus" then
    [i,rhs,r] := split( rhs, X->isReal(X) );
    s := s-i;
  elif isReal(rhs) then
    s := s-rhs; rhs := 0;
  end_if;

  /* Unter annahme der Groebnerbasis reduzieren */
  if MAXEFFORT>1000.0 then
    s := property::normalGroebner( s );
  end_if;

  lhs := fastFactor(lhs, rhs=0 or s=0);
  rhs := fastFactor(rhs, lhs=0 or s=0);
  s := fastFactor(s, rhs=0 or lhs=0);

  if lhs=0 and rhs=0 then
    v := simplify::simplifyCondition::simplifySyntactically::reduceModRPlus( s, options, bool(type(cond)="_less") );
    if not contains( v[2], -1 ) then
      if type(cond)="_less" then return( FALSE ); end_if;
      return( simplifySyntactically(v[1]=0, options) );
    end_if;
    if v[2]={-1,0} then
      if type(cond)="_leequal" then return( TRUE ); end_if;
      return( simplifySyntactically(v[1]<>0, options) );
    end_if;
    if v[2]={-1} then return( TRUE ); end_if;
    s := v[1];
  end_if;

  if s<>0 then
    /* 1. distribute the terms containing indets */
    if indets( s ) minus Type::ConstantIdents<>{} then
      if type(s)="_plus" then
        s := split( s, X->bool(indets(X) minus Type::ConstantIdents<>{}) );
      else
        s := [ s, 0, 0 ];
      end_if;
      i := s[1]; s := s[2];
      if type(i)="_plus" then
        i := split( i, stdlib::hasmsign );
        lhs := lhs+i[2];
        rhs := rhs-i[1];
      elif stdlib::hasmsign(i) then
        rhs := rhs - i;
      else
        lhs := lhs + i;
      end_if;
    end_if;
    /* 2. distribute all other terms */
    j := _if( indets( lhs ) minus Type::ConstantIdents={}, 1, 0 ) + _if( indets( rhs ) minus Type::ConstantIdents={}, 2, 0 );
    if j=1 or j=2 then
      if j=1 then
        lhs := lhs + s;
      else
        rhs := rhs - s;
      end_if;
    else
      if type(s)="_plus" then
        s := split( s, stdlib::hasmsign );
        lhs := lhs+s[2];
        rhs := rhs-s[1];
      elif stdlib::hasmsign(s) then
        rhs := rhs - s;
      else
        lhs := lhs + s;
      end_if;
    end_if;
  else
    j := _if( indets( lhs ) minus Type::ConstantIdents={}, 1, 0 ) + _if( indets( rhs ) minus Type::ConstantIdents={}, 2, 0 );
  end_if;

  if j=3 then
    j := _if( rhs=0, 2, 1 );
  end_if;

  if j=1 or j=2 then
    if j=1 then i:= lhs; lhs := rhs; rhs := i; end_if;
    repeat
      ready := TRUE;
      case type(lhs)
        of "ln" do
          if j=2 then
            /* ln(x)<Y <=> x in ]0,exp(Y)[
              * ln(x)<=Y <=> x in ]0,exp(Y)]
              */
            if type(cond)="_leequal" then
              return(simplifySyntactically(op(lhs) in Dom::Interval(0,[exp(rhs)]), options));
            else
              return(simplifySyntactically(op(lhs) in Dom::Interval(0,exp(rhs)), options));
            end_if;
          else
            /* ln(x)>Y <=> x in ]exp(Y), infinity[
              * ln(x)>=Y <=> x in [exp(Y), infinity[
              */
            if type(cond)="_leequal" then
              return(simplifySyntactically(op(lhs) in Dom::Interval([exp(rhs)], infinity), options));
            else
              return(simplifySyntactically(op(lhs) in Dom::Interval(exp(rhs), infinity), options));
            end_if;
          end_if;
          break;
        of "exp" do
          if rhs=0 then
            /* Ausdruck ist 0<=exp(X) bzw. exp(X)<=0
            * Von X alle reellen Summanden entfernen und Vorzeichen normalisieren.
            */
            lhs := op(lhs);
            if type(lhs)="_plus" then
              s := split( lhs, isReal );
              lhs := s[2] + s[3];
            end_if;
            if stdlib::hasmsign( lhs )=TRUE then
              lhs := exp( -lhs );
            else
              lhs := exp( lhs );
            end_if;
          end_if;
          break;
        of "_mult" do
          if rhs=0 then
            s := [op(lhs)];
            /* first remove all positive factors */
            s := split( s, X->decide( X>0 ) );
            lhs := _mult( op(s[3]) );
            /* second remove all negative factors */
            s := split( s[2], X->decide( X<0 ) );
            i := ( nops( s[1] ) mod 2 )=1;
            lhs := _mult( op(s[2]), op(s[3]) ) * lhs;
          else
            s := split( lhs, X->testtype(X, Type::Constant ) );
            if ( i := property::constRel( s[1]<0 ) )<>TRUE then
              if ( i := not property::constRel( s[1]>0 ) )<>FALSE then
                break;
              end_if;
            end_if;
            rhs := rhs / s[1];
            lhs := s[2];
          end_if;
          if i then j := 3-j; end_if;
          break;
        of "_power" do
          [ b, ex ] := [ op(lhs) ];
          /* Input:
           * 1.  b^(1/n) <= nonpos
           * 2.  b^(1/n) < nonpos
           * with n in Z_{1, -1} and nonpos <= 0.
           *
           * Cases:
           * 1. nonpos < 0
           *    => FALSE
           * 2. nonpos = 0 && cond = '<=' && n > 0
           *    => b = 0
           * 3. nonpos = 0 && (cont = '<' || n < 0)
           *    => FALSE
           */
          if j=2 and not iszero(ex) and type(1/ex)=DOM_INT and ex<>-1 and ex<>1 then
            if type(cond)="_less" or ex<0 then
              if decide(rhs<=0, "Constant"=TRUE)=TRUE then
                return(FALSE);
              end_if;
            else 
              if iszero(rhs) then
                return(simplifySyntactically(b=0, options));
              end_if;
              if decide(rhs<0, "Constant"=TRUE)=TRUE then
                return(FALSE);
              end_if;
            end_if;
          end_if;

          if iszero(rhs) then
            if type(ex)=DOM_INT then
              if ex=2 and j=1 then
                if type(cond)="_leequal" then
                  return( simplifySyntactically( b in R_, options ) );
                else
                  return( simplifySyntactically( b in R_ minus {0}, options ) );
                end_if;
              elif ex<0 then
                if not simplify::ignoreSingularities then
                  cond := hold(_less)(0,0);
                end_if;
                if ex mod 2=0 then
                  lhs := b^2;
                else
                  lhs := b;
                end_if;
              end_if;
            elif ex=1/2 and j=1 then
              lhs := b;
            end_if;
          end_if;
          break;
        of "Re" do
          if isReal(op(lhs)) then
            ready := FALSE;
            lhs := op(lhs);
            break;
          end_if;
          if rhs=0 then
            /* Re(a*R)>0 <=> R*Re(a)>0 wenn R reell */
            if type(op(lhs,1))="_mult" then
              s := split( op(lhs), isReal );
              if s[1]<>1 then
                lhs := s[1] * hold(Re)( s[2]*s[3] );
                ready := FALSE;
              end_if;
            end_if;
            /* Re(1/a)>0 <=> Re(a)>0 */
            if type(op(lhs,1))="_power" and op(lhs,[1,2])=-1 then
              lhs := hold(Re)(op(lhs,[1,1]));
              ready := FALSE;
            end_if;
          end_if;
          break;
      end_case;
    until ready end_repeat;
    if j=1 then i:= lhs; lhs := rhs; rhs := i; end_if;
  end_if;

  cond := subsop( cond, 1=lhs, 2=rhs );
  i := decide(cond);
  if i<>UNKNOWN then return(i); end_if;
  cond;
end_proc:

simplify::simplifyCondition::simplifySyntactically::slot_leequal := simplify::simplifyCondition::simplifySyntactically::slot_less: