// 

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::simplifySyntactically::slot_or := proc ( cond:"_or", options )
  local operands, ops, i, j, o2, s, res, i1, i2, k, v, set, tset,
      vartypes, /* list of all vars which are implicit declard real/ not real */
      orv, ourv, /* realvars, unrealvars */
      implicitAssumptions, /* proc */
      decide, o1, tt1, tt2,
    sstr, oldLength;
  save MAXEFFORT;
begin
  decide := options[ "decide" ];

  cond := simplify::simplifyLogic( cond );
  if type(cond)<>"_or" then return( simplifySyntactically(cond, options) ); end_if;
  if MAXEFFORT<nops(cond)*10 then
    return(cond);
  end_if;

  /* save variables */
  orv := options["realvars"];
  ourv := options["unrealvars"];

  cond := [op(cond)];
  sstr := [ "_in", "_equal", "_unequal", "_less", "_leequal", "_not", "_and" ];
  cond := sort( cond, (a,b)->freeIndets(a)<>{} and ( freeIndets(a)={} or bool(contains( sstr, a )-contains( sstr, b )>0) ) );
  operands := [];
  ops := {};

  /* get the list of all implicit real/ not real declard identifiers */
  implicitAssumptions := proc(X=null() )
  begin
    case type(X)
      of "_not" do
        X := op(X,1);
        case type(X)
          of "_in" do
            if  type(op(X,1))=DOM_IDENT then
              case type(op(X,2))
                of solvelib::BasicSet do
                  if op(X,2)<>C_ then
                    return( [ {op(X,1)}, {} ] );
                  end_if;
                of Dom::Interval do
                  return( [ {op(X,1)}, {} ] );
              end_case;
            end_if;
            break;
        of "_less" do
        of "_leequal" do
          if type(op(X,1))=DOM_IDENT then return( [ {op(X,1)}, {} ] ); end_if;
          if type(op(X,2))=DOM_IDENT then return( [ {op(X,2)}, {} ] ); end_if;
          break;
        end_case;
      of "_in" do
        if type(op(X,1))=DOM_IDENT and op(X,2)=R_ then
          return( [ {}, {op(X,1)} ] );
        end_if;
        break;
      end_case;
      return( [ {}, {} ] );
    end_proc;
  vartypes := map( cond, implicitAssumptions );
  /* if identifiers can be real AND not real this is TRUE */
  if _union( op(map( vartypes, op, 1 )) ) intersect _union( op(map( vartypes, op, 2 )) ) <> {} then
    return(TRUE);
  end_if;

  i := 1;
  oldLength := nops(cond);
  MAXEFFORT := MAXEFFORT/nops(cond);
  while i<=nops(cond) do
    /* update realvars/ unrealvars */
    if i<=nops(vartypes) then
      options["realvars"] := _union( orv, op(map( subsop(vartypes,i=[{},{}]), op, 1 )) );
      options["unrealvars"] := _union( ourv, op(map( subsop(vartypes,i=[{},{}]), op, 2 )) );
    else
      options["realvars"] := _union( orv, op(map( vartypes,op, 1 )) );
      options["unrealvars"] := _union( ourv, op(map( vartypes, op, 2 )) );
    end_if;
    options["decide"] := cond -> options["_decide"](cond, options );
    options["typereal"] := cond -> options["_typereal"](cond, options );
    options["isReal"] := proc(xpr) local O; begin O := options; O["seek"] = TRUE; bool( O["_typereal"](xpr, O )=TRUE ) end_proc;
    v := simplifySyntactically( cond[i], options );

    if i>oldLength and type(v)="_and" then
      if {op(v)} intersect {op(operands)} <> {} then
        v := null();
      else
        v:={op(v)} minus map({op(operands)}, _not);
        v:=_and(op(v));
      end_if;
    end_if;

    case type(v)
      of DOM_BOOL do
        if v=TRUE then return(TRUE); end_if;
        if v=FALSE then v:=null(); end_if;
        break;
      of "_or" do
        operands := operands.[op(v)];
        v:=null();
        break;
      of "_in" do
        if type(op(v, 2))=DOM_SET then
          /* check for "X in {x1, ..., xn}"
           * If we have the condition "Y1 or ... or Yn or X in {x1, ..., xn}"
           * and x=xi implies "Y1 or ... Yn" the last term can be rewritten to
           * X in {x1, ..., xi-1, xi+1, ..., xn}
           */
          res := op(v, 1);
          set := op(v, 2);
          // search for linear shifted identifier
          k := FALSE;
          for i2 in freeIndets(res) do
            if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; else break; end_if;
          end_for;
          if k=FALSE or decide(k[1]<>0)<>TRUE then break; end_if;
          // try all parts that have already been checked
          j := 1;
          while j<=nops(operands) do
            if set={} then break; end_if;
            if contains( indets(operands[j] ), i1 ) then
              tset := set;
              for s in tset do
                /* substitute and do a fast decision. */
                if traperror( ( res := subs( operands[j], i1=(s-k[2])/k[1] ) ) )=0 and decide(res)=TRUE then
                  set := set minus {s};
                  if set={} then break; end_if;
                end_if;
              end_for;
            end_if;
            j := j+1;
          end_while;
          // try all parts that will be checked
          j := i+1;
          while j<=nops(cond) do
            if set={} then break; end_if;
            if contains( indets(cond[j] ), i1 ) then
              tset := set;
              for s in tset do
                /* substitute and do a fast decision. */
                if traperror( ( res := subs( cond[j], i1=(s-k[2])/k[1] ) ) )=0 and decide(res)=TRUE then
                  set := set minus {s};
                  if set={} then break; end_if;
                end_if;
              end_for;
            end_if;
            j := j+1;
          end_while;
          if set={} then
            // if the condition simplifies to "X in {}" it is false an therefore can be discarded
            v := null();
          elif nops(set)=1 then
            // "X in {x1}" will be rewritten to X=x1 (and checked later again)
            cond := cond.[op(v, 1)=op(set)];
            v := null();
          else
            // in any other case, use the new form
            v := op(v, 1) in set;
          end_if;
        end_if;
        break;
      of "_not" do
        if type(op(v))="_in" and type(op(v, [1,2]))=DOM_SET then
          /* check for "not X in {x1, ..., xn}"
           * If we have the condition "Y1 or ... or Yn or not X in {x1, ..., xn}"
           * and x=xi implies "Y1 or ... Yn" the last term can be rewritten to
           * not X in {x1, ..., xi-1, xi+1, ..., xn}
           */
          res := op(v, [1,1]);
          set := op(v, [1,2]);
          // search for linear shifted identifier
          k := FALSE;
          for i2 in freeIndets(res) do
            if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; else break; end_if;
          end_for;
          if k=FALSE or decide(k[1]<>0)<>TRUE then break; end_if;
          // try all parts that have already been checked
          j := 1;
          while j<=nops(operands) do
            if set={} then break; end_if;
            if contains( indets(operands[j] ), i1 ) then
              tset := set;
              for s in tset do
                /* substitute and do a fast decision. */
                if traperror( ( res := subs( operands[j], i1=(s-k[2])/k[1] ) ) )=0 and decide(res)=TRUE then
                  set := set minus {s};
                  if set={} then break; end_if;
                end_if;
              end_for;
            end_if;
            j := j+1;
          end_while;
          // try all parts that will be checked
          j := i+1;
          while j<=nops(cond) do
            if set={} then break; end_if;
            if contains( indets(cond[j] ), i1 ) then
              tset := set;
              for s in tset do
                /* substitute and do a fast decision. */
                if traperror( ( res := subs( cond[j], i1=(s-k[2])/k[1] ) ) )=0 and decide(res)=TRUE then
                  set := set minus {s};
                  if set={} then break; end_if;
                end_if;
              end_for;
            end_if;
            j := j+1;
          end_while;
          if set={} then
            // if the condition simplifies to "not X in {}" it is true and therefore the full disjunctive form
            return(TRUE);
          elif nops(set)=1 then
            // "not X in {x1}" will be rewritten to X<>x1 (and checked later again)
            cond := cond.[op(v, [1,1])<>op(set)];
            v := null();
          else
            // in any other case, use the new form
            v := not(op(v, [1,1]) in set);
          end_if;
        end_if;
        break;
      of "_unequal" do
        res := op(v,1) - op(v,2);
        k := FALSE;
        for i2 in freeIndets(res) do
          if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; end_if;
        end_for;
        if k=FALSE or decide(k[1]<>0)<>TRUE then break; end_if;
        s := -k[2]/k[1];
        j := 1;
        while j<=nops(operands) do
          if contains( indets(operands[j] ), i1 ) then
            /* substitute and do a fast decision. if it can't be decided put it back into the queue */
            if traperror( ( res := property::normalGroebner( operands[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            if res=operands[j] then j:=j+1; next; end_if;
            case decide(res)
              of UNKNOWN do cond := cond.[res]; break;
              of TRUE do return(TRUE);
            end_case;
            delete( operands[j] );
            j := j-1;
          end_if;
          j := j+1;
        end_while;
        j := i+1;
        while j<=nops(cond) do
          if contains( indets(cond[j] ), i1 ) then
            if traperror( ( res := property::normalGroebner( cond[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            /* substitute and do a fast decision. if it can't be decided let it in the queue */
            case decide(res)
              of UNKNOWN do cond[j] := res; break;
              of TRUE do return(TRUE);
              of FALSE do cond[j] := FALSE; break;
            end_case;
          end_if;
          j := j+1;
        end_while;
        break;
      of "_equal" do
        res := op(v,1) - op(v,2);
        k := FALSE;
        for i2 in freeIndets(res) do
          if k=FALSE then k := Type::Linear( res, [i2] ); i1 := i2; end_if;
        end_for;
        if k=FALSE or decide(k[1]<>0)<>TRUE then break; end_if;
        s := -k[2]/k[1];
        j := 1;
        while j<=nops(operands) and v<>null() do
          if contains( indets(operands[j] ), i1 ) then
            if traperror( ( res := property::normalGroebner( operands[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            case decide(res)
              of TRUE do v:=null();
            end_case;
          end_if;
          j := j+1;
        end_while;
        j := i+1;
        while j<=nops(cond) and v<>null() do
          if contains( indets(cond[j] ), i1 ) then
            if traperror( ( res := property::normalGroebner( cond[j], i1=s ) ) )<>0 then res := FALSE; end_if;
            case decide(res)
              of TRUE do v:=null();
            end_case;
          end_if;
          j := j+1;
        end_while;
        break;
    end_case;

    /* d) check for pairs of relations with
      * (A op B) and (A op B)
      * or
      * (A op B) and (B op A)
      */
    o1 := v;
    case type(v)
      of "_not" do
        if not contains( {"_less", "_leequal", "_equal", "_unequal"}, type( op(v) ) ) then break; end_if;
        o1 := op(v);
      of "_less" do
      of "_leequal" do
      of "_equal" do
      of "_unequal" do
        if _subset( {op(o1)}, ops )=TRUE then
          j := 1;
          tt1 := type(o1);
          if type(v)="_not" then tt1 := "not".tt1; end_if;
          while j<=nops(operands) and v<>null() do
            o2 := operands[j];
            if contains( {"_less", "_leequal", "_equal", "_unequal"}, type( o2 ) ) or (type(o2)="_not" and contains( {"_less", "_leequal", "_equal", "_unequal"}, type( op(o2) ) )) then
              if type(o2)="_not" then
                o2 := op(o2);
                tt2 := "not".type(o2);
              else
                tt2 := type(o2);
              end_if;
              /* case 1: ( A op B ) or ( B op A ) */
              if op(o1,1)=op(o2,2) and op(o1,2)=op(o2,1) then
                case { tt1, tt2 }
                  of { "_leequal", "not_less" } do /* x<=y or not y<x */
                  of { "_less", "not_leequal" } do /* x<y or not y<=x */
                    if type(v)="_not" then
                      operands[j] := v;
                    end_if;
                    v := null();
                    break;
                  of {"_leequal", "not_leequal"} do /* x<=y or nor y<=x */
                    if type(v)="_not" then
                      operands[j] := not op(o1,1)<op(o1,2);
                    else
                      operands[j] := not op(o2,1)<op(o2,2);
                    end_if;
                    v := null();
                    break;
                  of { "_equal", "not_less" } do /* x=y or not y<x */
                  of { "_equal", "not_leequal" } do /* x=y or not y<=x */
                    if type(o1)="_equal" then
                      operands[j] := not op(o2,1)<op(o2,2);
                    else
                      operands[j] := not op(o1,1)<op(o1,2);
                    end_if;
                    v := null();
                    break;
                  of {"_equal", "_less"} do /* x=y or y<x */
                    if type(o1)="_equal" then
                      operands[j] := op(o2,1)<=op(o2,2);
                    else
                      operands[j] := op(o1,1)<=op(o1,2);
                    end_if;
                    v := null();
                    break;
                  of { "_less", "not_less" } do /* x<y or not y<x */
                    if type(v)="_not" then
                      operands[j] := v;
                    end_if;
                    v := null();
                    break;
                  of { "_less" } do /* x<y or y<x */
                    delete operands[j];
                    cond := cond.[ op(o1,1)<>op(o1,2) and op(o1,1) in R_ and op(o1,2) in R_ ];
                    v := null();
                    break;
                  of { "_less", "_unequal" } do /* x<y or y<>x */
                    cond := cond.[op(o1,1)<>op(o1,2)];
                    delete operands[j];
                    v := null();
                    break;
                  of { "_less", "_leequal" } do /* x<y or y<x */
                    cond := cond.[ op(o1,1) in R_ and op(o1,2) in R_ ];
                    delete operands[j];
                    v := null();
                    break;
                  of { "_unequal", "_equal" } do /* x<>y or y=x */
                  of {"not_less", "_unequal"} do /* x<>y or not y<x */
                    return(TRUE);
                  of { "_equal" } do /* x=y or y=x */
                  of {"_unequal" } do /* x<>y or y<>x */
                    v := null();
                    break;
                end_case;
              end_if;
              /* case 2: ( A op B ) or ( A op B ) */
              if op(o1,1)=op(o2,1) and op(o1,2)=op(o2,2) then
                case { tt1, tt2 }
                  of {"_equal", "_less"} do /* x=y or x<y */
                  of {"_leequal", "_less"} do /* x<=y or x<y */
                    cond := cond.[op(o1,1)<=op(o1,2)];
                    delete operands[j];
                    v := null();
                    break;
                  of { "_equal", "not_less" } do /* x=y or not x<y */
                  of { "_equal", "not_leequal" } do /* x=y or not x<=y */
                    cond := cond.[not op(o1,1)<op(o1,2)];
                    delete operands[j];
                    v := null();
                    break;
                  of { "_less", "not_leequal" } do /* x<y or not x<=y */
                  of { "_unequal", "_less" } do /* x<y or x<y */
                    cond := cond.[op(o1,1)<>op(o1,2)];
                    delete operands[j];
                    v := null();
                    break;
                  of {"_leequal", "not_less"} do /* x<=y or not x<y */
                  of {"not_less", "_unequal"} do /* x<>y or not x<y */
                  of { "_unequal", "_equal" } do
                    return(TRUE);
                end_case;
              end_if;
            end_if;
            j := j+1;
          end_while;
        else
          ops := ops union {op(o1)};
        end_if;
        break;
    end_case;

    if i<=nops(vartypes) then vartypes[i] :=implicitAssumptions(v); end_if;
    if v<>null() then
      operands := operands.[v];
    end_if;
    i := i+1;
  end_while;

  cond := _or( op(operands) );

  if type(cond)="_or" then
    return( /*Simplify::consensus_or*/simplify::simplifyLogic(cond) );
  else
    return( cond );
  end_if;
end_proc: /* simplifySyntactically::simplifySyntacically_or */
