// 

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::chainedConditions := proc( cond, options )
    local s, condIndex, xpr, getBounding, v, xconds, zero,
      checkExpr, p, i,
       necessary,
       isReal, typereal,
        decide; /* proc */
  begin
    if length(cond)>200 then return(cond); end_if;

    necessary := options[ "necessary" ];
    decide := options[ "decide" ];
    typereal := options[ "typereal" ];
    isReal := options[ "isReal" ];

    /* getBounding(xpr)
     * returns a list of possible upper/lower boundaries for xpr. the boundaries may exceed the real boundaries, but
     * may not be smaller. this means [getBounding(lower),getBounding(upper)] must be a superset of the real
     * value set.
     * returns a list [{open},{close}] where open may not be reached but close may be reached.
     */
    getBounding := proc( xpr, upper=TRUE, blocked={} )
      local s, s1, v, ret, lhs, rhs, i, cls, all;
      save MAXEFFORT;
    begin
      case type(xpr)
        of "_plus" do
          if type(xpr)<>"_plus" then return( getBounding( xpr, upper, blocked ) ); end_if;
          MAXEFFORT := MAXEFFORT / nops(xpr);
          v := map( [op(xpr)], getBounding, upper, blocked );
          if contains( v, FAIL )>0 then return(FAIL); end_if;
          // Since "all := _plus(op(map(v, X->_union(op(X,1),op(X,2)))));" may
          // return a Dom::ImageSet we add by hand:
          all := {0};
          s := map(v, X->_union(op(X,1),op(X,2)));
          s1 := op(map(v,op,2));
          if _mult(op(map(s, nops)))>MAXEFFORT/50
            or _mult(op(map(s1, nops)))>MAXEFFORT/50 then
            return(FAIL);
          end_if;
          for i in s do
            all := map(i, X->op(map(all, _plus, X)));
          end_for;
          // Since "cls := _plus(op(map(v,op,2)));" may
          // return a Dom::ImageSet we add by hand:
          cls := {0};
          for i in s1 do
            cls := map(i, X->op(map(cls, _plus, X)));
          end_for;
          return([all minus cls, cls]);
        of "_mult" do
          MAXEFFORT := MAXEFFORT / nops(xpr);
          s := split( xpr, X->freeIndets(X)={} );
          if type( s[2] )="_mult" then return([{},{xpr}]); end_if;
          if typereal( s[1] )<>TRUE then return( FAIL ); end_if;
          v := property::constRel( s[1]>0 );
          if v=TRUE then return( map( getBounding(s[2], upper,blocked ), _mult, s[1] ) ); end_if;
          if v=FALSE then return( map( getBounding(s[2], not upper,blocked ), _mult, s[1] ) ); end_if;
          break;
        of "_power" do
          if type(op(xpr,2))=DOM_INT and op(xpr,2)>0 then
            if op(xpr,2) mod 2 = 1 then
              v := getBounding( op(xpr,1), upper, blocked );
              if ( v=FAIL ) then return(FAIL); end_if;
              v := map( v, x->map(x,y->y^op(xpr,2)) );
              v[2] := v[2] union {xpr};
              return( v );
            else
              if upper and decide(op(xpr,1)>=0)=TRUE then
                v := getBounding( op(xpr,1), TRUE, blocked );
                if ( v=FAIL ) then return(FAIL); end_if;
                v := map( v, x->map(x,y->y^op(xpr,2)) );
                v[2] := v[2] union {xpr};
                return( v );
              end_if;
              if upper and decide(op(xpr,1)<=0)=TRUE then
                v := getBounding( op(xpr,1), FALSE, blocked );
                if ( v=FAIL ) then return(FAIL); end_if;
                v := map( v, x->map(x,y->y^op(xpr,2)) );
                v[2] := v[2] union {xpr};
                return( v );
              end_if;
            end_if;
          end_if;
          return( [ {}, { xpr } ] );
          break;
        of DOM_IDENT do
          v := necessary[ xpr ];
          /* check properties */
          if type(v)=Dom::Interval then
            if upper then
              if Dom::Interval::isrightopen(v) then
                ret := [ {Dom::Interval::right(v)}, {} ];
              else
                ret := [ {}, {Dom::Interval::right(v)} ];
              end_if;
            else
              if Dom::Interval::isleftopen(v) then
                ret := [ {Dom::Interval::left(v)}, {} ];
              else
                ret := [ {}, {Dom::Interval::left(v)} ];
              end_if;
            end_if;
          elif type(v)="_intersect" then
            ret := [{},{}];
            s := select( [op(v)], X->type(X)=Dom::Interval );
            if upper then
              for v in s do
                if Dom::Interval::isrightopen(v) then
                  ret := zip( ret, [ {Dom::Interval::right(v)}, {} ], _union );
                else
                  ret := zip( ret, [ {}, {Dom::Interval::right(v)} ], _union );
                end_if;
              end_for;
            else
              for v in s do
                if Dom::Interval::isleftopen(v) then
                  ret := zip( ret, [ {Dom::Interval::left(v)}, {} ], _union );
                else
                  ret := zip( ret, [ {}, {Dom::Interval::left(v)} ], _union );
                end_if;
              end_for;
            end_if;
          else
            ret := [{},{}];
          end_if;

          /* check other conditions */
          for i from 1 to nops(xconds) do
            if i<>condIndex and not contains( blocked,i ) and (v := xconds[i])<>TRUE then
              case type(v)
                of "_in" do
                  if type(op(v,2))<>Dom::Interval then break; end_if;
                  if upper then
                    if Dom::Interval::isrightopen(op(v,2)) then
                      v := op(v,1) < Dom::Interval::right(op(v,2));
                    else
                      v := op(v,1) <= Dom::Interval::right(op(v,2));
                    end_if;
                  else
                    if Dom::Interval::isleftopen(op(v,2)) then
                      v := op(v,1) > Dom::Interval::left(op(v,2));
                    else
                      v := op(v,1) >= Dom::Interval::left(op(v,2));
                    end_if;
                  end_if;
                /* Eine Gleichung vom Typ a<b
                 * HINWEIS: hiervor keine case-Eintrge! (achte fehlendes break)
                 */
                of "_less" do
                of "_leequal" do
                  [ lhs, rhs ] := [op(v)];
                  if upper then
                    if ( s := Type::Linear( lhs, [xpr] ) )<>FALSE and decide(s[1]>0)=TRUE and isReal(s[2]) then
                      rhs := ( rhs - s[2] )/s[1];
                      if ( s := getBounding( rhs, upper, blocked union {i} ) )<>FAIL then
                        if type(v)="_less" then
                          ret[1] := ret[1] union s[1] union s[2];
                        else
                          ret := zip( ret , s, _union );
                        end_if;
                      else
                        next;
                      end_if;
                    else
                      next;
                    end_if;
                    lhs := _if (type(v)="_less", [ {rhs}, {} ], [ {}, {rhs} ] );
                  else
                    if rhs<>xpr then
                      if ( s := Type::Linear( rhs, [xpr] ) )<>FALSE and decide(s[1]>0)=TRUE and isReal(s[2]) then
                        lhs := ( lhs - s[2] )/s[1];
                        if ( s := getBounding( lhs, upper, blocked union {i} ) )<>FAIL then
                          if type(v)="_less" then
                            ret[1] := ret[1] union s[1] union s[2];
                          else
                            ret := zip( ret , s, _union );
                          end_if;
                        else
                          next;
                        end_if;
                      else
                        next;
                      end_if;
                    end_if;
                    lhs := _if (type(v)="_less", [ {lhs}, {} ], [ {}, {lhs} ] );
                  end_if;
                  ret := zip( ret , lhs, _union );
                  break;
                /* Eine weitere Gleichung vom typ a=b wurde gefunden.
                 * Betrachte a-b=0 und untersuche, ob fr die Variable xpr eine
                 * obere/untere Grenze gefunden kann.
                 */
                of "_equal" do
                  lhs := op(v,1)-op(v,2);
                  if ( s := Type::Linear( lhs, [xpr] ) )<>FALSE and decide(s[1]<>0)=TRUE then
                    rhs := - s[2]/s[1];
                    if ( s := getBounding( rhs, upper, blocked union {i} ) )<>FAIL then
                      if type(v)="_less" then
                        ret[1] := ret[1] union s[1] union s[2];
                      else
                        ret := zip( ret , s, _union );
                      end_if;
                    end_if;
                  end_if;
                  break;
              end_case;
            end_if;
          end_for;
          ret := zip( ret, [ {},{xpr} ], _union );
          return( ret );
        of DOM_RAT do
        of DOM_COMPLEX do
        of DOM_FLOAT do
        of DOM_INT do
          return( [{}, {xpr}] );
      end_case;
      FAIL;
    end_proc:

    checkExpr := proc( xpr )
      local v, dxpr, lhs, a, lb, rb, lc, rc, has0;
    begin
      case type(xpr)
        of "_not" do
          v := checkExpr( op(xpr) );
          return( not(v) );
        of "_in" do
          if type(op(xpr,2))<>Dom::Interval then break; end_if;
          lhs := op(xpr,1);
          a := op(xpr,[2,2]);
          if type(a)=DOM_LIST then
            rc := lhs<=op(a);
          else
            rc := lhs<a;
          end_if;
          v := checkExpr( rc );

          if v=FALSE then return(FALSE); end_if;
          rb := bool(v=TRUE);

          a := op(xpr,[2,1]);
          if type(a)=DOM_LIST then
            lc := lhs>=op(a);
          else
            lc := lhs>a;
          end_if;
          v := checkExpr( lc );
          if v=FALSE then return(FALSE); end_if;
          lb := bool(v=TRUE);

          if lb and rb then
            return(TRUE);
          elif lb then
            return( rc );
          elif rb then
            return( lc );
          end_if;
          break;
        of "_less" do
        of "_leequal" do
          dxpr := op(xpr,1)-op(xpr,2);
          if traperror( ( p:=poly(dxpr,[op(freeIndets(dxpr))]) ), MaxSteps=2 )=0 and p<>FAIL then dxpr := expr(p); end_if;
          has0 := FALSE;
          /* if lhs -rhs<0 is FALSE then lhs<rhs is FALSE */
          v := getBounding(dxpr,FALSE);
          if v<>FAIL then
            v := map(v, select, X->nops(indets(X) minus Type::ConstantIdents)<=1);
            if type(xpr)="_leequal" then
              if contains( op(v,2), 0 ) then has0 := TRUE; end_if;
              v := map( op(v,1), X->decide( X>=0 ) ) union map( op(v,2), X->decide( X>0 ) );
            else
              v := map( op(v,1), X->decide( X>=0 ) ) union map( op(v,2), X->decide( X>=0 ) );
            end_if;
            if contains( v, TRUE ) then return(FALSE); end_if;
          end_if;

          v := getBounding(dxpr);
          if v<>FAIL then
            v := map(v, select, X->nops(indets(X) minus Type::ConstantIdents)<=1);
            if type(xpr)="_leequal" then
              v := map( op(v,1), X->decide( X<=0 ) ) union map( op(v,2), X->decide( X<=0 ) );
            else
              v := map( op(v,1), X->decide( X<=0 ) ) union map( op(v,2), X->decide( X<0 ) );
            end_if;
            if contains( v, TRUE ) then
              return(TRUE);
            end_if;
            if has0 then
              xpr := simplifySyntactically( op(xpr,1)=op(xpr,2), options );
            end_if;
          end_if;
          break;
        of "_equal" do
        of "_unequal" do
          if not isReal(op(xpr,1)) or not isReal(op(xpr,2)) then break; end_if;
          dxpr := op(xpr,1)-op(xpr,2);
          v := getBounding(dxpr);
          if v<>FAIL then
            v := map(v, select, X->nops(indets(X) minus Type::ConstantIdents)<=1);
            a := map( op(v,1), X->decide( X<=0 ) ) union map( op(v,2), X->decide( X<0 ) );
            if contains( a, TRUE ) then return( bool(type(xpr)="_unequal") );  end_if;
            zero := _or( op(map( [op(op(v,2))], X->decide(X<=0) )) );
          else
            zero := FALSE;
          end_if;

          v := getBounding(dxpr,FALSE);
          if v<>FAIL then
            v := map(v, select, X->nops(indets(X) minus Type::ConstantIdents)<=1);
            a := map( op(v,1), X->decide( X>=0 ) ) union map( op(v,2), X->decide( X>0 ) );
            if contains( a, TRUE ) then return( bool(type(xpr)="_unequal") );  end_if;
            if ( zero and _or( op(map( [op(op(v,2))], X->decide(X>=0) )) ) )=TRUE then return(bool(type(xpr)<>"_unequal")); end_if;
          end_if;
          break;
      end_case;
      xpr
    end_proc:

     if type( cond )="_and" then
      /* select all conditions with at least two identifiers */
      s := split( [ op(cond) ], X->( nops( freeIndets(X) )>=1 and contains( {"_equal", "_unequal", "_not", "_less", "_leequal", "_in"}, type(X) ) ) );
      if s[1]=[] then return( cond ); end_if;
    elif contains(  { "_equal", "_unequal", "_less", "_leequal", "_in", "_not" }, type( cond ) ) then
      if nops( freeIndets(cond) )>=1 then
        s := [ [cond], [], [] ];
      else
        return( cond );
      end_if;
    else
      return( cond );
    end_if;

    cond := s[1];
    v := property::showprops( cond );
    i := 0;
    while i<nops(v) do
      i := i+1;
      if not contains( {"_less","_leequal", "_equal", "_unequal"}, type(op(v,i)) ) then next; end_if;
      if contains( {"_less","_leequal", "_equal", "_unequal"}, type(op(v,[i,1])) ) then
        v := v.[op(v,[i,1]), subsop(op(v,[i]),1=op(v,[i, 1,2]))];
        v[i] := TRUE;
      end_if;
      if contains( {"_less","_leequal", "_equal", "_unequal"}, type(op(v,[i,2])) ) then
        v := v.[op(v,[i,2]), subsop(op(v,[i]),2=op(v,[i, 2,1])) ];
        v[i] := TRUE;
      end_if;
    end_while;
    xconds := cond.v;
    for condIndex from 1 to nops(cond) do
      xpr := cond[condIndex];
      v := checkExpr( xpr );
      if v=FALSE then return(FALSE); end_if;
      cond[condIndex] := v;
      xconds[condIndex] := v;
    end_for;

    return( _and( op(cond), op(s[2]) ) );
  end_proc: /* simplifyChainedConditions */
