// 

  /* simplifyCondition::_simplifyExpr( cond )
   * This is the second used heuristic. It uses interval arithmetics to decide/simplify expressions.
   */

alias( _simplifyExpr = simplify::simplifyCondition::simplifyExpr ):
alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition::simplifyExpr := proc( cond, options, constraints = null(), implicants = table() )
    local i, j, k, v,
      simplify_and, /* proc */
      simplify_or, /* proc */
      iv, bs,
      checkCondition, /* proc */
      removeSet, /* proc */
      inds, /* set of all indets */
      condIndex, /* the index of the condition we are working on */
      condlist, /* list of all indices to be checked */
    /* contraints: table with
      Expression =[ interval/ set, type, mult,
        4={expressions that were used to create this constraint},
        5={expressions that were build depending on this constraint. these have to be removed if this constraint changes},
        6={indices of condition where this constraint was used. these have to be reevaluated if this constraint changes},
        7={indices of conditions which bound this constraint. these can be removed if we have a real subset},
        8 = [ left bound, right bound, basicset ] ]
      */
      /* implicants: table with
       Expression = [ interval/ set, type, mult,
       ]
       */
       necessary, maxRprop,
       isReal, typereal,
        decide; /* proc */

  begin
    /* maxRprop contains a table of cached getprop-calls. Will be used to intersect later. */
    maxRprop := table();
    necessary := options[ "necessary" ];
    decide := options[ "decide" ];
    typereal := options[ "typereal" ];
    isReal := options[ "isReal" ];

      checkCondition := proc( xpr, isAnd )
        local i1, i2, j, v, s, ls, rs, bs, cI,
          intersectCS, createCS, _mapIV, mapIV, /* proc */
          sidea, sideb,
          updateCond, /* proc */
          intersectSet, /* proc */
          checkImplicants: DOM_PROC,
          updateImplicant: DOM_PROC,
          updateConstraint, /* proc */
          condDep, /* [ bool, bool, bool ] */
          constDep, /* constraints that were used to create the current constraint */
          isNiceSet;
      begin
        isNiceSet := proc(set)
          local v;
        begin
          case type(set)
            of Dom::Interval do
            of solvelib::BasicSet do
            of DOM_SET do
              return(TRUE);
            of "_intersect" do
            of "_union" do
            of "_minus" do
              return(_and(op(map([op(set)], isNiceSet))));
            of Dom::ImageSet do
              v := Dom::ImageSet::variables(set);
              if nops(v)>1 then break; end_if;
              v := Type::Linear(Dom::ImageSet::expr(set), v);
              if v<>FALSE and v<>FAIL then
                return(isNiceSet(op(Dom::ImageSet::sets(set))));
              end_if;
              break;
          end_case;
          return(FALSE);
        end_proc:

        /* mapIV( xpr, constr )
         * Maps the constraints/implicants through the term xpr.
         * constr=FALSE means the implicants are mapped
         */
        mapIV := proc(xpr, constr=TRUE)
          local s, v;
        begin
          /* TODO: check what is achieved by this. remove if possible. */
          if MAXEFFORT>5000.0 then
            /* if xpr is Re or Im don't call normalGroebner directly on it, since normalGroebner evaluates the result */
            if contains(["Re", "Im"], type(xpr))>0 then
              xpr := subsop(xpr, 1=property::normalGroebner(op(xpr)));
            else
              xpr := property::normalGroebner(xpr);
            end_if;
          end_if;
          /* TODO: tcov=0, check why. */
          if contains( map( freeIndets( xpr ), X->constraints[X][2]=C_ ), TRUE ) then return(FAIL); end_if;
          constDep := {};
          s := _mapIV( xpr, constr );
          constDep := constDep minus {xpr};
          if constr then
            map( constDep, proc(X)
              begin
                constraints[X] := subsop( constraints[X], 5=constraints[X][5] union {xpr}, 6=constraints[X][6] union {condIndex} );
              end_proc );
          else /* not constr */
            map( constDep, proc(X)
              begin
                implicants[X] := subsop(implicants[X], 5=implicants[X][5] union {xpr}, 6=implicants[X][6]);
              end_proc );
          end_if;
          if ( constr and MAXEFFORT>500 ) then
            v := property::_getprop(xpr, "Constant"=TRUE);
            assert(freeIndets(v)={});
            if type(v)=Dom::Interval or v=R_ then
              if s=FAIL then s:=[v,R_]; else s[1]:=s[1] intersect v; end_if;
            elif s=FAIL and isNiceSet(v) then
              maxRprop[xpr] := v;
            end_if;
          end_if;
          if has(s, FAIL) then return(FAIL) end_if;
          [ s[1], s[2], 1, constDep, {}, {}, {}, [FALSE,FALSE,FALSE] ];
        end_proc:  /* _simplifyExpr::checkCondition::mapIV */

        /* _mapIV( xpr, constr )
         * recursive part of mapIV
         */
        _mapIV := proc( xpr, constr )
          local s, v, i;
        begin
          if constr and contains( constraints, xpr ) then
            if constraints[xpr][7]={condIndex} then return(FAIL); end_if;
            s := constraints[xpr];
            constraints[xpr] := subsop( constraints[xpr], 6=constraints[xpr][6] union {condIndex} );
            constDep := constDep union {xpr} union s[4];
            if s[1]=C_ then return(FAIL); end_if;
            return( [ s[1], s[2] ] );
          elif not constr and contains( implicants, xpr ) and implicants[xpr][7]<>{condIndex} then
            s := implicants[xpr];
            implicants[xpr] := subsop( implicants[xpr], 6=implicants[xpr][6] union {condIndex} );
            constDep := constDep union {xpr} union s[4];
            if s[1]={} then return(FAIL); end_if;
            return( [ s[1], s[2] ] );
          end_if;

          case type(xpr)
            /* DOM_LIST Sonderfall, um map( [op(xpr)], _mapIV, constr ) zu optimieren */
            of DOM_LIST do
              s := [];
              for i in xpr do
                v := _mapIV( i, constr );
                if v=FAIL then return(FAIL); end_if;
                s := append( s, v );
              end_for;
              return( s );
              break;
            of "sign" do
              if ( v := _mapIV( op(xpr), constr ) ) <> FAIL then
                return( [ sign( v[1] ), Z_ ] );
              end_if;
              break;
            of "ln" do
              if ( v := _mapIV( op(xpr), constr ) ) <> FAIL then
                if type(v[1])=Dom::Interval and decide( Dom::Interval::leftB(v[1]) > 0 )=TRUE then
                  return( [ ln(v[1]), R_ ] );
                end_if;
              end_if;
              break;
            of "exp" do
              v := _mapIV(op(xpr), constr);
              if v=FAIL then return(FAIL); end_if;
              v :=exp(v[1]);
              if not contains( {Dom::Interval,DOM_SET},type(v) ) and v<>R_ then return(FAIL); end_if;
              return( [v,R_] );
            of "Re" do
              if not constr then
                v := _mapIV(op(xpr), constr);
                return(v);
              end_if;
              v := _mapIV(op(xpr), constr);
              if v=FAIL then return(FAIL); end_if;
              v := Re(v[1]);
              if not contains( {Dom::Interval,DOM_SET},type(v) ) and v<>R_ then return(FAIL); end_if;
              return( [v,R_] );
            of DOM_IDENT do
              if contains(Type::ConstantIdents, xpr) then
                return([{xpr}, {xpr}]);
              end_if;
              break;
            of DOM_INT do
              return( [{xpr}, {xpr}] );
            of DOM_RAT do
              return( [{xpr}, {xpr}] ); // {xpr}
            of "_mult" do:
              /* We map all factors, since even if one cannot be decide the result would be {0} if
               * any factor is {0} */
              s := map([op(xpr)], _mapIV, constr);
              if contains(map(s, op, 1), {0})>0 then return([{0}, Z_]); end_if;
              if contains(s, FAIL)>0 then return(FAIL); end_if;
              return( [ _mult( op(map( s, op, 1 )) ), _mult( op(map( s, op, 2 )) ) ] );
            of "_plus" do:
              s := [];
              for i in [op(xpr)] do
                v := _mapIV(i, constr);
                if v= FAIL then return(FAIL); end_if;
                s := s.[v];
              end_for;
              v := _plus( op(map( s, op, 2 )) );
              s := _plus( op(map( s, op, 1 )) );
              return( [ s,v ] );
            of "_power" do
              if type( op(xpr,2) )=DOM_INT then
                s := _mapIV( op(xpr,1), constr );
                if s=FAIL then return(FAIL); end_if;
                if not constr and op(xpr,2)<0 and decide(0 in s[1])<>FALSE then
                  return(FAIL);
                end_if;
                v := _power( s[1], op(xpr,2) );
                if not contains( {Dom::Interval,DOM_SET},type(v) ) and v<>R_ then return(FAIL); end_if;
                /* fr m in Z_ ist 1/m in Q_ */
                if s[2]=Z_ and op(xpr,2)<0 then
                  s[2] := Q_;
                elif type(s[2])=DOM_SET then
                  s[2] := map(s[2], _power, op(xpr,2));
                elif type(s[2])<>solvelib::BasicSet then
                  s[2] := R_;
                end_if;
                return( [ v, s[2] ] );
              end_if;
              break;
          end_case;
          return( FAIL );
        end_proc: /* _simplifyExpr::checkCondition::_mapIV */

        createCS := proc( open, dir, border, xpr )
          local b, v;
        begin
          if open="_equal" then
            if contains(maxRprop, xpr) then
              /* TODO: Check if decide(border in maxRprop[xpr])=FALSE is more performant */
              v := {border} intersect maxRprop[xpr];
              if v={} then
                return( [ {}, R_, 1, constDep, {}, {}, {condIndex}, [FALSE,FALSE,FALSE] ] );
              end_if;
              /* TODO: Check if border in R_ is still necessary */
            end_if;
            if decide( border in R_ )=TRUE then
              return( [ {border}, R_, 1, constDep, {}, {}, {condIndex}, [FALSE,FALSE,FALSE] ] );
            else
              return( [ {border}, C_, 1, constDep, {}, {}, {condIndex}, [FALSE,FALSE,FALSE] ] );
            end_if;
          end_if;
          if dir=1 then
            b := [ Dom::Interval( -infinity, _if( open="_less", border, [border] ) ), R_, 1, constDep, {}, {}, {condIndex}, [FALSE,TRUE,FALSE] ];
          else
            b := [ Dom::Interval( _if( open="_less", border, [border] ), infinity ), R_, 1, constDep, {}, {}, {condIndex}, [TRUE,FALSE,FALSE] ];
          end_if;
          if contains(maxRprop, xpr) then
            v := b[1] intersect maxRprop[xpr];
            if type(v)=DOM_SET or type(v)=Dom::Interval or v=R_ then
              b[1] := v;
            end_if;
          end_if;
          b;
        end;  /* _simplifyExpr::checkCondition::createCS */

        intersectCS := proc( CS, typ, dir, border, xpr )
          local v, s;
        begin
          v := createCS(typ, dir, border, xpr);
          condDep := op(v,8);
          return( intersectSet( CS, op(v,1), xpr ) );
        end_proc;  /* _simplifyExpr::checkCondition::intersectCS */

        intersectSet := proc( CS, set, xpr )
          local v, s, iv, bs, cI;
        begin
          if _subset( CS[2], set )=TRUE or _subset( CS[1], set )=TRUE or _subset( CS[2] intersect CS[1], set )=TRUE then
            return( TRUE );
          end_if;
          cI := {condIndex};
          v := solvelib::solve_intersect( CS[1], CS[2], set );
          if type(v)="_intersect" then
            s := split( v, X->type(X)<>solvelib::BasicSet );
            if type(s[1])="_intersect" then
              iv := CS[1]; bs := R_;
              cI := {};
            else
              iv := s[1]; bs := s[2];
            end_if;
          else
            /* TODO: USe case instead */
            if type( v )=solvelib::BasicSet then
              iv := R_;
              bs := v;
            elif type(v)=DOM_SET then
              if v={} then return(FALSE); end_if;
              iv := v;
              bs := R_;
            else
              iv := v;
              bs := R_;
            end_if;
          end_if;
          case type(iv)
            of DOM_SET do
              if nops(iv)=1 // and typ<>"_equal" // global ident !!!
                then
                cond[condIndex] := simplifySyntactically(xpr=op(iv), options);
              end_if;
              break;
            of Dom::Interval do
              break;
            of solvelib::BasicSet do
              if iv=R_ then break; end_if;
              /* fallthrough! */
            otherwise
              /* If the intersection can not be used and is ignored, do not mark this condition as a bound */
              cI := {};
              iv := CS[1];
              break;
          end_case;
          return( [ iv, bs, 1, CS[4], CS[5], CS[6], cI, zip(CS[8],condDep,_or) ] );
        end_proc;  /* _simplifyExpr::checkCondition::intersectSet */

        /* updateCond( expr, set )
         * 1. updates the constraints/implicants-table
         * 2. update the list of conditions by removing all appearence of expr
         * and adding "expr in set".
         */
        updateCond := proc( expr, v )
          local c;
        begin
          /* TODO: tcov=0, check. */
          if not contains( {Dom::Interval, DOM_SET}, type(v[1]) ) and v[1]<>R_ then return(); end_if;
          if isAnd  then
            updateConstraint( expr, v );
            v := constraints[expr];
            /* If v[7] does not contain the current index, then nothing has been done and we do not need
             * to rewrite the conditions. */
            if v[2]<>C_ and contains(v[7], condIndex) then
              map(constraints[expr][7], X->( cond[X]:=TRUE ) );
              constraints[expr][7] := {condIndex};
              case type(v[1])
                of DOM_SET do
                  if nops(v[1])=1 then
                    cond[condIndex] := expr = op(v[1]);
                  else
                    cond[condIndex] := expr in v[1];
                  end_if;
                  break;
                of Dom::Interval do
                  if v[8][3] then
                    if v[8][1] or v[8][2] then
                      cond[condIndex] := expr in v[1] intersect v[2];
                    else
                      cond[condIndex] := expr in v[2];
                    end_if;
                  else
                    if v[8][1] and v[8][2] then
                        cond[condIndex] := expr in v[1];
                    elif v[8][1] then
                      if v[1]=R_ then
                        c := -infinity;
                      else
                        c := Dom::Interval::leftB( v[1] );
                      end_if;
                      cond[condIndex] := simplifySyntactically( _if( type(c)=DOM_LIST, expr >= op(c), expr > c ), options );
                    elif v[8][2] then
                      if v[1]=R_ then
                        c := infinity;
                      else
                        c := Dom::Interval::rightB( v[1] );
                      end_if;
                      cond[condIndex] := simplifySyntactically( _if( type(c)=DOM_LIST, expr <= op(c), expr < c ), options );
                    end_if;
                  end_if;
                  break;
                otherwise
                  if v[8][3] then
                    cond[condIndex] := expr in v[1] intersect v[2];
                  else
                    cond[condIndex] := expr in v[1];
                  end_if;
              end_case;
            end_if;
          else
            updateImplicant( expr, v );
            /* TODO: This is always TRUE. check. */
            if implicants[expr][2]<>{} then
              v := implicants[ expr ];
              map( {condIndex} union implicants[expr][7], X->( cond[X]:=FALSE ) );
              implicants[expr][7] := {condIndex};
              case type(v[1])
                of DOM_SET do
                  if nops(v[1])=1 then
                    cond[condIndex] := expr = op(v[1]);
                  else
                    cond[condIndex] := expr in v[1];
                  end_if;
                  break;
                of Dom::Interval do
                  if v[8][3] then
                    if v[8][1] or v[8][2] then
                      cond[condIndex] := expr in v[1] intersect v[2];
                    else
                      cond[condIndex] := expr in v[2];
                    end_if;
                  else
                    if v[8][1] and v[8][2] then
                        if Dom::Interval::leftB(v[1])=-infinity and Dom::Interval::rightB(v[1])=infinity then
                          cond[condIndex] := expr in R_;
                      else
                          cond[condIndex] := expr in v[1];
                        end_if;
                    elif v[8][1] then
                      if v[1]=R_ then
                        c := -infinity;
                      else
                        c := Dom::Interval::leftB( v[1] );
                      end_if;
                      cond[condIndex] := simplifySyntactically( _if( type(c)=DOM_LIST, expr >= op(c), expr > c ), options );
                    elif v[8][2] then
                      if v[1]=R_ then
                        c := infinity;
                      else
                        c := Dom::Interval::rightB( v[1] );
                      end_if;
                      cond[condIndex] := simplifySyntactically( _if( type(c)=DOM_LIST, expr <= op(c), expr < c ), options );
                    end_if;
                  end_if;
                  break;
                otherwise
                  if v[8][3] then
                    cond[condIndex] := expr in v[1] intersect v[2];
                  else
                    cond[condIndex] := expr in v[1];
                  end_if;
              end_case;
            end_if;
          end_if;
        end_proc; /* _simplifyExpr::checkCondition::updateCond */

        /* updateConstraint( expr, constr )
         * sets the constraint "expr" to "constr"
         * Also checks which conditions have to be reevaluated and removes all depending constraints
         */
        updateConstraint := proc( expr, constr )
          local s, i, ls, rs;
        begin
          /* we only handle intervals */
          /* TODO: tcov=0, check. */
          if not contains( {Dom::Interval, DOM_SET}, type(constr[1]) ) and constr[1]<>R_ then return(); end_if;

          /* check if we already have an entry */
          if contains( constraints, expr ) then
            /* reevaluate all expressions depending on this constraint */
            if MAXEFFORT>1000 then
              condlist := condlist.[ op(constraints[ expr ][6] minus {op(condlist)} minus {condIndex}) ];
            end_if;
            /* remove all constraints depending on this constraint */
            s := constraints[ expr ][5];
            while nops(s)>0 do
              i := op(s,1);
              if contains( constraints, i ) then
                s := s union constraints[i][5];
                delete constraints[i];
              end_if;
              s := s minus {i};
            end_while;
            /* update all dependings */
            constr[ 7 ] := constr[7] union constraints[expr][7];
            constr[ 8 ] := zip(constr[8],constraints[expr][8],_or);
          end_if;

          /* update the table */
          constraints[ expr ] := constr;
        end_proc:

        checkImplicants := proc( sidea, v )
          local w, s;
        begin
          if not isAnd and ( w := mapIV( sidea,FALSE ) )<>FAIL then
            if _subset( w[1] intersect w[2], v[1] intersect v[2] )=TRUE then
              map( select( constDep, X->contains(implicants,X) ), X->
                map( implicants[X][7], X->( cond[X]:=FALSE ) )
               );
            end_if;
          end_if;
          if contains(implicants, sidea) then
            w := [implicants[sidea][1], implicants[sidea][2]];
/*
            if _subset(v[1] intersect v[2], w[1] intersect w[2])=TRUE and not contains(implicants[sidea][7], condIndex) then
              cond[condIndex] := FALSE;
              return(FALSE);
            end_if;
*/
            s := ( v[1] intersect v[2] ) union (w[1] intersect w[2] );
            /* Since DOM_SETs are treated specially we make sure either the parameter was no DOM_SET or
             * remains a DOM_SET. */
            if type(v[1])=DOM_SET and type(s)<>DOM_SET then
              /* If we don't use this data, remove dependencies to avoid inconsistency. */
              v[7] := v[7] intersect {condIndex};
              if contains(implicants, sidea) then
                implicants[ sidea ][ 7 ] := {};
              end_if;
              return(v);
            end_if;
            if type( s ) <> "_union" then
              case type( s )
                 of "_intersect" do
                  s := split( s, X->type(X)<>solvelib::BasicSet );
                  if type(s[1])<>Dom::Interval or type(s[2])<>solvelib::BasicSet then
                    if contains(implicants,sidea) then
                      implicants[sidea][7] := {};
                    end_if;
                    return(v);
                  end_if;
                  v[1] := s[1];
                  v[2] := s[2];
                  break;
                of solvelib::BasicSet do
                  v[1] := R_;
                  v[2] := s;
                  break;
                of DOM_SET do
                  v[1] := s;
                  if contains(map(s, isReal), FALSE) then
                    v[2] := C_;
                  else
                    v[2] := R_;
                  end_if;
                  break;
                of Dom::Interval do
                  v[1] := s;
                  v[2] := R_;
                  break;
              end_case;
            else
              v[7] := v[7] intersect {condIndex};
              if contains(implicants, sidea) then
                implicants[ sidea ][ 7 ] := {};
              end_if;
              return( v );
            end_if;
          end_if;
          v;
        end_proc;

        updateImplicant := proc( expr, implicant )
          local s, i;
        begin
          /* we only handle intervals */
          /* TODO: tcov=0, check. */
          if not contains( {Dom::Interval, DOM_SET}, type(implicant[1]) ) and implicant[1]<>R_ then return(); end_if;

          /* check if we already have an entry */
          if contains( implicants, expr ) then
//             /* reevaluate all expressions depending on this constraint */
//             condlist := condlist.[ op(implicants[ expr ][6] minus {condIndex}) ];
            /* remove all constraints depending on this constraint */
            s := implicants[ expr ][5];
            /* TODO: tcov=0, check. */
            while nops(s)>0 do
              i := op(s,1);
              if contains( implicants, i ) then
                s := s union implicants[i][5];
                delete implicants[i];
              end_if;
              s := s minus {i};
            end_while;
            /* update all dependings */
            implicant[ 7 ] := implicant[7] union implicants[expr][7];
            implicant[ 8 ] := zip(implicant[8],implicants[expr][8],_or);
          end_if;

          /* update the table */
          if not contains( implicants, expr ) or implicants[expr][1..2] <> implicant[1..2] then
            /* check if we already have an entry */
//            if contains( constraints, expr ) then
//              /* reevaluate all expressions depending on this constraint */
//              if MAXEFFORT>1000 then
//                condlist := condlist.[ op(constraints[ expr ][6] minus {op(condlist)} minus {condIndex}) ];
//              end_if;
//            end_if;

            /* check if we already have an entry */
            if contains( implicants, expr ) then
              /* reevaluate all expressions depending on this constraint */
              condlist := condlist.[ op(implicants[ expr ][6] minus {op(condlist)} minus {condIndex}) ];
              /* remove all constraints depending on this constraint */
            end_if;
          end_if;
          /* Initial mappign was using constraints, so don't mark any dependencies here. */
          implicant[4] := {};
          implicants[ expr ] := implicant;
        end_proc:

        condDep := [ FALSE, FALSE, FALSE ];

        case type(xpr)
          of "_or" do
            v := _simplifyExpr( xpr, options, constraints, implicants );
            cond[condIndex] := v;
            if type(v)=DOM_BOOL then return(v); end_if;
            if type(v)<>"_or" then condlist := condlist.[condIndex]; end_if;
            break;

          of "_and" do
            v := _simplifyExpr( xpr, options, constraints, implicants );
            if type(v)=DOM_BOOL then return(v); end_if;
            cond[condIndex] := v;
            if type(v)<>"_and" then condlist := condlist.[condIndex]; end_if;
            break;

          of "_not" do
            v := _simplifyExpr(op(xpr), options, select(constraints, X->not contains(op(X, [2, 7]), condIndex)));
            if not isAnd and type(v)="_in" and type(op(v,2))=solvelib::BasicSet and op(v,2)<>C_ then
              // the operand is of type "not expr in Z_|Q_|R_" and part of a disjunction
              if contains( constraints, op(v,1) ) then
                [ sidea, sideb ] := [ op(v) ];
                k := mapIV( sidea );
                if k=FAIL then
                  k := [ R_, sideb, 1, constDep, {}, {}, {condIndex}, [FALSE,FALSE,TRUE] ];
                else
                  k := intersectSet( k, sideb, sidea );
                  if type(k)=DOM_BOOL then
                      return(not k);
                  end_if;
                  k[8][3] := TRUE;
                end_if;

                isAnd := TRUE;
                updateConstraint( sidea, k );
                isAnd := FALSE;
                if contains( implicants, sidea ) then
                  implicants[ sidea ][2] := implicants[ sidea ][2] intersect sideb;
                  /* reevaluate all expressions depending on this constraint */
                  if MAXEFFORT>1000 then
                    condlist := condlist.[ op(implicants[ sidea ][6] minus {op(condlist)} minus {condIndex}) ];
                  end_if;
                end_if;
              else
                constraints[ op(v,1) ] := [ R_, op(v,2) , 1, {}, {}, {}, {condIndex}, [FALSE $ 3] ];
              end_if;
            end_if;
            rs := ls := FALSE;
            /* check if we have a relation with real sides */
            if contains( {"_less","_leequal"}, type(v) ) then
              ls := typereal( op(v,1) );
              if ls=UNKNOWN then
                ls := mapIV( op(v,1) );
                if ls=FAIL then
                  ls=UNKNOWN
                else
                  ls := typereal( ls[1] );
                end_if;
              end_if;
              if ls=TRUE then
                rs := typereal( op(v,2) );
                if rs=UNKNOWN then
                  rs := mapIV( op(v,2) );
                  if rs=FAIL then
                    rs=UNKNOWN
                  else
                    rs := typereal( rs[1] );
                  end_if;
                end_if;
              end_if;
              /* if we have a relation and both sides are real, then remove the _not and swap sides */
              if rs=TRUE and ls=TRUE then
                if type(v)="_less" then
                  v := op(v,2)<=op(v,1);
                else
                  v := op(v,2)<op(v,1);
                end_if;
                condlist := condlist.[condIndex];
              else
                v := _not(v);
              end_if;
            else
              v := _not(v);
            end_if;
            cond[condIndex] := v;
            if type(v)=DOM_BOOL then return(v); end_if;
            break;

          of "_in" do
           [ sidea, sideb ] := [ op(xpr) ];
            if op(xpr,2)=R_ then
              if contains(constraints,sidea) then
                v := R_ intersect constraints[ sidea ][1];
                if type(v)="_intersect" then break; end_if;
                constDep := {};
              else
                v := mapIV( sidea );
                /* TODO: is this safe, if v={I} or something? */
                if v<>FAIL then return(TRUE); end_if;
                v := R_;
              end_if;
              v := [ v, R_, 1, constDep, {}, {}, {condIndex}, [FALSE,FALSE,TRUE] ];

              /* Im(sidea) bestimmen */
               s := property::_rectformSymbolic( sidea );
               if s<>FAIL then
                s := mapIV( s[2] );
                if s<>FAIL and decide( 0 in s[1] )=FALSE then return( FALSE ); end_if;
              end_if;

              v := checkImplicants( sidea, v );
              if type(v)=DOM_BOOL then return(v); end_if;

              updateCond( op(xpr,1), v );
            elif type(sideb) = solvelib::BasicSet then /* sideb = Z_ / Q_ */
              if sideb=C_ then /* this should not happen */
                return(TRUE);
              end;
              v := mapIV( sidea );
              if v=FAIL then
                v := [ R_, sideb, 1, constDep, {}, {}, {condIndex}, [FALSE,FALSE,TRUE] ];
              else
                v := intersectSet( v, sideb, sidea );
                if type(v)=DOM_BOOL then return(v); end_if;
                v[8][3] := TRUE;
              end_if;

              v := checkImplicants( sidea, v );
              if type(v)=DOM_BOOL then return(v); end_if;
              updateCond( sidea, v );
            elif type(sideb) = Dom::Interval then
              if indets( sideb ) minus Type::ConstantIdents <> {} then break; end_if;
              /* TODO: if FALSE? check. */
              if FALSE and contains(constraints,sidea) then
                v := op(xpr,2) intersect constraints[ sidea ][1];
                if type(v)="_intersect" then break; end_if;
                constDep := {};
              else
                v := mapIV( sidea );
                condDep := [TRUE,TRUE,FALSE];
                if v<>FAIL then
                  //v := intersectSet( v, sideb );
                  //if type(v)=DOM_BOOL  then return(v); end_if;
                  s := op(v,1);

                  if type(s)=Dom::Interval then
                    /* check if the intersection is empty */
                    if not Dom::Interval::isrightopen(s) and not Dom::Interval::isleftopen(sideb) then
                      ls := decide( Dom::Interval::right(s)<Dom::Interval::left(sideb) );
                    else
                      ls := decide( Dom::Interval::right(s)<=Dom::Interval::left(sideb) );
                    end_if;
                    if ls=TRUE then return(FALSE); end_if;
                    if not Dom::Interval::isrightopen(sideb) and not Dom::Interval::isleftopen(s) then
                      ls := decide( Dom::Interval::right(sideb)<Dom::Interval::left(s) );
                    else
                      ls := decide( Dom::Interval::right(sideb)<=Dom::Interval::left(s) );
                    end_if;
                    if ls=TRUE then return(FALSE); end_if;

                    /* check if the left/right side is redundant */
                    if not Dom::Interval::isleftopen(s) and Dom::Interval::isleftopen(sideb) then
                      ls := decide( Dom::Interval::left(s) > Dom::Interval::left(sideb) );
                    else
                      ls := decide( Dom::Interval::left(s) >= Dom::Interval::left(sideb) );
                    end_if;
                    if not Dom::Interval::isrightopen(s) and Dom::Interval::isrightopen(sideb) then
                      rs := decide( Dom::Interval::right(s) < Dom::Interval::right(sideb) );
                    else
                      rs := decide( Dom::Interval::right(s) <= Dom::Interval::right(sideb) );
                    end_if;

                    if ls=TRUE and rs=TRUE then
                      return(TRUE);
                    elif ls=TRUE then
                      condDep[1] := FALSE;
                      if Dom::Interval::isrightopen(sideb) then
                        cond[condIndex] := simplifySyntactically( sidea < Dom::Interval::right(sideb), options );
                      else
                        cond[condIndex] := simplifySyntactically( sidea <= Dom::Interval::right(sideb), options );
                      end_if;
                    elif rs=TRUE then
                      condDep[2] := FALSE;
                      if Dom::Interval::isleftopen(sideb) then
                        cond[condIndex] := simplifySyntactically( sidea > Dom::Interval::left(sideb), options );
                       else
                        cond[condIndex] := simplifySyntactically( sidea >= Dom::Interval::left(sideb), options );
                      end_if;
                    end_if;
                  end_if;
                  v := intersectSet( v, sideb, sidea );
                  if type(v)=DOM_BOOL  then return(v); end_if;
                  bs := op(v,2);
                  v := op(v,1);
                else
                  bs := R_;
                  v := sideb;
                end_if;
              end_if;
              v := [ v, bs, 1, constDep, {}, {}, {condIndex}, condDep ];

              v := checkImplicants( sidea, v );
              if type(v)=DOM_BOOL then return(v); end_if;

              updateCond( sidea, v );
            elif type(sideb) = DOM_SET then
              v := mapIV( sidea );
              condDep := [TRUE,TRUE,FALSE];
              if v<>FAIL then
                v := intersectSet( v, sideb, sidea );
                if type(v)=DOM_BOOL  then return(v); end_if;
                bs := op(v,2);
                cI := op(v,7);
                v := op(v,1);
              else
                cI := {condIndex};
                bs := R_;
                v := sideb;
              end_if;
              if indets( sideb ) minus Type::ConstantIdents <> {} then break; end_if;
              v := [ v, bs, 1, constDep, {}, {}, cI, condDep ];

              v := checkImplicants( sidea, v );
              if type(v)=DOM_BOOL then return(v); end_if;

              updateCond( sidea, v );
            end_if;
            break;

          of "_unequal" do
            i1 := indets( op(xpr,1) ) minus Type::ConstantIdents;
            i2 := indets( op(xpr,2) ) minus Type::ConstantIdents;
            j := 0;
            if i1<>{} then j:=j+1; end_if;
            if i2<>{} then j:=j+2; end_if;
            if j=1 or j=2 then
              sidea := op(xpr,j);
              sideb:= op(xpr,3-j);
              v := mapIV( sidea );
              if ( v<>FAIL ) then
                v := decide( sideb in v[1] );
                if ( v=FALSE ) then return( TRUE ); end_if;
              end_if;
            end;
            break;
          of "_equal" do
          of "_less" do
          of "_leequal" do
            i1 := indets( op(xpr,1) ) minus Type::ConstantIdents;
            i2 := indets( op(xpr,2) ) minus Type::ConstantIdents;
            j := 0;
            if i1<>{} then j:=j+1; end_if;
            if i2<>{} then j:=j+2; end_if;
            if j=1 or j=2 then
              sidea := op(xpr,j);
              v := mapIV(sidea, TRUE);

              if v<>FAIL then
                v := intersectCS( v, type(xpr), j, op(xpr,3-j), sidea );
              elif type(xpr)<>"_equal" then
                /* if we don't get a result we try to check the condition with Re(sidea). this is a necessary condition so if this is false we can decide this condition to be false itself */
                v := property::_rectformSymbolic( sidea );

                if v<>FAIL then
                  s := mapIV( v[2] );
                  if s<>FAIL and decide( 0 in s[1] )=FALSE then return( FALSE ); end_if;

                  v := v[1];
                  if v<>sidea then
                    v := mapIV( v );
                  else
                    v := FAIL;
                  end_if;

                  if ( v<>FAIL ) then
                    v := intersectCS( v, type(xpr), j, op(xpr,3-j), sidea );
                    if ( v=FALSE ) then return( FALSE ); end_if;
                  end_if;
                end_if;

                constDep := {op(xpr,j)};
                v := createCS(type(xpr), j, op(xpr,3-j), op(xpr, j));
              else
                constDep := {op(xpr,j)};
                v := createCS(type(xpr), j, op(xpr,3-j), op(xpr, j));
              end_if;

              /* v=FALSE means this condition is a contradiction */
              /* v=TRUE means this condition is redundant */
              if type(v)=DOM_BOOL then return(v); end_if;
              v := checkImplicants( sidea, v );
              if type(v)=DOM_BOOL then return(v); end_if;

              updateCond( sidea, v );
            else
              [ sidea, sideb ] := [ op(xpr) ];
              if not contains( constraints,sidea ) then
                constraints[ sidea ] := [ R_, R_ , 1, {} $ 4, [FALSE $ 3] ];
              end_if;
              if not contains( constraints,sideb ) then
                constraints[ sideb ] := [ R_, R_ , 1, {} $ 4, [FALSE $ 3] ];
              end_if;
              if not isReal( sidea ) or not isReal( sideb ) then break; end_if;
              v := mapIV( sidea-sideb );
              if v<>FAIL then
                if type(xpr)="_equal" then
                  s := v[1] intersect {0};
                elif type(xpr)="_leequal" then
                  s := v[1] intersect Dom::Interval( -infinity, [0] );
                else
                  s := v[1] intersect Dom::Interval( -infinity, 0 );
                end_if;
                if s={} then return( FALSE ); end_if;
                if s=v[1] then cond[condIndex]:=TRUE; return( TRUE ); end_if;
                if s={0} then cond[condIndex] := subsop( cond[condIndex], 0=hold(_equal) ); end_if;
              end_if;
            end_if;
            break;
          end_case;
          UNKNOWN;
      end_proc: /* _simplifyExpr::checkCondition */

      simplify_and := proc()
        local v, i, l, r;
        save MAXEFFORT;
      begin
        /* sort set by inclusion of indets */
        cond := sort( [op(cond)], proc(x,y)
            local a,b;
          begin
            a := indets(x); b := indets(y);
            if a<>b then return(a minus b = {}); end_if;
            return(type(y)="_or" or type(y)="_not" or length(x)<length(y));
          end_proc );
        condlist := [ i $ i=1..nops(cond) ];
/* This is for testing to check that one operand does not interfere with itself. */
%if simplify::simplifyCondition::doubleCondlist then
        condlist := condlist.condlist; /* for testing */
end_if;

        MAXEFFORT := MAXEFFORT/nops(condlist);
        while nops(condlist)>0 do
          condIndex := condlist[1]; delete condlist[1];
          v := checkCondition( cond[condIndex], TRUE );
          if v=FALSE then return(FALSE); end_if;
          if v=TRUE then cond[condIndex] := TRUE; end_if;
        end_while;

        /* remove all _intersects */
        cond := split( cond, X->type(X)="_in" and type(op(X,2))="_intersect" );
        for i in cond[1] do
          cond[2] := cond[2].( map( [op(op(i,2))], X-> op(i,1) in X ) );
        end_for;
        /* remove all intervals with one border being infinity */
        cond := split( cond[2], X->type(X)="_in" and type(op(X,2))=Dom::Interval );
        for i in cond[1] do
          l := Dom::Interval::leftB( op(i,2) );
          r := Dom::Interval::rightB( op(i,2) );
          if l=-infinity then
            /* TODO: ]-infinity, infinity[ isn't constructed anymore */
            if r=infinity then
              cond[2] := cond[2].[ op(i,1) in R_ ];
            else
              cond[2] := cond[2].[ _if( type(r)=DOM_LIST, op(i,1) <= op(r), op(i,1) < r ) ];
            end_if;
          else
            if r=infinity then
              cond[2] := cond[2].[ _if( type(l)=DOM_LIST, op(i,1) >= op(l), op(i,1) > l ) ];
            else
              cond[2] := cond[2].[ i ];
            end_if;
          end_if;
        end_for;

        return( _and(op(cond[2])) );
      end_proc: /* _simplifyExpr::simplify_and */

      /* removeSet( xpr )
       * produces better readable expressions of sets
       * e.g.: x in Dom::Interval( -infinity, 0 ) intersect Z_ => x < 0 and x in Z_
       */
      removeSet := proc( xpr )
        local l,r,iv;
      begin
        /* TODO: tcov=0, check */
        if type( xpr )="_in" and type(op(xpr,2))="_intersect" then
          return( _and( map( op(op(xpr,2)), X-> op(xpr,1) in X ) ) );
        elif type(xpr)="_in" and type(op(xpr,2))=Dom::Interval then
          iv := op(xpr,2);
          l := Dom::Interval::leftB( iv );
          r := Dom::Interval::rightB( iv );
          if l=-infinity then
            if r=infinity then
              /* TODO: This case is not created anymore */
              return( op(xpr,1)  in R_ );
            else
              return( _if( type(r)=DOM_LIST, op(xpr,1)  <= op(r), op(xpr,1)  < r ) );
            end_if;
          else
            if r=infinity then
              return( _if( type(l)=DOM_LIST, op(xpr,1)  >= op(l), op(xpr,1)  > l ) );
            else
              return( xpr );
            end_if;
          end_if;
        else
          return( xpr );
        end_if;
      end_proc:

      simplify_or := proc()
        local v, i;
        save MAXEFFORT;
      begin

        cond := sort( [op(cond)], proc(x,y)
            local a,b;
          begin
            a := indets(x); b := indets(y);
            if a<>b then return(a minus b={}); end_if;
            return(type(y)="_and" or length(x)<length(y));
          end_proc );
        condlist := [ i $ i=1..nops(cond) ];
/* This is for testing to check that one operand does not interfere with itself. */
%if simplify::simplifyCondition::doubleCondlist then
        condlist := condlist.condlist; /* for testing */
end_if;

        MAXEFFORT := MAXEFFORT/nops(condlist);
        while nops(condlist)>0 do
          condIndex := condlist[1]; delete condlist[1];
          v := checkCondition( cond[condIndex], FALSE );
          if v=FALSE then cond[condIndex]:=FALSE; end_if;
          if v=TRUE then return(TRUE); end_if;
        end_while;

//        if type(cond)="_or" then cond := _not( _simplifyExpr( _not(cond) ) ); end_if;

        return( _or(op(cond)) );
      end_proc: /* _simplifyExpr::simplify_or */

      inds := freeIndets( cond );
      if constraints=null() then
        constraints := table();
        for i in inds do
          case type( ( v := necessary[i] ) )
            of solvelib::BasicSet do
                if v<>C_ then
                  constraints[ i ] := [ R_, v , 1, {} $ 4, [FALSE $ 3] ];
                else
                  constraints[ i ] := [ C_, C_, 1, {} $ 4, [FALSE $ 3] ];
                end_if;
                break;
            of "_intersect" do
              /* do we have an Interval */
              if ( j:=contains( map( [op(v)], type ), Dom::Interval ) )=0 then
                iv := R_;
              else
                iv := op(v,j);
              end_if;
              /* do we have a solvelib::BasicSet */
              if ( k:=contains( map( [op(v)], type ), solvelib::BasicSet ) )=0 then
                bs := R_;
              else
                bs := op(v,k);
              end_if;
              /* build constraint */
              if j<>0 or k<>0 then
                constraints[ i ] := [ iv, bs , 1, {} $ 4, [FALSE $ 3] ];
              else
                constraints[ i ] := [ C_, C_ , 1, {} $ 4, [FALSE $ 3] ];
              end_if;
              break;
            of DOM_SET do
              if indets(v) minus Type::ConstantIdents <> {} then
                constraints[ i ] := [ C_, C_ , 1, {} $ 4, [FALSE $ 3] ];
                break;
              end_if;
              if v intersect R_ = v then
                constraints[ i ] := [ v, R_ , 1, {} $ 4, [FALSE $ 3] ];
              else
                constraints[ i ] := [ v, C_ , 1, {} $ 4, [FALSE $ 3] ];
              end_if;
              break;
            of Dom::Interval do
              constraints[ i ] := [ v, R_ , 1, {} $ 4, [FALSE $ 3] ];
              break;
            otherwise
              constraints[ i ] := [ C_, C_ , 1, {} $ 4, [FALSE $ 3] ];
          end_case;
          implicants[i] := [ {}, Z_ , 1, {} $ 4, [FALSE $ 3] ];
        end_for;
      else
        for i in constraints do
          constraints[ op(i,1) ] := [ op(op(i,2),1..3), {} $ 4, [FALSE $ 3] ];
        end_for;
        for i in implicants do
          implicants[ op(i,1) ] := [ op(op(i,2),1..3), {} $ 4, [FALSE $ 3] ];
        end_for;
      end_if;
      /* Rewrite all "x in A intersect B" to "x in A and x in B" */
      cond := misc::maprec( cond, {"_in"}=proc(X)
        begin
          if type(op(X,2))="_intersect" then
            _and( op( map( [op(op(X,2))], Y->op(X,1) in Y ) ) );
          else
            X;
          end_if;
        end_proc );
      case type(cond)
        of "_and" do
          cond := simplify_and( cond );
          break;
        of "_or" do
          cond := simplify_or( cond );
          break;
        otherwise
          condIndex := 1; cond := [cond];
          condlist := [1];
          v := checkCondition( cond[1], TRUE );
          if v=TRUE or v=FALSE then return(v); end_if;
          cond := removeSet( op(cond) );
          break;
      end_case;
      return( cond );
  end_proc: /* _simplifyExpr */
