// 

/* simplifyCondition::simplifySyntactically (cond)
 * simplifies on syntactical basis
 * for example: a<=b and b<=a => a=b
 * also uses knowledge of realvars
 */
simplify::simplifyCondition::simplifySyntactically := proc( cond, options )
    local s; /* proc */

begin
  if contains( options["props"], cond )>0 then return( TRUE ); end_if;
  if contains( options["props"], not cond )>0 then return( FALSE ); end_if;

  if ( s := slot( simplify::simplifyCondition::simplifySyntactically, "slot".type(cond) ) )<>FAIL then
    return( s(cond,options) );
  end_if;

  case type(cond)
    of DOM_BOOL do
      return( cond );

    of "_unequal" do /* X<>Y is reduced to not X=Y */
      return( _not( simplify::simplifyCondition::simplifySyntactically::slot_equal( op(cond,1)=op(cond,2), options ) ) );
  end_case;
  cond;
end_proc: /* simplifySyntactically */

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):
alias( path = pathname("STDLIB", "SIMPLIFY","SIMPLIFYCONDITION", "SIMPLIFYSYNTACTICALLY" ) ):

simplifySyntactically := funcenv(simplifySyntactically):
simplifySyntactically::slot_and := loadproc( slot(simplifySyntactically,"slot_and" ), path, "slot_and"):
simplifySyntactically::slot_equal := loadproc( slot(simplifySyntactically,"slot_equal" ), path, "slot_equal"):
simplifySyntactically::slot_in := loadproc( slot(simplifySyntactically,"slot_in" ), path, "slot_in"):
simplifySyntactically::slot_leequal := loadproc( slot(simplifySyntactically,"slot_leequal" ), path, "slot_less"):
simplifySyntactically::slot_less := loadproc( slot(simplifySyntactically,"slot_less" ), path, "slot_less"):
simplifySyntactically::slot_not := loadproc( slot(simplifySyntactically,"slot_not" ), path, "slot_not"):
simplifySyntactically::slot_or := loadproc( slot(simplifySyntactically,"slot_or" ), path, "slot_or"):
simplifySyntactically::slotpiecewise := loadproc( slot(simplifySyntactically,"slotpiecewise" ), path, "slotpiecewise"):
simplifySyntactically::reduceModRPlus := loadproc( slot(simplifySyntactically,"reduceModRPlus" ), path, "reduceModRPlus"):