/* -----
 simplify::bessel{JIYK} -- the function attributes "bessel{JIYK}" for simplify
 It tries expand(rewrite(expr, bessel{JI})).
----- */

/* 
For better maintenance, the code for simplify::besselJ and simplify::besselI
is put into one procedure. However, we need separate simplify attributes to 
make sure that the methods are actually called.
*/

simplify::besselJ := proc(a, opt = simplify::defaultOptions)
local bexpand, hasJ, hasI, hasY, hasK, b, bn, s, combineOptions;
begin
   if args(0) = 1 then 
      opt:= null():
   end_if:

   // if the expression is not a sum or product, we can do nothing at this level
   if type(a) <> "_mult" and type(a) <> "_plus" then
     return(a)
   end_if; 
   
   s:= split([op(a)], has, {hold(besselJ), hold(besselI), hold(besselK), hold(besselY)});
   if nops(s[1]) <= 1 then 
     // the simplification shall be done when simplify descends into that operand, but not here
     return(a)
   end_if;  
  
   if nops(s[2]) >= 1 then 
     // some terms or factors do not contain bessel functions, and should not be subjected to the xpand, normal etc. below
     return(subsop(#dummy(simplify::besselJ(op(a, 0)(op(s[1]))), op(s[2])), 0 = eval(op(a, 0))))
   end_if;  
  
   b:= normal(a, Expand = TRUE);
   if length(b) < length(a) then
     a:= b;
   end_if:



   // We can convert all bessels to besselJ or,
   // alternatively, to besselI. It is important 
   // to expand the result. However, we do not 
   // wish to expand the bessels themselves, so 
   // subs them away before expansion.
   bexpand:= proc(a)
   begin
      subs(expand(subs(a, 
        [hold(besselJ) = `#besselJ`,
         hold(besselI) = `#besselI`,
         hold(besselY) = `#besselY`,
         hold(besselK) = `#besselK`]
      )),
        [`#besselJ` = hold(besselJ),
         `#besselI` = hold(besselI),
         `#besselY` = hold(besselY),
         `#besselK` = hold(besselK)]
      ):
   end_proc:

   hasJ:= hastype(a, "besselJ");
   hasI:= hastype(a, "besselI");
   hasY:= hastype(a, "besselY");
   hasK:= hastype(a, "besselK");
   if hasJ and (hasI or hasY or hasK) then
      b:= expand(rewrite(a, besselJ));  // or use bexpand?
   elif hasI and (hasY or hasK) then
      b:= expand(rewrite(a, besselI));  // or use bexpand?
   elif hasY and hasK then
      b:= expand(rewrite(a, besselJ));  // or use bexpand?
   else
      b:= expand(a);                    // or no expand?
   end_if:
   bn:= normal(b, Expand = TRUE);
   if Simplify::complexity(bn) < Simplify::complexity(b) then 
     b:= bn:
   end_if:
   hasJ:= hastype(b, "besselJ");
   hasI:= hastype(b, "besselI");
   hasY:= hastype(b, "besselY");
   hasK:= hastype(b, "besselK");
   if hasK then b:= collect(b, besselK); end_if;
   if hasY then b:= collect(b, besselY); end_if;
   if hasI then b:= collect(b, besselI); end_if;
   if hasJ then b:= collect(b, besselJ); end_if;
   if a = b then
      return(a);
   end_if;

   // since we have expanded a, we should combine again
   combineOptions:= combine::defaultOptions;
   if type(opt) = DOM_TABLE then
     combineOptions[IgnoreAnalyticConstraints]:= opt[IgnoreAnalyticConstraints]
   end_if;
   b:= combine(b, combineOptions); 
   if a = b then
      return(a)
   end_if;

   // return the rewritten expression, even if it is somewhat
   // more complex than the original stuff. 
   if Simplify::complexity(b) <= 2*Simplify::complexity(a) then
      return(b);
   else
      return(a);
   end_if:
end_proc:

simplify::besselI:= simplify::besselJ:
simplify::besselY:= simplify::besselJ:
simplify::besselK:= simplify::besselJ:
