/*--
 simplify/dirac -- the function attribut "dirac" for simplify

 simplify::dirac simplifies expressions c(x, x0)*dirac(x - x0) 
 to c(x0, x0)*dirac(x - x0). Thus, expressions such as 
 sin(x)*dirac(x) should be simplified to 0. 

 simplify::dirac(f) simplifies *all* dirac calls in f

 simplify::dirac(f, Arg) simplifies the expressions dirac(op(Arg))
 occurring in f. Internally, sort(numeric::indets(A)) is used
 to fix the interpretation of "what is the integration variable
 and what are symbolic parameters?"

 author: W. Oevel
 first implementation: 5.4.08
 first shipped with MuPAD 5.0
----------------------------------*/

simplify::dirac:= proc(f, simplify_options)
local coeffs, reconstruct;
begin
   if args(0) = 1 then 
     simplify_options:= null():
   else
     simplify_options:= args(2..args(0));
   end_if;
   [coeffs, reconstruct]:= stdlib::simplify_dirac(f):
   if hastype(coeffs, "dirac") then
      // danger of infinite recursion
      return(f);
   end_if;
   return(reconstruct(simplify(coeffs, simplify_options)));
end_proc:
