//    

/*--
	_power/simplify -- the function attribut "simplify" for _power
--*/

_power::simplify:=
proc(e, options = simplify::defaultOptions: DOM_TABLE)
  local c,q,l,i,p,t,aa,a,_aa, complexpart, b, br, br1, bas, expo, 
  reduceMod2: DOM_PROC;
begin
 
  if not type(e) = "_power" then
     return(e)
  end_if:

  // local method  reduceMod2(b)
  // replace b by a simpler expression bb such that b-bb is an even integer
  reduceMod2:=
  proc(b)
    local integers, others, dummy, S;
  begin
    case type(b)
      of DOM_INT do
        return(b mod 2)
      of DOM_RAT do
        // symmetric reduction, result is between -1 and 1
        return(frac(1/2 + b/2)*2 - 1)
      of DOM_COMPLEX do
        p:= op(b, 1);
        q:= op(b, 2);
        // reduce p modulo 2
        return(reduceMod2(op(b, 1)) + op(b, 2)*I)
    end_case;

    S:= getprop(b mod 2);
    if type(S) = DOM_SET then
      if nops(S) = 1 then
        return(op(S, 1))
      end_if;
      assert(S = {0, 1});
      if stdlib::hasmsign(b) then
        b:= -b
      end_if;
    end_if;
    
    case type(b)
      of "_plus" do
        b:= map(b, reduceMod2);
        if type(b) <> "_plus" then
          return(reduceMod2(b))
        else
          return(b)
        end_if
      of "_mult" do
        [integers, others, dummy]:= split([op(b)],
                                           x -> is(x in Z_, Goal = TRUE)
                                          );
        if nops(others) = 1 then
          return(reduceMod2(op(others, 1)) * _mult(op(integers)))
        end_if;
        break
    end_case;
  
    b
  end_proc;
  

  // m a i n   p r o g r a m   o f   _ p o w e r :: s i m p l i f y

  
  a:= op(e,1);
  b:= op(e,2);

  /* only simplify if a is arithmetical */
  if not testtype(a, Type::Arithmetical ) then
    return(e)
  end_if;

  // quick exit
  if domtype(b) = stdlib::Infinity then
    return(e)
  end_if;


  if type(b) = "_plus" then

    // in a^(br1+br2+...), we extract all logs br[i] where a^br[i] can be
    // simplified
    br:= [op(b)];
    i:= 1;
    c:= 1;
    // loop invariant: a^b = c*a^(_plus(op(br)))
    while i <= nops(br) do
      if type(br[i]) = "log" then
        p:= a^br[i];
        if type(p) = "_power" then
          p:= _power::simplify(p, options)
        end_if;
        if type(p) = "_power" then
          i:= i+1
        else
          c:= p*c;
          delete br[i]
        end_if
      else
        i:= i+1
      end_if
    end_while;
    if c <> 1 then
      return(c*a^_plus(op(br)))
    elif nops(br) < nops(b) then
      // carry on, with simpler exponent
      b:= _plus(op(br))
    end_if;
  end_if;

  

  case type(a)
    of DOM_INT do
       // special case
      if a = -1 then
        if is(b, Type::Even) = TRUE then
          return(1)
        elif is(b, Type::Odd) = TRUE then
          return(-1)
        end_if;
        b:= reduceMod2(b);
        if type(b) = DOM_RAT and b<0 then
          return(- (-1)^(b+1))
        else
          return((-1)^b)
        end_if
      end_if;

     
      
      q:= numlib::ispower(a);      
      // handle log-cases first
      if type(b) = "log" then
        br:= [b];
        t:= 1
      elif type(b) = "_mult" then
        [br, t, c]:= split([op(b)], testtype, "log");
        t:= _mult(op(t))
      else
        br:= [];
        t:= b
      end_if;
      // now b = t*_mult(op(br))
      if br <> [] then
        // some logarithms have occurred
        if q<>FALSE then
          bas:= op(q, 1);
          expo:= op(q, 2)
        else
          bas:= a;
          expo:= 1
        end_if;
        // now a = bas^expo
        // find logarithms to base bas
        if (i:= contains(map(br, op, 1), bas)) > 0 then
          c:= br[i];
          delete br[i];
          // a^b = (bas^expo)^(c*op(br)*t)
          //     = bas^(c*op(br)*t*expo)
          //     = (bas^c)^(op(br) * t* expo)
          // since c = log(base, ...), bas^c = op(c, 2)
          return(op(c, 2)^ _mult(op(br), t, expo))
        end_if
      end_if;
      
      if q <> FALSE then
        b:= b*op(q, 2);
        a:= op(q, 1);
        if type(b) = DOM_INT then
          return(a^b)
        end_if
      end_if; 
  
      if type(b) = DOM_RAT then
        if a < 0 then
          return( (-1)^b * (-a)^b )
        end_if;
  
        // extract factors of the form n^q
        q:=denom(b);
        p:=numer(b);
        l:=stdlib::ifactor(a, UsePrimeTab);
        // l[1] is known to be 1, since a is positive
        // get all pairs l[2*i],l[2*i+1] according to whether
        // q >= l[2*i+1]
        br:=1;
        // loop invariant is a^(p/q) * br
        for i from 2 to nops(l) step 2 do
          if l[i+1] >= q then
            // if l[i+1]= s*q +t, the power (l[i]^l[i+1])^(p/q)
            // can be simplified
            // to l[i]^(ps) * l[i]^(pt/q)
            // divide a by l[i]^s
            a := a / l[i]^ (q*(l[i+1] div q));
            br:= br* l[i] ^ (p*(l[i+1] div q))
          end_if
        end_for;
        return(a^(p/q)*br)
      end_if;
      break
    of DOM_RAT do 
      [p, q]:= [op(a)];
      // check whether a=p/q is an integer power
      // if yes, we want to apply the identity (u^v)^b = u^(v*b) 
      // this holds, as here u is a positive rational and v is a positive integer
      if (q:= numlib::ispower(q)) <> FALSE then
        if p=1 then
          // with q=u^v, write 1/q as 1/u^v
          a:= op(q, 1);
          b:= -op(q, 2)*b
        elif (p:= numlib::ispower(p)) <> FALSE and
          (c:= igcd(op(p, 2), op(q, 2))) > 1 then
          // both p and q can be written as c-th power 
          p:= op(p, 1)^(op(p, 2)/c);
          q:= op(q, 1)^(op(q, 2)/c);
          a:= p/q;
          b:= c*b
        end_if;
      end_if;
      if type(a) <> DOM_RAT then
        return(a^b)
      else 
         return(op(a, 1)^b / op(a, 2)^b)
      end_if;

    of DOM_COMPLEX do
      if iszero(op(a, 1)) then
        if op(a, 2) > 0 then
          // (r*I)^x = r^x * I^x = r^x * (-1)^(x/2)
          return(op(a, 2)^b * (-1)^(b/2))
        else
          // (-r*I)^x = r^x * (-I)^x = r^x * exp(-x*PI*I/2) = r^x * (-1)^(-x/2)
          return((-op(a, 2))^b * (-1)^(-b/2))
        end_if
      end_if;
      break
    of "exp" do
      // This case must be treated before sign(b)=-1, because 
      // we want to simplify exp(x)^(-y) -> exp(x*(-y))
      // rewrite exp(x)^b = exp(xb) if -PI < Im(x) <= PI or b in Z
      if options[IgnoreAnalyticConstraints]
        or
        is(op(a) in R_, Goal = TRUE)
        or
        (is(-PI < Im(op(a)), Goal = TRUE) and is(Im(op(a)) <= PI, Goal =TRUE))
        or
        is(b in Z_, Goal = TRUE) then
        return(exp(op(a)*b))
      end_if;
      break
    of "_power" do
      if options[IgnoreAnalyticConstraints] /* or (type(op(a, 2)) = DOM_INT and is(op(a, 1)>=0, Goal = TRUE)) */ then
        return(op(a, 1)^(op(a, 2)*b))
      else
        c:= _power::combine(a^b);
        if type(c) <> "_power" then 
          return(c)
        else
          [a, b]:= [op(c)]
        end_if;
      end_if;
      break
    of "surd" do
      if options[IgnoreAnalyticConstraints] then
        return(op(a, 1)^(b/op(a, 2)))
      end_if;
      break
    of "sign" do
      if domtype(b) = DOM_INT and is(op(a, 1) in R_) = TRUE then
	  if b mod 2 = 1 then
		// sign(x)^b = sign(x): if x<>0, then sign(x)^2 = 1; and if x=0, both sides of the equation are zero
		return(a)
        elif b < 0 then // we may assume that the base is nonzero; and (-1)^b = 1^b = 1
		return(1)
	  else
		return(piecewise([op(a, 1) = 0, 0], [op(a, 1) <> 0, 1]))		
        end_if;
      end_if;
      break
  end_case;
      
 

  if domtype(a) <> DOM_INT and domtype(a) <> DOM_RAT and domtype(b) <> DOM_COMPLEX then
    // extract content
    c:= content(a);
    // this should be a rational number or FAIL
    if c=FAIL then
      c:= maprat(a, content)
    end_if;
    if iszero(c) then
      return(0^b)
    end_if;  
    if c <> 1 and c <> -1 and contains({DOM_INT, DOM_RAT}, type(c)) then
      c:= abs(c);
      return(_power::simplify((a/c)^b) * c^b)
    end_if;
  end_if;

 // implement (-a)^n = a^n if n is an even integer
  if is(b, Type::Even) = TRUE then
    t:= stdlib::normalizesign(a)[2]:
    if t <> a and t <> op(e, 1) and e <> t^b then // prevent infinite recursions!
      return(t^b);
    end_if;
    if type(a) = "abs" and is(op(a, 1) in R_, Goal = TRUE) then
      // abs(x)^2 = x^2 for real x
      return(op(a, 1)^b)
    end_if;
  end_if;

 
 // beginning of extension from Francois Maltey 
  if (br:=stdlib::radsimp_matchsqrt (e))<> FAIL
    and (br1 := stdlib::radsimp_match2sqrt (br)) <> FAIL
    // returns a b r
    and is(br1[1] > 0) = TRUE
    and is(br1[2] > 0) = TRUE
    and is((br := br1[1]^2 - br1[2]^2 * br1[3]) >= 0) = TRUE
    // Delta here a^2 - b^2 r
    and ((type ((br := sqrt (br))) = DOM_INT) or (type (br) = DOM_RAT))
    then
    return (sqrt ((br1[1] + br) / 2) + sqrt ((br1[1] - br) / 2)) ;
    // end of 1st case : sqrt x + sqrt y
    // beginning of 2nd case : sqrt x - sqrt y
  elif (br:=stdlib::radsimp_matchsqrt (e))<> FAIL
    and (br1 := stdlib::radsimp_match2sqrt (br)) <> FAIL // returns a b r
    and is(br1[1] > 0) = TRUE
    and is(br1[2] < 0) = TRUE
    and is((br := br1[1]^2 - br1[2]^2 * br1[3]) >= 0) = TRUE
    // here a^2 - b^2 r
    and ((type ((br := sqrt (br))) = DOM_INT) or (type (br) = DOM_RAT))
    then
    return (sqrt ((br1[1] + br) / 2) - sqrt ((br1[1] - br) / 2)) ;
    // end of 2nd case : sqrt x - sqrt y
    // end of extension from Francois Maltey
  end_if;

 
             
  if type(a) = "_mult" then
    if options[IgnoreAnalyticConstraints] or
      is(b in Z_, Goal = TRUE) then
      return(map(a, 
      proc(u)
      begin
        if type(u) = "_power" then
          op(u, 1)^(b*op(u, 2))
        else
          u^b
        end_if  
      end_proc
      ))
    elif type(b) = DOM_RAT then
      c := op(a, nops(a));
      if testtype(c, Type::Numeric) then
        if testtype(c, Type::Real) and c < 0 then
          t := trunc(b);
          if (t <> 0) then
            return(a^t*a^(b-t))
          end_if;
        end_if;
      end_if;
    end_if;

    p := 1;
    aa := 1;
    complexpart :=1;
    for q in a do
      if is(q >= 0) = TRUE then
        _aa := q^b;
        p := p*_aa
      elif is(q <= 0) = TRUE then
        // extract (-q)^b
        // consider the special case that q itself is a power with negative exponent 
        // Then we want to write (-q)^b = (-1/q)^(-b)
        if type(q) = "_power" and stdlib::hasmsign(op(q, 2)) then
          _aa:= (-1/q)^(-b)
        else  
          _aa := (-q)^b
        end_if;  
        p:= p*_aa;
        aa:= -aa;
      elif is(Re(q) > 0) = TRUE and is(Re(q/a) > 0) = TRUE then
        // use the rule a^n * b^n = (a*b)^n as long as a, b are known
        // to satisfy Re(a), Re(b) > 0
        complexpart:= complexpart * q;
        p:= p* q^b
      else
        aa := aa*q
      end_if;
    end_for;   
    return(p*aa^b)  
  end_if;

  // call a method of Simplify, to avoid code duplication
  if type(b) = DOM_RAT then 
    aa:= a^b;
    p:= Simplify::ratExponent(aa);
    if p <> aa then 
      return(p)
    end_if;
  end_if;


  
  // a ^ log(a, y) = y
  // by specification of log, a is assumed to be positive real and > 1
  // some non-symbolic cases have already been handled above
  if type(b) = "log" and op(b, 1) = a then
    return(op(b, 2))
  end_if;

  if is(a<>0) = TRUE then
    p:= exp(b*ln(a));
    if type(p) <> "exp" then
      return(p)
    end_if
  end_if;
  
  return(a^b)
  
end_proc:

// end of file 