/* The simplify attribute of abs
   Rules:
   1) abs(x) ->?-> abs(-x) : apply simplify and stdlib::normalizesign to x
*/

abs::simplify :=
  proc(a)
    local x;
  begin
    // recursively simplify the argument
    /* the double simplify is a workaround for the following simplify bug:
       simplify((x+y)^2) -> (x+y)^2, but
       simplify(-(x+y)^2) -> x^2+2*x*y+y^2
    */
//        case is(a >= 0)
//          of TRUE do
//            return(a);
//          of FALSE do
//            return(-a);
//        end_case;
      
    x := simplify(-simplify(-op(a)));
    // Next, recursively normalize minus signs:
    x := stdlib::normalizesign(x);
    // result:  x = [+-1, -+x]
    return(abs(x[2]))
  end_proc:
