arcsinh::simplify:=
proc(a: "arcsinh", options = simplify::defaultOptions: DOM_TABLE)
  local x;
begin
  x:= op(a, 1);  // a = arcsinh(x)

  if type(x) = "sinh" then // x = sinh(y) 
    x:= op(x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> -PI/2 and Im(x)< PI/2) or
          (Im(x)> -PI/2 and Im(x)<=PI/2 and Re(x)>= 0) or
          (Im(x)>=-PI/2 and Im(x)< PI/2 and Re(x)<= 0) or
          (Im(x)>=-PI/2 and Im(x)<=PI/2 and Re(x) = 0)
         ) = TRUE then
      return(x)
    end_if;
  elif type(-x) = "sinh" then // x = -sinh(y) = sinh(-y)
    x:= op(-x, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> -PI/2 and Im(x)< PI/2) or
          (Im(x)> -PI/2 and Im(x)<=PI/2 and Re(x)>= 0) or
          (Im(x)>=-PI/2 and Im(x)< PI/2 and Re(x)<= 0) or
          (Im(x)>=-PI/2 and Im(x)<=PI/2 and Re(x) = 0)
         ) = TRUE then
      return(-x)
    end_if;
  elif type(x/I) = "cosh" then // x = I*cosh(y) = sinh(I*PI/2 -/+ y) 
    x:= op(x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> 0 and Im(x)< PI) or
          (Im(x)> 0 and Im(x)<=PI and Re(x)>= 0) or
          (Im(x)>=0 and Im(x)< PI and Re(x)<= 0) or
          (Im(x)>=0 and Im(x)<=PI and Re(x) = 0)
         ) = TRUE then
      return(I*PI/2 - x)
    end_if;
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> -PI and Im(x)< 0) or
          (Im(x)> -PI and Im(x)<=0 and Re(x)>= 0) or
          (Im(x)>=-PI and Im(x)< 0 and Re(x)<= 0) or
          (Im(x)>=-PI and Im(x)<=0 and Re(x) = 0) 
         ) = TRUE then
      return(I*PI/2 + x)
    end_if;
  elif type(-x/I) = "cosh" then // x = -I*cosh(y) = sinh(-I*PI/2 +/- y) 
    x:= op(-x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> 0 and Im(x)< PI) or
          (Im(x)> 0 and Im(x)<=PI and Re(x)>= 0) or
          (Im(x)>=0 and Im(x)< PI and Re(x)<= 0) or
          (Im(x)>=0 and Im(x)<=PI and Re(x) = 0)
         ) = TRUE then
      return(-I*PI/2 + x)
    end_if;
    if options[IgnoreAnalyticConstraints] or
       is((Im(x)> -PI and Im(x)< 0) or
          (Im(x)> -PI and Im(x)<=0 and Re(x)>= 0) or
          (Im(x)>=-PI and Im(x)< 0 and Re(x)<= 0) or
          (Im(x)>=-PI and Im(x)<=0 and Re(x) = 0) 
         ) = TRUE then
      return(-I*PI/2 - x)
    end_if;
  elif type(x/I) = "sin" then // x = I*sin(y) = sinh(y*I)
    x:= op(x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)> -PI/2 and Re(x)< PI/2) or
          (Re(x)>=-PI/2 and Re(x)< PI/2 and Im(x)>=0) or
          (Re(x)> -PI/2 and Re(x)<=PI/2 and Im(x)<=0) or
          (Re(x)>=-PI/2 and Re(x)<=PI/2 and Im(x) =0)
         ) = TRUE then
      return(x*I)
    end_if;
  elif type(-x/I) = "sin" then // x = -I*sin(y) = sinh(-y*I)
    x:= op(-x/I, 1);
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)> -PI/2 and Re(x)< PI/2) or
          (Re(x)>=-PI/2 and Re(x)< PI/2 and Im(x)>=0) or
          (Re(x)> -PI/2 and Re(x)<=PI/2 and Im(x)<=0) or
          (Re(x)>=-PI/2 and Re(x)<=PI/2 and Im(x) =0)
         ) = TRUE then
      return(-x*I)
    end_if;
  elif type(x/I) = "cos" then // I*cos(y) = sinh(I*PI/2 -/+ I*y)
    x:= op(x/I, 1);
    // The following simplification is valid for Im(x) = 0 and 0 <= Re(x) <= PI
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)> 0 and Re(x)< PI) or
          (Re(x)>=0 and Re(x)< PI and Im(x)>=0) or
          (Re(x)> 0 and Re(x)<=PI and Im(x)<=0) or
          (Re(x)>=0 and Re(x)<=PI and Im(x) =0) 
         ) = TRUE then
      return(I*PI/2 - I*x)
    end_if;
    // The following simplification is valid for Im(x) = 0 and  -PI <= Re(x) <= 0
    if is((Re(x)> -PI and Re(x)< 0) or
          (Re(x)>=-PI and Re(x)< 0 and Im(x)>=0) or
          (Re(x)> -PI and Re(x)<=0 and Im(x)<=0) or
          (Re(x)>=-PI and Re(x)<=0 and Im(x) =0) 
         ) = TRUE then
      return(I*PI/2 + I*x)
    end_if;
  elif type(-x/I) = "cos" then // -I*cos(y) = sinh(-I*PI/2 +/- I*y)
    x:= op(-x/I, 1);
    // The following simplification is valid for Im(x) = 0 and 0 <= Re(x) <= PI
    if options[IgnoreAnalyticConstraints] or
       is((Re(x)> 0 and Re(x)< PI) or
          (Re(x)>=0 and Re(x)< PI and Im(x)>=0) or
          (Re(x)> 0 and Re(x)<=PI and Im(x)<=0) or
          (Re(x)>=0 and Re(x)<=PI and Im(x) =0) 
         ) = TRUE then
      return(-I*PI/2 + I*x)
    end_if;
    // The following simplification is valid for Im(x) = 0 and  -PI <= Re(x) <= 0
    if is((Re(x)> -PI and Re(x)< 0) or
          (Re(x)>=-PI and Re(x)< 0 and Im(x)>=0) or
          (Re(x)> -PI and Re(x)<=0 and Im(x)<=0) or
          (Re(x)>=-PI and Re(x)<=0 and Im(x) =0) 
         ) = TRUE then
      return(-I*PI/2 - I*x)
    end_if;
  end_if;
  // default
  return(a);
end_proc:
