/* 
simplify::expandComplexity(u)

 u - arithmetical expression

 predict the number of terms of expand(u, ArithmeticOnly)
 result is only a rough estimate, but can be computed fast
*/

simplify::expandComplexity:=
proc(u)
begin
  if type(u) = "_plus" or type(u) = "_mult" then 
    map(u, simplify::expandComplexity)
  elif type(u) = "_power" and type(op(u, 2)) = DOM_INT then 
    abs(op(u, 2))*simplify::expandComplexity(op(u, 1))
  else 
    1
  end_if
end_proc:
