
// max::simplify

/*
   simplify(max(a1, ..., an))

   calls is(ai >= aj) for all pairs ai, aj, in order to detect
   non-maximal elements aj that can be removed
*/


max::simplify:=
proc(e)
  name max::simplify;
  local s,olds,x,y, i;
begin
  s:={op(e)};
  repeat
    olds:=s;
    i:=0;
    while i< nops(s) do
      i:= i+1;
      x:= op(s, i);
      // we should not use "for x in s" here,as s is updated below
      // and the loop would run over the original s!
      for y in s minus {x} do
        if type(y)="min" then
          if contains({op(y)},x) then
            s:=s minus {y}
          end_if
        elif is(x - y >= 0)=TRUE then
          s:=s minus {y}
        end_if
      end_for
    end_while
  until s=olds or nops(s)=1 end_repeat;
  if nops(s)=1 then
    op(s)
  else
    max(op(s))
  end_if
end_proc:
