// 

/* ignoreSingularities gibt an, ob Singularitten beim "quivalenten" Umformen ignoriert werden sollen
 * z.B.:
 * a/b = 0    => a=0
 * 1/a = 1/b => a=b
 * etc
 */
simplify::ignoreSingularities := TRUE:
simplify::ignoreImplicitR_Property := FALSE:

alias( simplifySyntactically = simplify::simplifyCondition::simplifySyntactically ):

simplify::simplifyCondition := proc( cond ) /* options: UseSolver=TRUE */
  local i, s, v, ncond,
            necessary, defaultValuation,
            _simplifyConditionForIdent, _simplifyCondition,
            _simplifyConditionSet, _simplifyConditionMapToSet,
            __simplifyConditionMapToSet, 
            isReal, typereal, _typereal, /*proc */
            result, /* Ergebnis */
            inds, /* idents of cond */
            typecond, /* type(cond) */
            realvars, /* set of all vars which are of Type::Real */
            unrealvars, /* set of all vars which are NOT of Type::Real */
          OPTIONS, /* optionen */
          decide, _decide; /* proc */

  begin
  /* map through cond and decide all constant relations */
  cond := misc::maprec( cond,
    {"_leequal", "_less", "_equal", "_unequal"} = proc(cond)
      local inds, v;
    begin
      /* skip conditions like (a<b)<c or a<(b<c) */
      if contains( {"_leequal", "_less", "_equal", "_unequal"}, type( op(cond,1) ) ) then
        return(cond);
      end_if;
      if contains( {"_leequal", "_less", "_equal", "_unequal"}, type( op(cond,2) ) ) then
        return(cond);
      end_if;
      /* schneller Test auf konstante Relationen */
      inds := indets( cond ) minus Type::ConstantIdents;
      if inds={} then
        /* this is necessary to have true for infinity = infinity */
        if op(cond,1)=op(cond,2) or ( has(cond,infinity) and float(op(cond,1))=float(op(cond,2)) ) then
          case type(cond)
            of "_equal" do
              return(TRUE);
            of "_leequal" do
              if op(cond,1)=infinity
                or op(cond,1)=RD_INF
                or property::_typereal( op(cond,1) )=TRUE and property::_typereal( op(cond,2) )=TRUE then
                return(TRUE);
              end_if;
              break;
            of "_unequal" do
            of "_less" do
              return(FALSE);
          end_case;
        end_if;
        /* FIX: korrektes verhalten fr infinity,-infinity */
        if not has(cond,infinity) then
          if ( type(cond)="_less" or type(cond)="_leequal" ) and (property::_typereal( op(cond,1) ) and property::_typereal( op(cond,2) ) )=FALSE then
            return( FALSE );
          end_if;
        end_if;
        v := property::constRel( cond );
        if v<>UNKNOWN then return( v ); end_if;
      end_if;
      cond;
    end_proc, PostMap );

  typecond := type(cond);
  /* if "cond" has been decided by the prior call to misc::maprec, quit now */
  if typecond=DOM_BOOL or cond=Otherwise then return(cond); end_if;

  /* prepore wrappers for functions with option remember */
  inds := indets( cond ) minus Type::ConstantIdents;
  _decide := proc() option remember; begin property::_decide(args()); end_proc;
  decide := cond -> _decide(cond, table( "realvars" = realvars, "unrealvars"=unrealvars ) );
  _typereal := proc() option remember; begin property::_typereal(args()); end_proc;
  typereal := xpr -> _typereal(xpr, table( "realvars" = realvars, "unrealvars"=unrealvars ) );
  isReal := xpr -> bool( _typereal(xpr, table( "realvars" = realvars, "unrealvars"=unrealvars, "seek"=TRUE ) )=TRUE );


  /* defaultValuation to check if a new condition looks simpler. Nice would be Simplify::defaultValuation,
   * but that would be too expensive. */
  defaultValuation := length;

  _simplifyCondition := proc( cond )
    local s, inds, i, boolExpr, ncond, val,
      options;
    save MAXEFFORT;

  begin
    options := table( "necessary" = necessary,
      "realvars" = realvars,
      "decide" = decide,
      "_typereal" = _typereal,
      "_decide" = _decide,
      "typereal" = typereal,
      "isReal" = isReal,
      "props" = property::_showprops( cond ),
      "unrealvars"=unrealvars );

    /* simplify syntactically */
    cond := simplifySyntactically( cond, options );
    if type(cond)=DOM_BOOL then return(cond); end_if;

    /* this does real interval arithmetics to decide conditions */
    cond := simplify::simplifyCondition::simplifyExpr( cond, options );

    /* this part is especially to decide conditions with chained relations, e.g. x<y and y<z and z<x */
    cond := simplify::simplifyCondition::chainedConditions( cond, options );

    /* this part solve for idents and tries to intersect/unite the sets */
    inds := indets(cond) minus Type::ConstantIdents;

          // do the simplification for ident with half of the effort, and simplifyConditionSet with the other half
          // but  never invest more than 5000 for each operation
    if nops(inds) >= 1 then
         MAXEFFORT:= MAXEFFORT/nops(inds);
    end_if;
    MAXEFFORT:= min(MAXEFFORT/2, 2000);

    if contains( {"_or","_and"}, type( cond ) ) then      
      for i in inds do
        boolExpr := type(cond);
        s := split( cond, X->contains( indets(X), i ) );
        if not contains({TRUE,FALSE}, s[1]) then
          val := _simplifyConditionForIdent( s[1], i );
          val := _simplifyConditionSet( val, TRUE, options );
          case boolExpr
            of "_or" do
              ncond := s[2] or val;
              break;
            of "_and" do
              ncond := s[2] and val;
              break;
            otherwise
              assert(FALSE);
          end_case;
          if cond<>ncond and defaultValuation( cond )>defaultValuation( ncond ) then
            cond := ncond;
            if not contains( {"_or","_and"}, type( cond ) ) then break; end_if;
          end_if;
        end_if;
      end_for;
    else
      for i in inds do          
          val := _simplifyConditionForIdent( cond, i );
          ncond := _simplifyConditionSet( val, TRUE, options );
          if defaultValuation( cond )>defaultValuation( ncond ) then
            cond := ncond;
          end_if;
      end_for;
    end_if;

    cond;
  end_proc:

  /* simplifyConditionForIdent ( cond, ident )
   */
  _simplifyConditionForIdent := proc( cond, ident )
    local i, res, v, wasAnd, t, ncond;
  begin
    t := table();
    if contains( {"_or","_and"}, type( cond ) ) then
      wasAnd := bool( type(cond)="_and" );
      ncond := map( [op(cond)], X->_if( contains( {"_or","_and"}, type(X) ), _simplifyConditionForIdent(X, ident), X )  );
      i := 1;
      while i<=nops(ncond) do
        res := _simplifyConditionMapToSet( ( v := op(ncond,i) ), ident, 1 );
        if res<>FAIL then
          t[v] := res;
          ncond[i] := null();
          i := i-1;
        end_if;
        i := i+1;
      end_while;

      if nops(t)>1 then
        v := op( map( [op(t)], op, 2 ) );
        if wasAnd then v := _intersect(v); else v := _union(v); end_if;
        cond :=( ident in v ), op(ncond);
        if wasAnd then cond := _and(cond); else cond := _or(cond); end_if;
      end_if;
    else
        res := _simplifyConditionMapToSet( cond, ident, 1, TRUE );
        if res<>FAIL then return( ident in res ); end_if;
    end_if;
    cond;
  end_proc:

  _simplifyConditionSet := proc( xpr, intersectProperties=TRUE, options )
    local l, r, ident, set, v;
  begin
    case type(xpr)
      of "_and" do
        v := map([op(xpr)], _simplifyConditionSet, TRUE, options);
        v := split(v, X->type(X)="_equal" and type(op(X,1))=DOM_IDENT and testtype(op(X,2), Type::Constant));
        if nops(v[1])=0 then
          return(_and(op(v[2])));
        end_if;
        if indets(v[2]) intersect indets(v[1]) minus Type::ConstantIdents={} then
          v := _and(op(v[2]), op(v[1]));
        else
          if traperror((v := _and(op(evalAt(v[2], op(v[1]))), op(v[1]))))<>0 then return(FALSE); end_if;
          v := simplifySyntactically(v, options);
        end_if;
        return(v);
      of "_or" do
        return( map(xpr, _simplifyConditionSet, TRUE, options) );
      of "_in" do
        break;
      otherwise
        return(xpr);
    end_case;
    set := op(xpr,2);
    ident := op(xpr,1);
    if set={} then return( FALSE ); end_if;
    if set=C_ then return( TRUE ); end_if;
    if intersectProperties and contains(necessary,ident) and necessary[ident]<>C_ then
      set :=_intersect( set, necessary[ident] );
      set := simplify::simplifySets(set);
      if _subset( necessary[ident], set )=TRUE then return(TRUE); end_if;
      if type(set)="_intersect" then
        v := contains( [op(set)], necessary[ident] );
        if v>0 then set := simplify::simplifySets( subsop( set, v=C_ ) ); end_if;
      end_if;
      if set=C_ then return( TRUE ); end_if;
      if set={} then return( FALSE ); end_if;
    else
      set := simplify::simplifySets(set);
    end_if;
    case type( set )
      of "_minus" do
        if op(set,1)=C_ or (contains(necessary,ident) and op(set,1)=necessary[ident] )  then
          return( _not( _simplifyConditionSet( ident in op(set,2), FALSE, options ) ) );
        end_if;
        return( ident in op(set,1) and _not( _simplifyConditionSet( ident in op(set,2), FALSE, options ) ) );
        break;
      of "_intersect" do:
        return( _and( op( map( [op(set)], X->_simplifyConditionSet( ident in X, FALSE, options ) ) ) ) );
      of "_union" do:
        return( _or( op( map( [op(set)], X->_simplifyConditionSet( ident in X, FALSE, options ) ) ) ) );
      of DOM_SET do:
        return(  _or( op(map( (set), X->ident = X  )) ) );
      of Dom::Interval do
        l := Dom::Interval::leftB( op(xpr,2) );
        r := Dom::Interval::rightB( op(xpr,2) );
        if l=-infinity then
          if r=infinity then
            return( op(xpr,1) in R_ );
          else
            return( _if( type(r)=DOM_LIST, op(xpr,1) <= op(r), op(xpr,1) < r ) );
          end_if;
        else
          if r=infinity then
            return( _if( type(l)=DOM_LIST, op(xpr,1) >= op(l), op(xpr,1) > l ) );
          else
          end_if;
        end_if;
        break;
    end_case;
    return( xpr );
  end_proc:

  _simplifyConditionMapToSet := proc( cond, ident, lev, singleOp=FALSE )
    local res;
  begin
    if type(cond)="_in" and op(cond,1)=ident then
      res := op(cond,2);
    else
      if singleOp and contains( {"_equal", "_unequal", "_less", "_leequal"}, type(cond) ) then
        /* this does not need to be solved if ident has a explicit representation */
        if traperror((res := poly( op(cond,1)-op(cond,2), [ident] )), MaxSteps=2)<>0 then return(FAIL); end_if;
        /* It could happen, that op(cond,1)-op(cond,2) results in "undefined" */
        if res<>FAIL and res<>undefined and degree(res)<=1 and not has(coeff(res,0), ident) then return(FAIL); end_if;
      end_if;

      res := __simplifyConditionMapToSet( cond, ident, lev, singleOp );
    end_if;

    /* don't return any sets containing indets. this should have been handled before */
    if res<>FAIL and freeIndets(res)<>{} then res:=FAIL; end_if;
    res;
  end_proc:

  __simplifyConditionMapToSet := proc( cond, ident, lev, singleOp )
    local A, lin, p;
    save MAXEFFORT;
  begin
    if type(cond)="_not" then
      A := _simplifyConditionMapToSet( op(cond), ident, lev, singleOp );
      if A=FAIL then
        return(FAIL);
      else
        return( necessary[ident] minus A );
      end_if;
    end_if;

    case lev
      of 1 do: case type( cond )
          of "_unequal" do
            if {ident} intersect indets(op(cond,1)) intersect indets(op(cond,2))={} then
              if op(cond,1)=ident then
                /* if we have only one operand this should already have been decided */
                if singleOp then return( FAIL ); end_if;
                return( C_ minus {op(cond,2)} );
              elif op(cond,2)=ident then
                /* if we have only one operand this should already have been decided */
                if singleOp then return( FAIL ); end_if;
                return( C_ minus {op(cond,1)} );
              end_if;
            end_if;
            break;
          of "_equal" do
            A := op(cond,1)-op(cond,2);
            if indets( cond ) minus Type::ConstantIdents <> {ident} then return( FAIL ); end_if;
            if ( lin := Type::Linear( A, [ident] ) )<>FALSE and lin[1]<>0 then
              return( {-lin[2]/lin[1]} );
            end_if;
            break;
          of "_less" do
            if op(cond,1)=ident and indets(op(cond,2)) minus Type::ConstantIdents={} then
              return( Dom::Interval( -infinity, op(cond,2) ) );
            end_if;
            if op(cond,2)=ident and indets(op(cond,1)) minus Type::ConstantIdents={} then
              return( Dom::Interval( op(cond,1), infinity ) );
            end_if;
            break;
          of "_leequal" do
            if op(cond,1)=ident and indets(op(cond,2)) minus Type::ConstantIdents={} then
              return( Dom::Interval( -infinity, [op(cond,2)] ) );
            end_if;
            if op(cond,2)=ident and indets(op(cond,1)) minus Type::ConstantIdents={} then
              return( Dom::Interval( [op(cond,1)], infinity ) );
            end_if;
            break;
          of "_in" do
            p := poly( op(cond,1), [ident] );
            if p=FAIL then return(FAIL); end_if;
            if degree(p)=0 then return(FAIL); end_if;
            if degree(p)=1 then
              if singleOp and contains( {R_,C_}, necessary[ident] ) then return(FAIL); end_if;
              if freeIndets(cond)<>{ident} then return(FAIL); end_if;
              A := ( op(cond,2) - coeff(p,0) ) / coeff(p,1);
              if freeIndets(A)<>{} then return(FAIL); end_if;
              return( A );
            end_if;
          end_case;

      of 2 do:
        if OPTIONS[UseSolver] then
          case type(cond)
            of "_unequal" do
              A := indets(cond) minus Type::ConstantIdents;
              if A={ident}  then
                MAXEFFORT := min(1000.0, MAXEFFORT);
                A := solve( op(cond,1)=op(cond,2), ident, MaxRecLevel = 5, IgnoreProperties, NoWarning);
                if has((A),solve) then break; end_if;
                return( necessary[ident] minus A );
              end_if;
              break;
            of "_in" do
            of "_equal" do
              A := indets(cond) minus Type::ConstantIdents;
              if A={ident}  then
                MAXEFFORT := min(1000.0, MAXEFFORT);
                A := solve(cond, ident, MaxRecLevel = 5, NoWarning);
                if has((A),solve) then break; end_if;
                return( A );
              end_if;
              break;
          end_case;
        end_if;
      break;

    end_case;
    FAIL;
  end_proc:

  if MAXEFFORT<1 then return( cond ); end_if;
  /* Optionen auslsesn */
  OPTIONS := prog::getOptions(2, [args()], table(UseSolver = bool(MAXEFFORT>100)), TRUE)[1];

  /* Get all properties. necessary is the table of all properties */
  necessary := table();
  property::_checkSanity( inds );
  for i in inds do
    necessary[i] := property::_getprop
    ( i,
     "Targets"={solvelib::BasicSet, Dom::Interval, DOM_SET, "_intersect", "_union", "_minus"},
     "Constant"=TRUE);
    if hastype(necessary[i],"solve") then
      necessary[i] := C_
    end_if;
  end_for;

  result := [];
  /* TODO: Check for performance */
  /* Get a list of all real and not real vars. I.e. a list of all variables where
   * x in R_ and a list where y not in R_. */
  realvars := map( select( {op(necessary)}, X->bool( _subset( op(X,2), R_ )=TRUE ) ), op, 1 );
  unrealvars := map(select( {op(necessary)}, X->bool(op(X,2) intersect R_={})), op, 1 );
  case typecond
    /* TODO: Duplicate case */
    of "_or" do
    of "_and" do
      if inds={} then
        /* TODO: Check why this happens? */
        s := [op(cond)]
      else
        s := [cond];
      end_if;
      /* TODO: Is this efficient? Check. */
      for i from 1 to nops(s)  do
        v := _simplifyCondition( s[i] );
        if v=TRUE or v=FALSE then
          if v=TRUE and typecond="_or" then return( TRUE ); end_if;
          if v=FALSE and typecond="_and" then return( FALSE ); end_if;
        else
          if type(v)=typecond then v:=op(v);end_if;
          result := result.[v];
        end_if;
      end_for;
      if nops(result)>1 then
        case typecond
          of "_or" do
            ncond := _or(op(result));
            break;
          of "_and" do
            ncond := _and(op(result));
            break;
          otherwise
            assert(FALSE);
        end_case;
      elif nops(result)=0 then
        bool(typecond="_and");
      else
        op(result);
      end_if;
      break;
    otherwise
      _simplifyCondition( cond );
  end_case;
end_proc:

/* Unused code. Should split conditions by identifier. I.e.
 * partition depending on identifiers. Didn't consider assumptions
 * and was removed therefore.
simplify::splitCond := proc ( cond )
  local t, i, v, ind, j;
begin
return( [cond] );
  if not contains( { "_or", "_and" }, type( cond ) ) then
    return( cond );
  end_if;
  t := table();
  for i in [op(cond)] do
    ind := indets(i) minus Type::ConstantIdents;
    v := select( [op(t)], X->op(X,1) intersect ind<>{} );
    if nops(v)=0 then
      if contains( t, ind ) then
        t[ind] := t[ind],i;
      else
        t[ind] := i;
      end_if;
    else
      for j in map( v, op, 1 ) do
        delete t[j];
        ind := ind union j;
      end_for;
      i := i, op(map( v, op, 2 ));
      t[ind] := i;
    end_if;
  end_for;
  if contains( t, {} ) then
    v := [t[{}]];
    delete t[{}];
    v.map( [op(t)], X->( _if( type( (i:=op(X,2)) )="_exprseq", op(cond,0)( i ), i ) ) );
  else
    map( [op(t)], X->( _if( type( (i:=op(X,2)) )="_exprseq", op(cond,0)( i ), i ) ) );
  end_if;
end_proc:
*/

// simplify::simplifyCondition := prog::remember( simplify::simplifyCondition, property::depends ):
simplify::simplifyCondition := funcenv( simplify::simplifyCondition ):
simplify::simplifyCondition := prog::remember( simplify::simplifyCondition, property::depends, hold(PreventRecursion), x->x):

simplify::simplifyCondition( TRUE ) := TRUE:
simplify::simplifyCondition( FALSE ) := FALSE:

simplify::simplifyCondition::simplifySyntactically := loadproc( slot(simplify::simplifyCondition,"simplifySyntactically" ), pathname("STDLIB", "SIMPLIFY","SIMPLIFYCONDITION"), "simplifySyntactically"):
simplify::simplifyCondition::simplifyExpr := loadproc( slot(simplify::simplifyCondition,"simplifyExpr" ), pathname("STDLIB", "SIMPLIFY","SIMPLIFYCONDITION"), "simplifyExpr"):
simplify::simplifyCondition::chainedConditions := loadproc( slot(simplify::simplifyCondition,"chainedConditions" ), pathname("STDLIB", "SIMPLIFY","SIMPLIFYCONDITION"), "chainedConditions"):
simplify::simplifyCondition::doubleCondlist := FALSE:
