/*  */

simplify::simplifyLogic := proc( expr )
  local simplify_or, simplify_and;
begin

  simplify_and := proc( expr : "_and" )
    local s, other, ors, c, notother;
  begin
    /* split ors and others */
    s := split( {op(expr)}, X->type(X)<>"_or" );
    other := s[1]; ors := s[2];

    /* remove redundant ors */
    ors := map( ors, X->_if( ( {op(X)} intersect other )={}, X, null() ) );
    if ors={} then return( _and( op(other) ) ); end_if;

    /* remove not possible terms */
    notother := map( other, _not );
    ors := map( ors, X->_or( op({op(X)} minus notother) ) );
    if ors={} then return( _and( op(other) ) ); end_if;

    /* ors neu sortieren */
    s := split( ors, X->type(X)<>"_or" );
    other := other union s[1];
    ors := s[2];

    /* exclude common terms */
    if nops(ors)>1 then
      c := _intersect( op(map( ors, X->{op(X)} )) );
      if c<>{} then
        ors := map( ors, X->_or( op( {op(X)} minus c ) ) );
        expr := _and( op(other), _or(op(c)) ) or _and( op(other), op(ors) );
        return( simplify::simplifyLogic(expr) );
      end_if;
    end_if;

    expr := _and( op(other), op(ors) );
  end_proc:

  simplify_or := proc( expr : "_or" )
    local s, other, ands, c, notother;
  begin
    expr := Simplify::consensus_or( expr );
    if type(expr)<>"_or" then return(expr); end_if;

    /* split ands and others */
    s := split( {op(expr)}, X->type(X)<>"_and" );
    other := s[1]; ands := s[2];

    /* remove redundant parts of the and
     * A or ( A and B ) => A */
    ands := select(ands, X->{op(X)} intersect other = {});

    /* A or ( not A and B ) => A or B */
    notother := map( other, _not );
    ands := map( ands, X->_and( op({op(X)} minus notother ) ) );

    /* Nachsortieren */
    s := split( ands, X->type(X)<>"_and" );
    other := other union s[1]; ands := s[2];

    /* exclude common terms */
    if nops(ands)>1 then
      c := _intersect( op(map( ands, X->{op(X)} )) );
      if c<>{} then
        ands := map( ands, X->_and( op( {op(X)} minus c ) ) );
        expr := _or( op(other), _and(op(c)) ) and _or( op(other), op(ands) );
        return( simplify::simplifyLogic(expr) );
      end_if;
    end_if;

    expr := _or( op(other), op(ands) );
  end_proc:

  case type(expr)
    of "_and" do expr := simplify_and(expr); break;
    of "_or" do expr := simplify_or(expr); break;
  end_case;
  expr;
end_proc: