//   

/*********************************************
_assuming(object, condition)

object - any object
condition - valid input to assume

evaluates object under the assumption that condition is
TRUE

**********************************************/


_assuming := proc(object, condition)
  option hold, noDebug;
  local ops, i, A, ind;
begin
  assume( context(condition) );

  case type(condition)
    of "_and" do
      ops := select( [op(condition)], X->type(X)="_equal" and nops( property::freeIndets(X) )=1 );
      break;
    of "_equal" do
      if nops( property::freeIndets(condition) )=1 then
        ops := [condition];
        break;
      end_if;
    otherwise
      ops := [];
  end_case;

  for i in ops do
    ind := property::freeIndets(i);
    if nops(ind)<>1 then next; end_if;
    ind := op(ind);
    if (A := Type::Linear(op(i,1)-op(i,2), [ind]))<>FALSE and A<>FAIL and A[1]<>0 then
      eval(hold(_assign)(ind, -A[2]/A[1]));
    end_if;
  end_for;

  context(object)
end_proc:
_assuming := funcenv(_assuming, builtin(1097, 40, " assuming ", "_assuming")):
